/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.CDAAdvert;
import com.sun.slp.CSAAdvert;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.ServerDATable;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Transact
implements Runnable {
    private static final Hashtable TCPSocketCache = new Hashtable();
    protected static SLPConfig config = null;
    protected SrvLocMsg msgOut = null;
    protected Vector returns = null;
    protected int[] MSTimeouts;
    protected int maxResults = 0;
    protected ServiceLocationException exErr = null;
    protected InetAddress address = null;
    boolean continueAfterFound = false;

    static Vector transactUA(Vector vector, SrvLocMsg srvLocMsg, SrvLocMsg srvLocMsg2, InetAddress inetAddress) throws ServiceLocationException {
        Vector vector2 = new Vector();
        Thread thread = null;
        Transact transact = null;
        if (srvLocMsg2 != null) {
            transact = new Transact(srvLocMsg2, vector2, config.getMulticastTimeouts(), config.getMaximumResults(), inetAddress, true);
            thread = new Thread(transact);
            thread.start();
        }
        ServiceLocationException serviceLocationException = null;
        if (vector != null) {
            serviceLocationException = Transact.transactUnicastMsg(vector, srvLocMsg, vector2, config.getMaximumResults());
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (vector2.size() <= 0) {
            short s;
            short s2;
            if (serviceLocationException != null && (s2 = serviceLocationException.getErrorCode()) != 9 && s2 != 10 && s2 != 12 && s2 != 14) {
                throw serviceLocationException;
            }
            if (transact != null && transact.exErr != null && (s = transact.exErr.getErrorCode()) != 9 && s != 10 && s != 12 && s != 14) {
                throw transact.exErr;
            }
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ServiceLocationException transactUnicastMsg(Vector vector, SrvLocMsg srvLocMsg, Vector vector2, int n) {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        DatagramSocket datagramSocket = null;
        int n2 = vector.size();
        ServiceLocationException serviceLocationException = null;
        InetAddress inetAddress = null;
        int n3 = 0;
        DATable dATable = DATable.getDATable();
        try {
            block7: for (int i = 0; i < n2 && n3 < n; ++i) {
                DATable.DARecord dARecord = (DATable.DARecord)vector.elementAt(i);
                Vector vector3 = (Vector)dARecord.daAddresses.clone();
                if (datagramSocket == null) {
                    datagramSocket = new DatagramSocket();
                }
                Enumeration enumeration = vector3.elements();
                SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
                while (enumeration.hasMoreElements()) {
                    try {
                        SrvLocMsg srvLocMsg2;
                        inetAddress = (InetAddress)enumeration.nextElement();
                        if (config.traceDATraffic()) {
                            config.writeLog("sending_da_trace", new Object[]{Integer.toHexString(srvLocHeader.xid), inetAddress});
                        }
                        if (!Transact.filterRply(srvLocMsg, srvLocMsg2 = Transact.transactDatagramMsg(datagramSocket, inetAddress, srvLocMsg), inetAddress)) continue;
                        SrvLocHeader srvLocHeader2 = srvLocMsg2.getHeader();
                        if (config.traceDATraffic()) {
                            config.writeLog("reply_da_trace", new Object[]{Integer.toHexString(srvLocHeader2.xid), inetAddress});
                        }
                        if (srvLocHeader2.overflow) {
                            if (config.traceDATraffic()) {
                                config.writeLog("tcp_send_da_trace", new Object[]{Integer.toHexString(srvLocHeader.xid), inetAddress});
                            }
                            srvLocMsg2 = Transact.transactTCPMsg(inetAddress, srvLocMsg, false);
                            if (config.traceDATraffic()) {
                                config.writeLog("tcp_reply_da_trace", new Object[]{srvLocMsg == null ? "<null>" : Integer.toHexString(srvLocHeader.xid), inetAddress});
                            }
                            if (srvLocMsg2 == null) continue;
                        }
                        SrvLocHeader srvLocHeader3 = srvLocMsg2.getHeader();
                        n3 += srvLocHeader3.iNumReplies;
                        vector2.addElement(srvLocMsg2);
                        continue block7;
                    }
                    catch (ServiceLocationException serviceLocationException2) {
                        config.writeLog("da_exception_trace", new Object[]{new Short(serviceLocationException2.getErrorCode()), inetAddress, serviceLocationException2.getMessage()});
                        short s = serviceLocationException2.getErrorCode();
                        if (s != 11) {
                            serviceLocationException = serviceLocationException2;
                        }
                        if (s != 18) continue;
                        if (config.traceDATraffic()) {
                            config.writeLog("da_drop", new Object[]{inetAddress, dARecord.scopes});
                        }
                        dATable.removeDA(inetAddress, dARecord.scopes);
                    }
                }
            }
        }
        catch (SocketException socketException) {
            serviceLocationException = new ServiceLocationException(19, "socket_creation_failure", new Object[]{inetAddress, socketException.getMessage()});
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        return serviceLocationException;
    }

    private static SrvLocMsg transactDatagramMsg(DatagramSocket datagramSocket, InetAddress inetAddress, SrvLocMsg srvLocMsg) throws ServiceLocationException {
        SrvLocMsg srvLocMsg2 = null;
        byte[] byArray = Transact.getBytes(srvLocMsg, false, false);
        byte[] byArray2 = new byte[8192];
        DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length);
        DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length, inetAddress, 427);
        int[] nArray = config.getDatagramTimeouts();
        for (int i = 0; i < nArray.length; ++i) {
            try {
                datagramSocket.setSoTimeout(nArray[i]);
                datagramSocket.send(datagramPacket2);
                datagramSocket.receive(datagramPacket);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(datagramPacket.getData()));
                srvLocMsg2 = Transact.internalize(dataInputStream, inetAddress);
                break;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!config.traceDrop() && !config.traceDATraffic()) continue;
                config.writeLog("udp_timeout", new Object[]{inetAddress});
                continue;
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{inetAddress, iOException.getMessage()};
                if (config.traceDrop() || config.traceDATraffic()) {
                    config.writeLog("datagram_io_error", objectArray);
                }
                throw new ServiceLocationException(19, "datagram_io_error", objectArray);
            }
        }
        if (srvLocMsg2 == null) {
            throw new ServiceLocationException(18, "udp_timeout", new Object[]{inetAddress});
        }
        return srvLocMsg2;
    }

    static SrvLocMsg transactTCPMsg(InetAddress inetAddress, SrvLocMsg srvLocMsg, boolean bl) throws ServiceLocationException {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        SrvLocMsg srvLocMsg2 = null;
        try {
            srvLocMsg2 = Transact.transactMsg(inetAddress, srvLocMsg, bl, true);
        }
        catch (InterruptedIOException interruptedIOException) {
            Object[] objectArray = new Object[]{inetAddress};
            if (config.traceDrop() || config.traceDATraffic()) {
                config.writeLog("tcp_timeout", objectArray);
            }
            throw new ServiceLocationException(18, "tcp_timeout", objectArray);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{inetAddress, iOException.getMessage()};
            if (config.traceDrop() || config.traceDATraffic()) {
                config.writeLog("tcp_io_error", objectArray);
            }
            throw new ServiceLocationException(19, "tcp_io_error", objectArray);
        }
        if (!Transact.filterRply(srvLocMsg, srvLocMsg2, inetAddress)) {
            return null;
        }
        return srvLocMsg2;
    }

    private static void uncacheSocket(InetAddress inetAddress, Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        TCPSocketCache.remove(inetAddress);
    }

    private static Socket getTCPSocket(InetAddress inetAddress, boolean bl) throws IOException {
        Socket socket = null;
        socket = (Socket)TCPSocketCache.get(inetAddress);
        if (socket == null) {
            socket = new Socket(inetAddress, 427);
            socket.setSoTimeout(config.getTCPTimeout());
        }
        if (bl) {
            TCPSocketCache.put(inetAddress, socket);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SrvLocMsg transactMsg(InetAddress inetAddress, SrvLocMsg srvLocMsg, boolean bl, boolean bl2) throws InterruptedIOException, IOException, ServiceLocationException {
        Socket socket = null;
        byte[] byArray = Transact.getBytes(srvLocMsg, false, true);
        try {
            socket = Transact.getTCPSocket(inetAddress, bl);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            Socket socket2 = socket;
            synchronized (socket2) {
                try {
                    dataOutputStream.write(byArray, 0, byArray.length);
                    SrvLocMsg srvLocMsg2 = Transact.internalize(dataInputStream, inetAddress);
                    return srvLocMsg2;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        Transact.uncacheSocket(inetAddress, socket);
                        socket = null;
                        if (!bl2) {
                            throw iOException;
                        }
                        SrvLocMsg srvLocMsg3 = Transact.transactMsg(inetAddress, srvLocMsg, bl, false);
                        if (socket != null && !bl) {
                            Transact.uncacheSocket(inetAddress, socket);
                        }
                        return srvLocMsg3;
                    }
                }
            }
        }
        finally {
            if (socket != null && !bl) {
                Transact.uncacheSocket(inetAddress, socket);
            }
        }
    }

    protected static byte[] getBytes(SrvLocMsg srvLocMsg, boolean bl, boolean bl2) throws ServiceLocationException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
        srvLocHeader.externalize(byteArrayOutputStream, bl, bl2);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (srvLocHeader.overflow) {
            throw new ServiceLocationException(22, "buffer_overflow", new Object[]{new Integer(byArray.length), new Integer(config.getMTU())});
        }
        return byArray;
    }

    protected static boolean filterRply(SrvLocMsg srvLocMsg, SrvLocMsg srvLocMsg2, InetAddress inetAddress) {
        SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
        SrvLocHeader srvLocHeader2 = srvLocMsg2.getHeader();
        if (srvLocMsg2 == null) {
            if (config.traceDrop()) {
                config.writeLog("reply_unparsable", new Object[]{inetAddress});
            }
            return false;
        }
        if (srvLocHeader.xid != srvLocHeader2.xid) {
            if (config.traceDrop()) {
                config.writeLog("wrong_xid", new Object[]{inetAddress});
            }
            return false;
        }
        return true;
    }

    protected static SrvLocMsg internalize(DataInputStream dataInputStream, InetAddress inetAddress) throws ServiceLocationException {
        int n = 0;
        int n2 = 0;
        SrvLocMsg srvLocMsg = null;
        SLPHeaderV2 sLPHeaderV2 = null;
        byte[] byArray = new byte[2];
        try {
            dataInputStream.readFully(byArray, 0, 2);
            n = (char)byArray[0] & 0xFF;
            n2 = (char)byArray[1] & 0xFF;
            if (n != 2) {
                throw new ServiceLocationException(9, "version_number_error", new Object[]{new Integer(n)});
            }
            sLPHeaderV2 = new SLPHeaderV2();
            ((SrvLocHeader)sLPHeaderV2).parseHeader(n2, dataInputStream);
            srvLocMsg = ((SrvLocHeader)sLPHeaderV2).parseMsg(dataInputStream);
            if (srvLocMsg != null) {
                ((SrvLocHeader)sLPHeaderV2).parseOptions(dataInputStream);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceLocationException(2, "passthrough_addr", new Object[]{illegalArgumentException.getMessage(), inetAddress});
        }
        catch (IOException iOException) {
            String string = n2 == 0 ? "???" : Integer.toString(n2);
            short s = n == 0 ? (short)19 : 2;
            throw new ServiceLocationException(s, "ioexception_parsing", new Object[]{iOException, string, inetAddress, iOException.getMessage()});
        }
        catch (ServiceLocationException serviceLocationException) {
            throw new ServiceLocationException(serviceLocationException.getErrorCode(), "passthrough_addr", new Object[]{serviceLocationException.getMessage(), inetAddress});
        }
        return srvLocMsg;
    }

    protected static void send(DatagramSocket datagramSocket, SrvLocMsg srvLocMsg, InetAddress inetAddress) throws ServiceLocationException, IOException {
        byte[] byArray = Transact.getBytes(srvLocMsg, true, false);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, 427);
        datagramSocket.send(datagramPacket);
    }

    protected static boolean addPreviousResponder(SrvLocMsg srvLocMsg, InetAddress inetAddress) {
        SrvLocHeader srvLocHeader = srvLocMsg.getHeader();
        Vector vector = srvLocHeader.previousResponders;
        String string = inetAddress.getHostAddress();
        if (vector.contains(string)) {
            if (config.traceDrop()) {
                config.writeLog("drop_pr", new Object[]{string, Integer.toHexString(srvLocHeader.xid)});
            }
            return false;
        }
        srvLocHeader.addPreviousResponder(inetAddress);
        return true;
    }

    static Vector transactActiveAdvertRequest(ServiceType serviceType, SrvLocMsg srvLocMsg, ServerDATable serverDATable) throws ServiceLocationException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Transact transact = new Transact(srvLocMsg, vector2, config.getMulticastTimeouts(), Integer.MAX_VALUE, config.getMulticastAddress(), true);
        Thread thread = new Thread(transact);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ServiceLocationException serviceLocationException = transact.exErr;
        if (serviceLocationException != null && config.traceDATraffic()) {
            config.writeLog("sdat_active_err", new Object[]{new Integer(serviceLocationException.getErrorCode()), serviceLocationException.getMessage()});
            throw serviceLocationException;
        }
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            SrvLocMsg srvLocMsg2;
            Object e = vector2.elementAt(i);
            if (serviceType.equals(Defaults.DA_SERVICE_TYPE) && !(e instanceof CDAAdvert) || serviceType.equals(Defaults.SA_SERVICE_TYPE) && !(e instanceof CSAAdvert)) {
                if (!config.traceDrop()) continue;
                config.writeLog("sdat_nonadvert_err", new Object[]{e});
                continue;
            }
            if (serviceType.equals(Defaults.DA_SERVICE_TYPE)) {
                srvLocMsg2 = (CDAAdvert)e;
                serverDATable.handleAdvertIn(srvLocMsg2);
                continue;
            }
            srvLocMsg2 = ((SrvLocMsg)e).getHeader();
            int n2 = ((SrvLocHeader)srvLocMsg2).scopes.size();
            for (int j = 0; j < n2; ++j) {
                Object e2 = ((SrvLocHeader)srvLocMsg2).scopes.elementAt(j);
                if (vector.contains(e2)) continue;
                vector.addElement(e2);
            }
        }
        return vector;
    }

    Transact(SrvLocMsg srvLocMsg, Vector vector, int[] nArray, int n, InetAddress inetAddress, boolean bl) {
        this.msgOut = srvLocMsg;
        this.returns = vector;
        this.MSTimeouts = nArray;
        this.maxResults = n;
        this.address = inetAddress;
        this.continueAfterFound = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exception exception = null;
        DatagramSocket datagramSocket = null;
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        if (config.isBroadcastOnly()) {
            Thread.currentThread().setName("SLP Broadcast Transact");
            this.address = config.getBroadcastAddress();
        } else {
            Thread.currentThread().setName("SLP Multicast Transact");
        }
        try {
            datagramSocket = config.getMulticastSocketOnInterface(config.getLocalHost(), true);
            Transact.transactConvergeMsg(this.address, datagramSocket, this.msgOut, this.returns, this.MSTimeouts, this.maxResults, this.continueAfterFound);
            datagramSocket.close();
            datagramSocket = null;
        }
        catch (ServiceLocationException serviceLocationException) {
            if (serviceLocationException.getErrorCode() != 11) {
                this.exErr = serviceLocationException;
                exception = serviceLocationException;
            }
        }
        catch (Exception exception2) {
            exception = exception2;
            this.exErr = new ServiceLocationException(20, "passthrough", new Object[]{exception2.getMessage()});
        }
        finally {
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        if (exception != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            config.writeLog("multicast_error", new Object[]{exception.getMessage(), stringWriter.toString()});
        }
    }

    public static void transactConvergeMsg(InetAddress inetAddress, DatagramSocket datagramSocket, SrvLocMsg srvLocMsg, Vector vector, int[] nArray, int n, boolean bl) throws ServiceLocationException {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        int n2 = 0;
        int n3 = 0;
        SrvLocMsg srvLocMsg2 = null;
        Object var10_10 = null;
        int n4 = config.getMulticastMaximumWait();
        long l = System.currentTimeMillis();
        int n5 = config.getMTU();
        try {
            Transact.send(datagramSocket, srvLocMsg, inetAddress);
            ++n3;
            long l2 = System.currentTimeMillis();
            while (n2 < n) {
                InetAddress inetAddress2;
                byte[] byArray = new byte[n5];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                int n6 = Transact.getTimeout(l, l2, n4, nArray);
                if (n6 < 0) break;
                datagramSocket.setSoTimeout(n6);
                try {
                    datagramSocket.receive(datagramPacket);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if ((bl || n2 <= 0) && (int)(System.currentTimeMillis() - l) <= n4 && n3 < 3) {
                        Transact.send(datagramSocket, srvLocMsg, inetAddress);
                        ++n3;
                        l2 = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(datagramPacket.getData()));
                srvLocMsg2 = Transact.internalize(dataInputStream, inetAddress2 = datagramPacket.getAddress());
                if (!Transact.filterRply(srvLocMsg, srvLocMsg2, inetAddress2) || !Transact.addPreviousResponder(srvLocMsg, inetAddress2)) continue;
                SrvLocHeader srvLocHeader = srvLocMsg2.getHeader();
                if (srvLocHeader.overflow) {
                    srvLocMsg2 = Transact.transactTCPMsg(inetAddress2, srvLocMsg, false);
                    if (srvLocMsg2 == null) continue;
                    srvLocHeader = srvLocMsg2.getHeader();
                }
                if (vector.size() < n) {
                    vector.addElement(srvLocMsg2);
                }
                n2 += srvLocHeader.iNumReplies;
                if (bl) continue;
                break;
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            if (serviceLocationException.getErrorCode() == 100) {
                return;
            }
            throw serviceLocationException;
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(19, "ioexception_conv", new Object[]{iOException, iOException.getMessage()});
        }
    }

    private static int getTimeout(long l, long l2, int n, int[] nArray) {
        int n2 = (int)(l2 - l);
        if (n < n2) {
            return -1;
        }
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = (n3 += nArray[i]) - n2;
            if (n2 >= n3) continue;
            if (n < n2 + n4) {
                return n - n2;
            }
            return n4;
        }
        return -1;
    }

    static {
        config = SLPConfig.getSLPConfig();
    }
}

