/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.CSrvMsg;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.Transact;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class SunDATable
extends DATable {
    static final String SCOPES_ID = "424242SUN-TABLE-SCOPES424242";
    static final String VERSION_ID = "424242SUN-TABLE-VERSION424242";
    private Vector saOnlyScopes = conf.getSAOnlyScopes();
    private Vector cache = null;
    private long timeStamp = -1L;

    SunDATable() throws ServiceLocationException {
        Assert.slpassert(this.saOnlyScopes.size() > 0, "no_sa_scopes", new Object[0]);
        this.cache = this.getWireTable(conf.getConfiguredScopes(), 2);
    }

    @Override
    synchronized Hashtable findDAScopes(Vector vector) throws ServiceLocationException {
        Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
        Vector vector2 = null;
        if (this.timeStamp <= System.currentTimeMillis()) {
            Vector vector3 = conf.getConfiguredScopes();
            this.cache = this.getWireTable(vector3, 2);
        }
        vector2 = (Vector)this.cache.clone();
        Vector vector4 = (Vector)vector.clone();
        for (int i = 0; i < vector2.size(); ++i) {
            DATable.DARecord dARecord = (DATable.DARecord)vector2.elementAt(i);
            Vector vector5 = (Vector)dARecord.scopes.clone();
            SunDATable.filterScopes(vector4, vector5, true);
            SunDATable.filterScopes(vector5, vector, false);
            if (vector5.size() > 0) continue;
            vector2.removeElementAt(i);
            --i;
        }
        if (vector4.size() > 0) {
            hashtable.put("&&**^^MULTICASTxxxKEY^^**&&", vector4);
        }
        if (vector2.size() > 0) {
            hashtable.put("&&**^^UNICASTxxxKEY^^**&&", vector2);
        }
        return hashtable;
    }

    @Override
    boolean removeDA(InetAddress inetAddress, Vector vector) {
        boolean bl = false;
        block0: for (int i = 0; i < this.cache.size(); ++i) {
            DATable.DARecord dARecord = (DATable.DARecord)this.cache.elementAt(i);
            Vector vector2 = dARecord.daAddresses;
            int n = vector2.size();
            for (int j = 0; j < n; ++j) {
                InetAddress inetAddress2 = (InetAddress)vector2.elementAt(j);
                if (!inetAddress.equals(inetAddress2)) continue;
                bl = true;
                vector2.removeElementAt(j);
                if (vector2.size() > 0) continue block0;
                this.cache.removeElementAt(i);
                continue block0;
            }
        }
        return bl;
    }

    private Vector getWireTable(Vector vector, int n) throws ServiceLocationException {
        Vector vector2 = new Vector();
        CSrvMsg cSrvMsg = this.getSrvReply(vector, n);
        this.processReply(cSrvMsg, vector2);
        return vector2;
    }

    private CSrvMsg getSrvReply(Vector vector, int n) throws ServiceLocationException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append("(");
            stringBuffer.append(SCOPES_ID);
            stringBuffer.append("=");
            stringBuffer.append((String)vector.elementAt(n2));
            stringBuffer.append(")");
        }
        if (n2 > 1) {
            stringBuffer.insert(0, "(|");
            stringBuffer.append(")");
        }
        if (n2 > 0) {
            stringBuffer.insert(0, "(&");
        }
        stringBuffer.append("(");
        stringBuffer.append(VERSION_ID);
        stringBuffer.append("=");
        stringBuffer.append(new Integer(n).toString());
        stringBuffer.append(")");
        if (n2 > 0) {
            stringBuffer.append(")");
        }
        CSrvMsg cSrvMsg = new CSrvMsg(Defaults.locale, Defaults.SUN_DA_SERVICE_TYPE, this.saOnlyScopes, stringBuffer.toString());
        SrvLocMsg srvLocMsg = Transact.transactTCPMsg(conf.getLoopback(), cSrvMsg, true);
        if (srvLocMsg == null || srvLocMsg.getErrorCode() != 0) {
            short s = srvLocMsg == null ? (short)20 : (short)srvLocMsg.getErrorCode();
            throw new ServiceLocationException(s, "loopback_error", new Object[]{new Short(s)});
        }
        return (CSrvMsg)srvLocMsg;
    }

    private void processReply(CSrvMsg cSrvMsg, Vector vector) throws ServiceLocationException {
        int n = Integer.MAX_VALUE;
        Vector vector2 = cSrvMsg.serviceURLs;
        int n2 = vector2.size();
        for (int i = 0; i < n2; ++i) {
            ServiceURL serviceURL = (ServiceURL)vector2.elementAt(i);
            int n3 = serviceURL.getLifetime();
            if (n3 < n) {
                n = n3;
            }
            String string = serviceURL.getHost();
            String string2 = serviceURL.getURLPath();
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(1, string2.length()), ";");
            Vector vector3 = null;
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                ServiceLocationAttribute serviceLocationAttribute = new ServiceLocationAttribute("(" + string3 + ")", false);
                String string4 = serviceLocationAttribute.getId();
                Vector vector4 = serviceLocationAttribute.getValues();
                if (string4.equals(SCOPES_ID)) {
                    vector3 = vector4;
                    continue;
                }
                throw new ServiceLocationException(2, "loopback_parse_error", new Object[]{serviceURL});
            }
            SunDATable.addToEquivClass(string, vector3, vector);
        }
        this.timeStamp = System.currentTimeMillis() + (long)(n * 1000);
    }
}

