/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.Defaults;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsg;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

abstract class SrvLocHeader
implements SrvLocMsg,
Cloneable {
    private static final Hashtable classTable = new Hashtable();
    static final int XID_OFFSET = 10;
    static int VERSION_FUNCTION_BYTES = 2;
    static final int SrvReq = 1;
    static final int SrvRply = 2;
    static final int SrvReg = 3;
    static final int SrvDereg = 4;
    static final int SrvAck = 5;
    static final int AttrRqst = 6;
    static final int AttrRply = 7;
    static final int DAAdvert = 8;
    static final int SrvTypeRqst = 9;
    static final int SrvTypeRply = 10;
    static final int SAAdvert = 11;
    static final String[] functionCodeAbbr = new String[]{"0", "SrvReq", "SrvRply", "SrvReg", "SrvDereg", "SrvAck", "AttrRqst", "AttrRply", "DAAdvert", "SrvTypeRqst", "SrvTypeRply", "SAAdvert"};
    protected static final int BYTE_SIZE = 1;
    protected static final int SHORT_SIZE = 2;
    protected static final int INT24_SIZE = 3;
    int version = 0;
    int functionCode = 0;
    int length = 0;
    short xid = 0;
    short errCode = 0;
    Locale locale = Defaults.locale;
    Vector previousResponders = null;
    Vector scopes = null;
    boolean overflow = false;
    boolean fresh = false;
    boolean mcast = false;
    byte[] payload = new byte[0];
    int nbytes = 0;
    int packetLength = SLPConfig.getSLPConfig().getMTU();
    int iNumReplies = 0;
    protected static short uniqueXID = 0;
    private String msgType;
    private String msgDescription;

    SrvLocHeader() {
    }

    @Override
    public SrvLocHeader getHeader() {
        return this;
    }

    @Override
    public short getErrorCode() {
        return this.errCode;
    }

    public int getNumReplies() {
        return this.iNumReplies;
    }

    static void addHeaderClass(String string, int n) {
        try {
            Class<?> clazz = Class.forName(string);
            classTable.put(new Integer(n), clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.slpassert(false, "no_class", new Object[]{string});
        }
    }

    static SrvLocHeader newInstance(int n) {
        try {
            Class clazz = (Class)classTable.get(new Integer(n));
            if (clazz == null) {
                return null;
            }
            SrvLocHeader srvLocHeader = (SrvLocHeader)clazz.newInstance();
            return srvLocHeader;
        }
        catch (Exception exception) {
            SLPConfig.getSLPConfig().writeLog("slh_creation_exception", new Object[]{new Integer(n), exception, exception.getMessage()});
            return null;
        }
    }

    abstract void parseHeader(int var1, DataInputStream var2) throws ServiceLocationException, IOException, IllegalArgumentException;

    abstract SrvLocMsg parseMsg(DataInputStream var1) throws ServiceLocationException, IOException, IllegalArgumentException;

    abstract void externalize(ByteArrayOutputStream var1, boolean var2, boolean var3) throws ServiceLocationException;

    abstract SDAAdvert getDAAdvert(short var1, long var2, ServiceURL var4, Vector var5, Vector var6) throws ServiceLocationException;

    void parseOptions(DataInputStream dataInputStream) throws ServiceLocationException, IOException, IllegalArgumentException {
    }

    SrvLocMsg makeErrorReply(Exception exception) {
        return null;
    }

    void setPacketLength(int n) {
        if (n > 0) {
            this.packetLength = n;
        }
    }

    void addPreviousResponder(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        Assert.slpassert(this.previousResponders != null, "prev_resp_reply", new Object[0]);
        if (!this.previousResponders.contains(string)) {
            this.previousResponders.addElement(string);
        }
    }

    static synchronized short getUniqueXID() {
        if (uniqueXID == 0) {
            Random random = new Random();
            uniqueXID = (short)(random.nextInt() & 0xFFFF);
        }
        uniqueXID = (short)(uniqueXID + 1);
        return (short)(uniqueXID & 0xFFFF);
    }

    int getInt(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        int n = SrvLocHeader.getInteger(dataInputStream);
        this.nbytes += 2;
        return n;
    }

    static int getInteger(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        byte[] byArray = new byte[2];
        dataInputStream.readFully(byArray, 0, 2);
        int n = (char)byArray[0] & 0xFF;
        int n2 = (char)byArray[1] & 0xFF;
        int n3 = n << 8;
        return n3 += n2;
    }

    void putInt(int n, ByteArrayOutputStream byteArrayOutputStream) {
        SrvLocHeader.putInteger(n, byteArrayOutputStream);
        this.nbytes += 2;
    }

    static void putInteger(int n, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write((byte)((0xFF00 & n) >> 8));
        byteArrayOutputStream.write((byte)(0xFF & n));
    }

    protected int getInt24(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        byte[] byArray = new byte[3];
        dataInputStream.readFully(byArray, 0, 3);
        int n = (char)byArray[0] & 0xFF;
        int n2 = (char)byArray[1] & 0xFF;
        int n3 = (char)byArray[2] & 0xFF;
        int n4 = n << 16;
        n4 += n2 << 8;
        this.nbytes += 3;
        return n4 += n3;
    }

    protected void putInt24(int n, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write((byte)((0xFF0000 & n) >> 16));
        byteArrayOutputStream.write((byte)((0xFF00 & n) >> 8));
        byteArrayOutputStream.write((byte)(0xFF & n));
        this.nbytes += 3;
    }

    byte[] getString(StringBuffer stringBuffer, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        byte[] byArray = SrvLocHeader.getStringField(stringBuffer, dataInputStream, "UTF8");
        this.nbytes += byArray.length + 2;
        return byArray;
    }

    static byte[] getStringField(StringBuffer stringBuffer, DataInputStream dataInputStream, String string) throws ServiceLocationException, IOException {
        stringBuffer.setLength(0);
        int n = 0;
        n = SrvLocHeader.getInteger(dataInputStream);
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray, 0, n);
        stringBuffer.append(SrvLocHeader.getBytesString(byArray, string));
        return byArray;
    }

    byte[] putString(String string, ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = SrvLocHeader.putStringField(string, byteArrayOutputStream, "UTF8");
        this.nbytes += byArray.length + 2;
        return byArray;
    }

    static byte[] putStringField(String string, ByteArrayOutputStream byteArrayOutputStream, String string2) {
        byte[] byArray = SrvLocHeader.getStringBytes(string, string2);
        SrvLocHeader.putInteger(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        return byArray;
    }

    static byte[] getStringBytes(String string, String string2) {
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new byte[0];
        }
    }

    static String getBytesString(byte[] byArray, String string) {
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    protected byte[] parseCommaSeparatedListOut(Vector vector, ByteArrayOutputStream byteArrayOutputStream) {
        return this.putString(SrvLocHeader.vectorToCommaSeparatedList(vector), byteArrayOutputStream);
    }

    static String vectorToCommaSeparatedList(Vector vector) {
        int n = vector.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    static Vector parseCommaSeparatedListIn(String string, boolean bl) throws ServiceLocationException {
        if (string == null) {
            return new Vector();
        }
        if (string.length() == 0) {
            return new Vector();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",()", true);
        try {
            int n = 0;
            String string2 = "";
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("(")) {
                    if (!bl) {
                        ++n;
                    }
                    string2 = string2 + string3;
                    continue;
                }
                if (string3.equals(")")) {
                    if (!bl) {
                        --n;
                    }
                    string2 = string2 + string3;
                    continue;
                }
                if (string3.equals(",")) {
                    if (n != 0) {
                        string2 = string2 + string3;
                        continue;
                    }
                    if (string2.length() <= 0) {
                        throw new ServiceLocationException(2, "csl_syntax_error", new Object[]{string});
                    }
                    vector.addElement(string2);
                    string2 = "";
                    continue;
                }
                string2 = string2 + string3;
            }
            if (string2.length() <= 0) {
                throw new ServiceLocationException(2, "csl_syntax_error", new Object[]{string});
            }
            vector.addElement(string2);
            if (n != 0) {
                throw new ServiceLocationException(2, "csl_syntax_error", new Object[]{string});
            }
            return vector;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ServiceLocationException(2, "csl_syntax_error", new Object[]{string});
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SrvLocHeader srvLocHeader = (SrvLocHeader)super.clone();
        srvLocHeader.length = 0;
        srvLocHeader.payload = new byte[0];
        srvLocHeader.iNumReplies = 0;
        return srvLocHeader;
    }

    protected void constructDescription(String string, String string2) {
        this.msgType = string;
        this.msgDescription = string2;
    }

    public String getMsgType() {
        if (this.msgType == null) {
            if (this.functionCode > 0 && this.functionCode < functionCodeAbbr.length) {
                return functionCodeAbbr[this.functionCode];
            }
            return String.valueOf(this.functionCode);
        }
        return this.msgType;
    }

    public String getMsgDescription() {
        return this.msgDescription == null ? "" : this.msgDescription;
    }
}

