/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceType;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ServiceURL
implements Serializable {
    private static final String IPX = "ipx";
    private static final String AT = "at";
    public static final int NO_PORT = 0;
    public static final int LIFETIME_NONE = 0;
    public static final int LIFETIME_DEFAULT = 10800;
    public static final int LIFETIME_MAXIMUM = 65535;
    public static final int LIFETIME_PERMANENT = -1;
    static final int PORT_MAXIMUM = 65535;
    private ServiceType serviceType = null;
    private ServiceType originalServiceType = null;
    private String transport = "";
    private String host = "";
    private int port = 0;
    private String URLPath = "";
    private int lifetime = 10800;
    private boolean isPermanent = false;
    private boolean noDoubleSlash = false;

    public ServiceURL(String string, int n) throws IllegalArgumentException {
        Assert.nonNullParameter(string, "URL");
        if (n > 65535 || n < -1) {
            throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("lifetime_error", new Object[0]));
        }
        this.checkURLString(string);
        this.parseURL(string);
        if (n == -1) {
            this.isPermanent = true;
            n = 65535;
        }
        this.lifetime = n;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        if (!this.serviceType.isServiceURL()) {
            this.serviceType = serviceType;
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.URLPath;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public String toString() {
        return this.originalServiceType.toString() + ":/" + this.transport + (!this.noDoubleSlash ? "/" : "") + this.host + (this.port != 0 ? ":" + this.port : "") + this.URLPath;
    }

    public int hashCode() {
        return this.serviceType.hashCode() + this.transport.hashCode() + this.host.hashCode() + this.port + this.URLPath.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServiceURL)) {
            return false;
        }
        ServiceURL serviceURL = (ServiceURL)object;
        return this.serviceType.equals(serviceURL.serviceType) && this.transport.equals(serviceURL.transport) && this.host.equals(serviceURL.host) && this.port == serviceURL.port && this.noDoubleSlash == serviceURL.noDoubleSlash && this.URLPath.equals(serviceURL.URLPath);
    }

    boolean getIsPermanent() {
        return this.isPermanent;
    }

    private void checkURLString(String string) throws IllegalArgumentException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '/' || c == ':' || c == '-' || c == ':' || c == '.' || c == '%' || c == '_' || c == '\'' || c == '*' || c == '(' || c == ')' || c == '$' || c == '!' || c == ',' || c == '+' || c == '\\' || c == ';' || c == '@' || c == '?' || c == '&' || c == '=' || Character.isLetterOrDigit(c)) continue;
            SLPConfig sLPConfig = SLPConfig.getSLPConfig();
            throw new IllegalArgumentException(sLPConfig.formatMessage("url_char_error", new Object[]{new Character(c)}));
        }
    }

    private void parseURL(String string) throws IllegalArgumentException {
        block17: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
            try {
                Object object;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("/") || !string2.endsWith(":")) break block17;
                this.originalServiceType = this.serviceType = new ServiceType(string2.substring(0, string2.length() - 1));
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals("/")) break block17;
                String string4 = stringTokenizer.nextToken();
                String string5 = "";
                if (!string4.equals("/")) {
                    if (!this.serviceType.isServiceURL()) {
                        string5 = string4;
                        this.noDoubleSlash = true;
                    } else if (!string4.equalsIgnoreCase(IPX) && !string4.equalsIgnoreCase(AT)) {
                        if (!this.serviceType.isAbstractType()) break block17;
                        string5 = string4;
                        this.noDoubleSlash = true;
                    } else {
                        this.transport = string4.toLowerCase();
                        if (!stringTokenizer.nextToken().equals("/")) break block17;
                        string5 = stringTokenizer.nextToken();
                    }
                } else {
                    string5 = stringTokenizer.nextToken();
                }
                if (string5.equals("/")) {
                    this.URLPath = "/" + stringTokenizer.nextToken("");
                    return;
                }
                this.host = string5;
                if (this.transport.equals("")) {
                    object = new StringTokenizer(this.host, ":");
                    this.host = ((StringTokenizer)object).nextToken();
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        String string6 = ((StringTokenizer)object).nextToken();
                        if (((StringTokenizer)object).hasMoreTokens()) break block17;
                        try {
                            this.port = Integer.parseInt(string6);
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block17;
                        }
                        if (this.port <= 0 || this.port > 65535) break block17;
                    }
                }
                if (!stringTokenizer.hasMoreTokens()) {
                    return;
                }
                object = stringTokenizer.nextToken();
                if (((String)object).equals("/")) {
                    this.URLPath = object;
                    if (stringTokenizer.hasMoreTokens()) {
                        this.URLPath = this.URLPath + stringTokenizer.nextToken("");
                    }
                    this.URLPath = this.URLPath.trim();
                    return;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("url_syntax_error", new Object[]{string}));
            }
        }
        throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("url_syntax_error", new Object[]{string}));
    }
}

