/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Advertiser;
import com.sun.slp.CAttrMsg;
import com.sun.slp.CSrvMsg;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.Locator;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.Transact;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public abstract class ServiceLocationManager {
    protected static DATable dat = null;
    protected static SLPConfig config = null;
    protected static Hashtable locators = new Hashtable();
    protected static Hashtable advertisers = new Hashtable();
    protected static Class locatorClass = null;
    protected static Class advertiserClass = null;

    public static Locator getLocator(Locale locale) throws ServiceLocationException {
        String string;
        Locator locator;
        if (locale == null) {
            locale = config.getLocale();
        }
        if ((locator = (Locator)locators.get(string = locale.getLanguage())) == null) {
            if (locatorClass == null) {
                String string2 = System.getProperty("sun.net.slp.LocatorImpl");
                if (string2 == null) {
                    string2 = "com.sun.slp.UARequester";
                }
                locatorClass = ServiceLocationManager.getClass(string2);
            }
            if ((locator = (Locator)ServiceLocationManager.getInstance(locatorClass, locale)) != null) {
                locators.put(string, locator);
            }
        }
        return locator;
    }

    public static Advertiser getAdvertiser(Locale locale) throws ServiceLocationException {
        String string;
        Advertiser advertiser;
        if (locale == null) {
            locale = config.getLocale();
        }
        if ((advertiser = (Advertiser)advertisers.get(string = locale.getLanguage())) == null) {
            if (advertiserClass == null) {
                String string2 = System.getProperty("sun.net.slp.AdvertiserImpl");
                if (string2 == null) {
                    string2 = "com.sun.slp.SARequester";
                }
                advertiserClass = ServiceLocationManager.getClass(string2);
            }
            if ((advertiser = (Advertiser)ServiceLocationManager.getInstance(advertiserClass, locale)) != null) {
                advertisers.put(string, advertiser);
            }
        }
        return advertiser;
    }

    public static synchronized Vector findScopes() throws ServiceLocationException {
        Vector vector = null;
        vector = config.getConfiguredScopes();
        if (vector.size() <= 0 && (vector = dat.findScopes()).size() <= 0 && (vector = ServiceLocationManager.performSADiscovery()).size() <= 0) {
            vector.addElement("default");
        }
        return vector;
    }

    public static int getRefreshInterval() throws ServiceLocationException {
        Vector<String> vector = new Vector<String>();
        vector.addElement("min-refresh-interval");
        Vector vector2 = config.getSAOnlyScopes();
        CAttrMsg cAttrMsg = new CAttrMsg(Defaults.locale, Defaults.SUN_DA_SERVICE_TYPE, vector2, vector);
        CAttrMsg cAttrMsg2 = (CAttrMsg)Transact.transactTCPMsg(config.getLoopback(), cAttrMsg, true);
        if (cAttrMsg2 == null || cAttrMsg2.getErrorCode() != 0) {
            short s = cAttrMsg2 == null ? (short)20 : (short)cAttrMsg2.getErrorCode();
            throw new ServiceLocationException(s, "loopback_error", new Object[]{new Short(s)});
        }
        int n = 0;
        Vector vector3 = cAttrMsg2.attrList;
        ServiceLocationAttribute serviceLocationAttribute = vector3.size() > 0 ? (ServiceLocationAttribute)vector3.elementAt(0) : null;
        Vector vector4 = serviceLocationAttribute != null ? serviceLocationAttribute.getValues() : new Vector();
        int n2 = vector4.size();
        for (int i = 0; i < n2; ++i) {
            Integer n3 = (Integer)vector4.elementAt(i);
            int n4 = n3;
            if (n4 <= n) continue;
            n = n4;
        }
        return n;
    }

    private static Class getClass(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    private static Object getInstance(Class clazz, Locale locale) {
        Object var2_2 = null;
        if (clazz != null) {
            try {
                Class[] classArray = new Class[]{locale.getClass()};
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                Object[] objectArray = new Object[]{locale};
                var2_2 = constructor.newInstance(objectArray);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return var2_2;
    }

    private static Vector performSADiscovery() throws ServiceLocationException {
        int n;
        Vector vector = config.getTypeHint();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("(");
            stringBuffer.append("service-type");
            stringBuffer.append("=");
            stringBuffer.append(vector.elementAt(n).toString());
        }
        if (n > 1) {
            stringBuffer.insert(0, "(|");
            stringBuffer.append(")");
        }
        CSrvMsg cSrvMsg = new CSrvMsg(config.getLocale(), Defaults.SA_SERVICE_TYPE, new Vector(), stringBuffer.toString());
        Vector vector2 = Transact.transactActiveAdvertRequest(Defaults.SA_SERVICE_TYPE, cSrvMsg, null);
        return vector2;
    }

    static {
        if (config == null) {
            config = SLPConfig.getSLPConfig();
        }
        if (dat == null) {
            dat = DATable.getDATable();
        }
    }
}

