/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SLPTokenizer
implements Enumeration {
    private String str;
    private String delims;
    private boolean bRetDel;
    private int index;

    private void initialize(String string, String string2, boolean bl) {
        this.str = string;
        this.delims = string2;
        this.bRetDel = bl;
        this.index = 0;
    }

    public SLPTokenizer(String string) {
        this.initialize(string, "", false);
    }

    public SLPTokenizer(String string, String string2) {
        this.initialize(string, string2, false);
    }

    public SLPTokenizer(String string, String string2, boolean bl) {
        this.initialize(string, string2, bl);
    }

    public int countTokens() {
        int n = 0;
        if (this.str.length() < 1) {
            return 0;
        }
        char c = this.str.charAt(0);
        boolean bl = false;
        for (int i = 0; i < this.str.length(); ++i) {
            c = this.str.charAt(i);
            if (this.delims.indexOf(c) != -1) {
                if (this.bRetDel) {
                    ++n;
                }
                if (!bl) continue;
                ++n;
                bl = false;
                continue;
            }
            bl = true;
        }
        if (bl) {
            ++n;
        }
        return n;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.str.length() < 1) {
            return false;
        }
        if (this.index >= this.str.length()) {
            return false;
        }
        if (!this.bRetDel) {
            for (int i = this.index; i < this.str.length(); ++i) {
                if (this.delims.indexOf(this.str.charAt(i)) != -1) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreElements();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public String nextToken() throws NoSuchElementException {
        if (this.index >= this.str.length()) {
            throw new NoSuchElementException();
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.str.charAt(this.index);
        if (this.bRetDel) {
            if (this.delims.indexOf(c) != -1) {
                stringBuffer.append(this.str.charAt(this.index));
                ++this.index;
                return stringBuffer.toString();
            }
            while (this.index < this.str.length()) {
                c = this.str.charAt(this.index);
                if (this.delims.indexOf(c) != -1) {
                    return stringBuffer.toString();
                }
                stringBuffer.append(c);
                ++this.index;
            }
            return stringBuffer.toString();
        }
        while (this.index < this.str.length()) {
            c = this.str.charAt(this.index);
            if (this.delims.indexOf(c) != -1) {
                if (stringBuffer.length() != 0) {
                    ++this.index;
                    return stringBuffer.toString();
                }
                ++this.index;
                continue;
            }
            stringBuffer.append(c);
            ++this.index;
        }
        if (stringBuffer.length() == 0) {
            throw new NoSuchElementException();
        }
        return stringBuffer.toString();
    }

    public String nextToken(String string) throws NoSuchElementException {
        String string2 = this.delims;
        this.delims = string;
        try {
            String string3 = this.nextToken();
            this.delims = string2;
            return string3;
        }
        catch (NoSuchElementException noSuchElementException) {
            this.delims = string2;
            throw noSuchElementException;
        }
    }
}

