/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.AuthBlock;
import com.sun.slp.CAttrMsg;
import com.sun.slp.CDAAdvert;
import com.sun.slp.CSAAdvert;
import com.sun.slp.CSrvMsg;
import com.sun.slp.CSrvTypeMsg;
import com.sun.slp.SDAAdvert;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsg;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

class SLPHeaderV2
extends SrvLocHeader
implements Cloneable {
    private int optOff = 0;
    Hashtable optTable = new Hashtable();
    private static final int MAX_MESSAGE_LENGTH = 0xFFFFFF;
    static final int FLAG_BYTE = 4;
    protected static final int NOFLAG = 0;
    static final int OVERFLOW = 128;
    protected static final int FRESH = 64;
    protected static final int MCAST = 32;
    protected static final int REST_HEADER_BYTES = 12;
    protected static final int HEADER_BYTES = VERSION_FUNCTION_BYTES + 12;
    protected static final int MAX_PROTECTED_SCOPES = 255;
    protected static Hashtable optClasses = new Hashtable();
    protected static int MANDATORY_OPTION_LOW = 16384;
    protected static int MANDATORY_OPTION_HIGH = Short.MAX_VALUE;
    protected static int OPT_ID_SIZE = 2;
    protected static int OPT_OFF_SIZE = 2;

    static void registerOptionClass(int n, Class clazz) {
        Integer n2 = new Integer(n);
        optClasses.put(n2, clazz);
    }

    SLPHeaderV2() {
        this.version = 2;
    }

    @Override
    void parseHeader(int n, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        this.functionCode = n;
        this.nbytes += 2;
        this.length = this.getInt24(dataInputStream);
        byte[] byArray = new byte[2];
        dataInputStream.readFully(byArray, 0, 2);
        this.nbytes += 2;
        byte by = (byte)((char)byArray[0] & 0xFF);
        this.overflow = (by & 0x80) != 0;
        this.fresh = (by & 0x40) != 0;
        this.mcast = (by & 0x20) != 0;
        this.optOff = this.getInt24(dataInputStream);
        if (this.optOff > this.length) {
            throw new ServiceLocationException(2, "option_error", new Object[]{new Integer(this.optOff), new Integer(this.length)});
        }
        this.xid = (short)this.getInt(dataInputStream);
        StringBuffer stringBuffer = new StringBuffer();
        this.getString(stringBuffer, dataInputStream);
        this.locale = SLPConfig.langTagToLocale(stringBuffer.toString());
        this.errCode = 0;
    }

    @Override
    SrvLocMsg parseMsg(DataInputStream dataInputStream) throws ServiceLocationException, IOException, IllegalArgumentException {
        SrvLocMsg srvLocMsg = null;
        if (this.functionCode != 11) {
            this.errCode = (short)this.getInt(dataInputStream);
        }
        switch (this.functionCode) {
            case 2: {
                srvLocMsg = new CSrvMsg(this, dataInputStream);
                break;
            }
            case 7: {
                srvLocMsg = new CAttrMsg(this, dataInputStream);
                break;
            }
            case 10: {
                srvLocMsg = new CSrvTypeMsg(this, dataInputStream);
                break;
            }
            case 8: {
                srvLocMsg = new CDAAdvert((SrvLocHeader)this, dataInputStream);
                break;
            }
            case 5: {
                srvLocMsg = this;
                this.iNumReplies = 1;
                break;
            }
            case 11: {
                srvLocMsg = new CSAAdvert(this, dataInputStream);
                break;
            }
            default: {
                throw new ServiceLocationException(2, "function_code_error", new Object[]{new Integer(this.functionCode)});
            }
        }
        if (this.nbytes > this.length) {
            throw new ServiceLocationException(2, "length_overflow", new Object[]{new Integer(this.nbytes), new Integer(this.length)});
        }
        return srvLocMsg;
    }

    SLPHeaderV2(int n, boolean bl, Locale locale) throws ServiceLocationException {
        Assert.slpassert(n <= 11 && n >= 1, "function_code_error", new Object[]{new Integer(n)});
        Assert.slpassert(locale != null, "null_locale_error", new Object[0]);
        this.version = 2;
        this.functionCode = n;
        this.locale = locale;
        this.xid = SLPHeaderV2.getUniqueXID();
        this.fresh = bl;
        byte[] byArray = SLPHeaderV2.getStringBytes(SLPConfig.localeToLangTag(locale), "UTF8");
        int n2 = byArray.length + HEADER_BYTES;
        int n3 = this.packetLength - n2;
        if (n3 < 2) {
            throw new ServiceLocationException(22, "buffer_overflow", new Object[]{new Integer(n2 + 2), new Integer(this.packetLength)});
        }
    }

    @Override
    public void externalize(ByteArrayOutputStream byteArrayOutputStream, boolean bl, boolean bl2) throws ServiceLocationException {
        byte[] byArray = SLPHeaderV2.getStringBytes(SLPConfig.localeToLangTag(this.locale), "UTF8");
        int n = byArray.length;
        this.mcast = bl;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        if (this.functionCode == 5 || this.functionCode == 10 || this.functionCode == 2 || this.functionCode == 7 || this.functionCode == 8) {
            this.putInt(this.errCode, byteArrayOutputStream2);
        }
        int n2 = this.packetLength - (this.payload.length + HEADER_BYTES + n);
        Vector vector = this.previousResponders;
        if (vector != null) {
            vector = bl ? vector : new Vector();
            this.parsePreviousRespondersOut(vector, byteArrayOutputStream2, n2);
        }
        if (this.errCode == 0) {
            byteArrayOutputStream2.write(this.payload, 0, this.payload.length);
            this.optOff = this.externalizeOptions(byteArrayOutputStream2, n);
        }
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        this.length = HEADER_BYTES + n + byArray2.length;
        if (this.length > 0xFFFFFF) {
            throw new ServiceLocationException(2, "max_msg_size_exceeded", new Object[0]);
        }
        if (!bl2 && this.length > this.packetLength) {
            this.overflow = true;
            this.length = this.packetLength;
            byte[] byArray3 = new byte[this.packetLength];
            System.arraycopy(byArray2, 0, byArray3, 0, this.length - (HEADER_BYTES + n));
            byArray2 = byArray3;
        }
        byteArrayOutputStream.write((byte)(0xFF & this.version));
        byteArrayOutputStream.write((byte)(0xFF & this.functionCode));
        this.putInt24(this.length, byteArrayOutputStream);
        int n3 = 0;
        n3 = this.overflow ? (int)((byte)(n3 | 0x80)) : (int)((byte)(n3 & 0xFFFFFF7F));
        n3 = this.fresh ? (int)((byte)((n3 | 0x40) & 0xFF)) : (int)((byte)(n3 & 0xFFFFFFBF & 0xFF));
        n3 = bl ? (int)((byte)((n3 | 0x20) & 0xFF)) : (int)((byte)(n3 & 0xFFFFFFDF & 0xFF));
        byteArrayOutputStream.write((byte)(0xFF & n3));
        byteArrayOutputStream.write(0);
        this.putInt24(this.optOff, byteArrayOutputStream);
        this.putInt(this.xid, byteArrayOutputStream);
        this.putInt(n, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
    }

    @Override
    void parseOptions(DataInputStream dataInputStream) throws ServiceLocationException, IOException, IllegalArgumentException {
        if (this.optOff == 0) {
            return;
        }
        int n = 0;
        do {
            int n2 = this.getInt(dataInputStream);
            n = this.getInt(dataInputStream);
            Integer n3 = new Integer(n2);
            Class clazz = (Class)optClasses.get(n3);
            if (clazz == null) {
                if (n2 >= MANDATORY_OPTION_LOW && n2 <= MANDATORY_OPTION_HIGH) {
                    throw new ServiceLocationException(12, "v2_unsup_option", new Object[]{n3});
                }
                int n4 = this.length;
                if (n != 0) {
                    n4 = n;
                }
                dataInputStream.skipBytes(n4 - this.nbytes);
                continue;
            }
            try {
                OptionParser optionParser = (OptionParser)clazz.newInstance();
                SLPOption sLPOption = optionParser.parse(this, dataInputStream);
                this.optTable.put(n3, sLPOption);
            }
            catch (InstantiationException instantiationException) {
                throw new ServiceLocationException(20, "v2_option_inst", new Object[]{n3, instantiationException});
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ServiceLocationException(20, "v2_option_sec", new Object[]{n3, illegalAccessException});
            }
        } while (n != 0);
    }

    private int externalizeOptions(ByteArrayOutputStream byteArrayOutputStream, int n) throws ServiceLocationException {
        int n2 = 0;
        if (this.optTable.size() <= 0) {
            return n2;
        }
        n2 = HEADER_BYTES + n + byteArrayOutputStream.size();
        Enumeration enumeration = this.optTable.keys();
        int n3 = n2;
        while (enumeration.hasMoreElements()) {
            Integer n4 = (Integer)enumeration.nextElement();
            SLPOption sLPOption = (SLPOption)this.optTable.get(n4);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            sLPOption.externalize(this, byteArrayOutputStream2);
            n3 += byteArrayOutputStream2.size() + OPT_ID_SIZE + OPT_OFF_SIZE;
            this.putInt(n4, byteArrayOutputStream);
            if (enumeration.hasMoreElements()) {
                this.putInt(n3, byteArrayOutputStream);
            } else {
                this.putInt(0, byteArrayOutputStream);
            }
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
        return n2;
    }

    private void parsePreviousRespondersOut(Vector vector, ByteArrayOutputStream byteArrayOutputStream, int n) throws ServiceLocationException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray;
            object = (String)vector.elementAt(i);
            if (i > 0) {
                object = "," + (String)object;
            }
            if ((byArray = SLPHeaderV2.getStringBytes((String)object, "UTF8")).length <= n) {
                byteArrayOutputStream2.write(byArray, 0, byArray.length);
                n -= byArray.length;
                continue;
            }
            throw new ServiceLocationException(100, "v2_prev_resp_overflow", new Object[0]);
        }
        object = byteArrayOutputStream2.toByteArray();
        this.putInt(((byte[])object).length, byteArrayOutputStream);
        byteArrayOutputStream.write((byte[])object, 0, ((byte[])object).length);
        this.nbytes += ((byte[])object).length;
    }

    ServiceURL parseServiceURLIn(DataInputStream dataInputStream, Hashtable hashtable, short s) throws ServiceLocationException, IOException {
        Object[] objectArray;
        Object object;
        byte[] byArray = new byte[1];
        dataInputStream.readFully(byArray, 0, 1);
        ++this.nbytes;
        int n = this.getInt(dataInputStream);
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = this.getString(stringBuffer, dataInputStream);
        Hashtable hashtable2 = null;
        byArray = new byte[1];
        dataInputStream.readFully(byArray, 0, 1);
        ++this.nbytes;
        byte by = (byte)(byArray[0] & 0xFF);
        if (by > 0) {
            object = new ByteArrayOutputStream();
            SLPHeaderV2.putInteger(byArray2.length, (ByteArrayOutputStream)object);
            objectArray = new Object[]{((ByteArrayOutputStream)object).toByteArray(), byArray2};
            hashtable2 = this.getCheckedAuthBlockList(objectArray, by, dataInputStream);
            n = AuthBlock.getShortestLifetime(hashtable2);
        }
        object = stringBuffer.toString();
        objectArray = null;
        try {
            objectArray = new ServiceURL((String)object, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceLocationException(s, "malformed_url", new Object[]{illegalArgumentException.getMessage()});
        }
        if (hashtable2 != null) {
            hashtable.put(objectArray, hashtable2);
        }
        return objectArray;
    }

    boolean parseServiceURLOut(ServiceURL serviceURL, boolean bl, Hashtable hashtable, ByteArrayOutputStream byteArrayOutputStream, boolean bl2) throws ServiceLocationException {
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        int n = this.nbytes++;
        byte[] byArray = SLPHeaderV2.getStringBytes(serviceURL.toString(), "UTF8");
        byteArrayOutputStream2.write(0);
        this.putInt(serviceURL.getLifetime(), byteArrayOutputStream2);
        byte by = 0;
        if (bl) {
            Object[] objectArray;
            if (hashtable == null) {
                objectArray = new ByteArrayOutputStream();
                SLPHeaderV2.putInteger(byArray.length, (ByteArrayOutputStream)objectArray);
                Object[] objectArray2 = new Object[]{objectArray.toByteArray(), byArray};
                hashtable = this.getCheckedAuthBlockList(objectArray2, serviceURL.getLifetime());
            }
            by = (byte)hashtable.size();
            objectArray = AuthBlock.getContents(hashtable);
            byArray = (byte[])objectArray[1];
        }
        this.putInt(byArray.length, byteArrayOutputStream2);
        byteArrayOutputStream2.write(byArray, 0, byArray.length);
        this.nbytes += byArray.length;
        byteArrayOutputStream2.write((byte)(0xFF & by));
        ++this.nbytes;
        if (by > 0) {
            AuthBlock.externalizeAll(this, hashtable, byteArrayOutputStream2);
        }
        byArray = byteArrayOutputStream2.toByteArray();
        if (!bl2 || this.nbytes <= this.packetLength) {
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            return true;
        }
        this.nbytes = n;
        return false;
    }

    Hashtable parseAuthenticatedAttributeVectorIn(Vector vector, DataInputStream dataInputStream, boolean bl) throws ServiceLocationException, IOException {
        byte[] byArray = this.parseAttributeVectorIn(vector, dataInputStream, bl);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SLPHeaderV2.putInteger(byArray.length, byteArrayOutputStream);
        Object[] objectArray = new Object[]{byteArrayOutputStream.toByteArray(), byArray};
        return this.parseSignatureIn(objectArray, dataInputStream);
    }

    byte[] parseAttributeVectorIn(Vector vector, DataInputStream dataInputStream, boolean bl) throws ServiceLocationException, IOException {
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = this.getString(stringBuffer, dataInputStream);
        Vector vector2 = SLPHeaderV2.parseCommaSeparatedListIn(stringBuffer.toString(), false);
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector2.elementAt(i);
            vector.addElement(new ServiceLocationAttribute(string, bl));
        }
        return byArray;
    }

    byte[] parseAttributeVectorOut(Vector vector, int n, boolean bl, Hashtable hashtable, ByteArrayOutputStream byteArrayOutputStream, boolean bl2) throws ServiceLocationException {
        byte[] byArray = null;
        int n2 = 0;
        if (!bl || hashtable == null) {
            Object object;
            Vector<String> vector2 = new Vector<String>();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = (ServiceLocationAttribute)enumeration.nextElement();
                vector2.addElement(((ServiceLocationAttribute)object).externalize());
            }
            object = SLPHeaderV2.vectorToCommaSeparatedList(vector2);
            byArray = SLPHeaderV2.getStringBytes((String)object, "UTF8");
            if (bl) {
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                SLPHeaderV2.putInteger(byArray.length, byteArrayOutputStream2);
                Object[] objectArray = new Object[]{byteArrayOutputStream2.toByteArray(), byArray};
                hashtable = this.getCheckedAuthBlockList(objectArray, n);
            }
        } else {
            Object[] objectArray = AuthBlock.getContents(hashtable);
            byArray = (byte[])objectArray[1];
        }
        if (hashtable != null) {
            n2 = hashtable.size();
        }
        this.putInt(byArray.length, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        this.nbytes += byArray.length;
        if (bl2) {
            byteArrayOutputStream.write((byte)(n2 & 0xFF));
            ++this.nbytes;
        }
        if (bl && n2 > 0) {
            AuthBlock.externalizeAll(this, hashtable, byteArrayOutputStream);
        }
        return byArray;
    }

    Hashtable getCheckedAuthBlockList(Object[] objectArray, int n) throws ServiceLocationException {
        if (!SLPConfig.getSLPConfig().getHasSecurity()) {
            throw new ServiceLocationException(6, "auth_classes_missing", new Object[0]);
        }
        return AuthBlock.makeAuthBlocks(objectArray, n);
    }

    Hashtable getCheckedAuthBlockList(Object[] objectArray, byte by, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        if (!SLPConfig.getSLPConfig().getHasSecurity()) {
            throw new ServiceLocationException(6, "auth_classes_missing", new Object[0]);
        }
        return AuthBlock.makeAuthBlocks(this, objectArray, dataInputStream, by);
    }

    Hashtable parseSignatureIn(Object[] objectArray, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        Hashtable hashtable = null;
        byte[] byArray = new byte[1];
        dataInputStream.readFully(byArray, 0, 1);
        ++this.nbytes;
        byte by = (byte)(byArray[0] & 0xFF);
        if (by > 0) {
            hashtable = this.getCheckedAuthBlockList(objectArray, by, dataInputStream);
        }
        return hashtable;
    }

    void escapeTags(Vector vector) throws ServiceLocationException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof String)) {
                throw new IllegalArgumentException(SLPConfig.getSLPConfig().formatMessage("nonstring_tag", new Object[0]));
            }
            String string = ServiceLocationAttribute.escapeAttributeString((String)e, false);
            vector.setElementAt(string.trim(), i);
        }
    }

    void unescapeTags(Vector vector) throws ServiceLocationException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            string = ServiceLocationAttribute.unescapeAttributeString(string, false);
            vector.setElementAt(string.trim(), i);
        }
    }

    static void escapeScopeStrings(Vector vector) throws ServiceLocationException {
        int n = vector.size();
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            vector.setElementAt(ServiceLocationAttribute.escapeAttributeString(string, false), i);
        }
    }

    static void unescapeScopeStrings(Vector vector) throws ServiceLocationException {
        int n = vector.size();
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(i);
            vector.setElementAt(ServiceLocationAttribute.unescapeAttributeString(string, false), i);
        }
    }

    @Override
    SDAAdvert getDAAdvert(short s, long l, ServiceURL serviceURL, Vector vector, Vector vector2) throws ServiceLocationException {
        Assert.slpassert(false, "v2_daadvert_client_side", new Object[0]);
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SLPHeaderV2 sLPHeaderV2 = (SLPHeaderV2)super.clone();
        byte[] byArray = SLPHeaderV2.getStringBytes(this.locale.toString(), "UTF8");
        sLPHeaderV2.nbytes = HEADER_BYTES + byArray.length + 2;
        return sLPHeaderV2;
    }

    static interface SLPOption {
        public void externalize(SLPHeaderV2 var1, ByteArrayOutputStream var2) throws ServiceLocationException;
    }

    static interface OptionParser {
        public SLPOption parse(SLPHeaderV2 var1, DataInputStream var2) throws ServiceLocationException, IOException;
    }
}

