/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.SLPTokenizer;
import com.sun.slp.ServiceLocationAttribute;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.StderrLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

class SLPConfig {
    private int iMinMCRadius = 1;
    private int iMaxMCRadius = 255;
    private final int iMinHeart = 2000;
    private final int iMaxHeart = 259200000;
    private final int iMinDisc = 300;
    private final int iMaxDisc = 10800;
    private int iMaxDiscGran = 21600;
    private final int iMinWait = 1000;
    private final int iMaxWait = 3000;
    private static Random randomWait = null;
    private static final int iMinTimeout = 100;
    private static final int iMaxTimeout = 360000;
    private final int iMinMTU = 128;
    private final int iMaxMTU = 8192;
    protected static boolean isSA = false;
    private boolean broadcastOnly = false;
    DatagramSocket broadSocket = null;
    private Vector configuredScopes = null;
    private Vector saConfiguredScopes = null;
    private Vector saOnlyScopes = null;
    private Vector preconfiguredDAs = null;
    protected static SLPConfig theSLPConfig = null;
    private static InetAddress broadcastAddress;
    private static InetAddress multicastAddress;
    private static Vector interfaces;
    private static final int iMultiMin = 1000;
    private static final int iMultiMax = 60000;
    private static boolean securityEnabled;
    private static final String BASE_BUNDLE_NAME = "com/sun/slp/ClientLib";
    protected Writer log = new StderrLog();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SLPConfig() {
        Object object;
        Object object2;
        Properties properties = (Properties)System.getProperties().clone();
        try {
            Class.forName("com.sun.slp.Defaults");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.printMessageAndDie(this, "no_class", new Object[]{"com.sun.slp.Defaults"});
        }
        Properties properties2 = System.getProperties();
        SLPProperties sLPProperties = new SLPProperties(new Properties());
        try {
            object2 = this.getConfigURLStream();
            if (object2 != null) {
                sLPProperties.load((InputStream)object2);
                System.setProperties(sLPProperties);
            }
        }
        catch (IOException iOException) {
            this.writeLog("unparsable_config_file", new Object[]{iOException.getMessage()});
        }
        properties2.putAll((Map<?, ?>)sLPProperties);
        properties2.putAll((Map<?, ?>)properties);
        System.setProperties(properties2);
        this.configuredScopes = this.initializeScopes("net.slp.useScopes");
        this.saConfiguredScopes = (Vector)this.configuredScopes.clone();
        if (this.saConfiguredScopes.size() <= 0) {
            this.saConfiguredScopes.addElement("default");
        }
        this.saOnlyScopes = this.initializeScopes("sun.net.slp.SAOnlyScopes");
        this.preconfiguredDAs = this.initializePreconfiguredDAs();
        this.broadcastOnly = Boolean.getBoolean("net.slp.isBroadcastOnly");
        object2 = null;
        try {
            object = System.getProperty("sun.net.slp.loggerClass");
            if (object != null) {
                Class<?> clazz = Class.forName((String)object);
                if (Class.forName("java.io.Writer").isAssignableFrom(clazz)) {
                    Object obj = clazz.newInstance();
                    this.log = (Writer)obj;
                } else {
                    object2 = this.formatMessage("bad_log_class", new Object[]{clazz.toString()}) + "\n";
                }
            }
        }
        catch (Throwable throwable) {
            this.log = null;
            object2 = this.formatMessage("bad_log", new Object[]{throwable.toString()}) + "\n";
        }
        if (this.log == null) {
            this.log = new StderrLog();
            if (object2 != null) {
                try {
                    object = this.log;
                    synchronized (object) {
                        this.log.write((String)object2);
                        this.log.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private InputStream getConfigURLStream() {
        InputStream inputStream;
        block4: {
            String string = System.getProperty("sun.net.slp.configURL");
            if (string == null) {
                string = "file:/etc/inet/slp.conf";
            }
            inputStream = null;
            try {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            catch (MalformedURLException malformedURLException) {
                this.writeLog("url_malformed", new Object[]{string});
            }
            catch (IOException iOException) {
                if (string == "file:/etc/inet/slp.conf") break block4;
                this.writeLog("unparsable_config_file", new Object[]{iOException.getMessage()});
            }
        }
        return inputStream;
    }

    private boolean OKBound(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    int getIntProperty(String string, int n, int n2, int n3) {
        int n4 = Integer.getInteger(string, n);
        if (this.OKBound(n4, n2, n3)) {
            return n4;
        }
        this.writeLog("bad_prop_tag", new Object[]{string});
        return n;
    }

    int getMCRadius() {
        return this.getIntProperty("net.slp.multicastTTL", 255, this.iMinMCRadius, this.iMaxMCRadius);
    }

    int getAdvertHeartbeatTime() {
        return this.getIntProperty("net.slp.DAHeartBeat", 10800, 2000, 259200000);
    }

    int getActiveDiscoveryInterval() {
        int n = this.getIntProperty("net.slp.DAActiveDiscoveryInterval", 900, 0, 10800);
        if (n > 0 && n < 300) {
            this.writeLog("bad_prop_tag", new Object[]{"net.slp.DAActiveDiscoveryInterval"});
            return 300;
        }
        return n;
    }

    int getActiveDiscoveryGranularity() {
        return this.getIntProperty("sun.net.slp.DAActiveDiscoveryGranularity", 900, 0, this.iMaxDiscGran);
    }

    int getRandomWaitBound() {
        return this.getIntProperty("net.slp.randomWaitBound", 1000, 1000, 3000);
    }

    long getRandomWait() {
        if (randomWait == null) {
            randomWait = new Random();
        }
        double d = randomWait.nextDouble();
        double d2 = this.getRandomWaitBound();
        return (long)(d2 * d);
    }

    int getTCPTimeout() {
        return this.getIntProperty("sun.net.slp.TCPTimeout", 20000, 100, 360000);
    }

    int getMTU() {
        return this.getIntProperty("net.slp.MTU", 1400, 128, 8192);
    }

    String getSerializedRegURL() {
        return System.getProperty("net.slp.serializedRegURL", null);
    }

    boolean isDA() {
        return false;
    }

    boolean isSA() {
        return isSA;
    }

    Vector getDAAttributes() {
        return this.getAttributes("net.slp.DAAttributes", Defaults.defaultDAAttributes, true);
    }

    Vector getSAAttributes() {
        return this.getAttributes("net.slp.SAAttributes", Defaults.defaultSAAttributes, false);
    }

    private Vector getAttributes(String string, Vector vector, boolean bl) {
        String string2 = System.getProperty(string);
        if (string2 == null || string2.length() <= 0) {
            return (Vector)vector.clone();
        }
        try {
            Vector vector2 = SrvLocHeader.parseCommaSeparatedListIn(string2, false);
            Vector<ServiceLocationAttribute> vector3 = new Vector<ServiceLocationAttribute>();
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                String string3 = (String)vector2.elementAt(i);
                ServiceLocationAttribute serviceLocationAttribute = new ServiceLocationAttribute(string3, false);
                if (bl && serviceLocationAttribute.getId().equals("min-refresh-interval")) {
                    int n2;
                    Object e;
                    Vector vector4 = serviceLocationAttribute.getValues();
                    boolean bl2 = true;
                    if (vector4 != null && vector4.size() == 1 && (e = vector4.elementAt(0)) instanceof Integer && (n2 = ((Integer)e).intValue()) >= 0 && n2 <= 65535) {
                        bl2 = false;
                    }
                    if (bl2) {
                        throw new ServiceLocationException(2, "syntax_error_prop", new Object[]{string, vector3});
                    }
                }
                vector3.addElement(serviceLocationAttribute);
            }
            return vector3;
        }
        catch (Exception exception) {
            this.writeLog("syntax_error_prop", new Object[]{string, string2});
            return (Vector)vector.clone();
        }
    }

    boolean isV1Supported() {
        return false;
    }

    int getServerSocketQueueLength() {
        return this.getIntProperty("sun.net.slp.serverSocketQueueLength", 10, 0, Integer.MAX_VALUE);
    }

    boolean traceAll() {
        return Boolean.getBoolean("sun.net.slp.traceALL");
    }

    boolean regTest() {
        return Boolean.getBoolean("sun.net.slp.traceALL") || Boolean.getBoolean("net.slp.traceReg");
    }

    boolean traceMsg() {
        return Boolean.getBoolean("sun.net.slp.traceALL") || Boolean.getBoolean("net.slp.traceMsg");
    }

    boolean traceDrop() {
        return Boolean.getBoolean("sun.net.slp.traceALL") || Boolean.getBoolean("net.slp.traceDrop");
    }

    boolean traceDATraffic() {
        return Boolean.getBoolean("sun.net.slp.traceALL") || Boolean.getBoolean("net.slp.traceDATraffic");
    }

    boolean passiveDADetection() {
        String string = System.getProperty("net.slp.passiveDADetection", "true");
        return string.equalsIgnoreCase("true");
    }

    boolean isBroadcastOnly() {
        return this.broadcastOnly;
    }

    DatagramSocket refreshMulticastSocketOnInterface(InetAddress inetAddress, Vector vector) {
        try {
            DatagramSocket datagramSocket = this.getMulticastSocketOnInterface(inetAddress, vector == null);
            if (vector != null && datagramSocket instanceof MulticastSocket) {
                int n = vector.size();
                MulticastSocket multicastSocket = (MulticastSocket)datagramSocket;
                for (int i = 0; i < n; ++i) {
                    InetAddress inetAddress2 = (InetAddress)vector.elementAt(i);
                    multicastSocket.joinGroup(inetAddress2);
                }
            }
            return datagramSocket;
        }
        catch (Exception exception) {
            Assert.slpassert(false, "cast_socket_failure", new Object[]{exception, exception.getMessage()});
            return null;
        }
    }

    DatagramSocket getMulticastSocketOnInterface(InetAddress inetAddress, boolean bl) throws ServiceLocationException {
        DatagramSocket datagramSocket = null;
        if (this.isBroadcastOnly()) {
            try {
                if (bl) {
                    datagramSocket = new DatagramSocket();
                }
                datagramSocket = this.broadSocket != null ? this.broadSocket : new DatagramSocket(427, SLPConfig.getBroadcastAddress());
                this.broadSocket = datagramSocket;
            }
            catch (SocketException socketException) {
                throw new ServiceLocationException(17, "socket_creation_failure", new Object[]{SLPConfig.getBroadcastAddress(), socketException.getMessage()});
            }
        } else {
            MulticastSocket multicastSocket;
            try {
                multicastSocket = bl ? new MulticastSocket() : new MulticastSocket(427);
            }
            catch (IOException iOException) {
                throw new ServiceLocationException(17, "socket_creation_failure", new Object[]{inetAddress, iOException.getMessage()});
            }
            try {
                multicastSocket.setTimeToLive(this.getMCRadius());
                multicastSocket.setInterface(inetAddress);
            }
            catch (IOException iOException) {
                throw new ServiceLocationException(17, "socket_initializtion_failure", new Object[]{inetAddress, iOException.getMessage()});
            }
            datagramSocket = multicastSocket;
        }
        return datagramSocket;
    }

    Vector getTypeHint() {
        Vector vector = new Vector();
        String string = System.getProperty("net.slp.typeHint", "");
        if (string.length() <= 0) {
            return vector;
        }
        try {
            vector = SrvLocHeader.parseCommaSeparatedListIn(string, true);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.elementAt(i);
                vector.setElementAt(new ServiceType(string2), i);
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            this.writeLog("syntax_error_prop", new Object[]{"net.slp.typeHint", string});
            vector.removeAllElements();
        }
        return vector;
    }

    Vector getConfiguredScopes() {
        return (Vector)this.configuredScopes.clone();
    }

    Vector getSAOnlyScopes() {
        return (Vector)this.saOnlyScopes.clone();
    }

    Vector getSAConfiguredScopes() {
        return (Vector)this.saConfiguredScopes.clone();
    }

    void addPreconfiguredDAScopes(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (!this.configuredScopes.contains(e)) {
                this.configuredScopes.addElement(e);
            }
            if (!this.isSA() && !this.isDA()) continue;
            Assert.slpassert(this.saConfiguredScopes.contains(e), "sa_new_scope", new Object[]{e, this.saConfiguredScopes});
        }
    }

    private Vector initializeScopes(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null || string2.length() <= 0) {
            return new Vector();
        }
        try {
            Vector vector = SrvLocHeader.parseCommaSeparatedListIn(string2, true);
            SLPHeaderV2.unescapeScopeStrings(vector);
            DATable.validateScopes(vector, SLPConfig.getLocale());
            if (vector.size() > 0) {
                return vector;
            }
        }
        catch (ServiceLocationException serviceLocationException) {
            this.writeLog("syntax_error_prop", new Object[]{string, string2});
        }
        return new Vector();
    }

    Vector getPreconfiguredDAs() {
        return (Vector)this.preconfiguredDAs.clone();
    }

    private Vector initializePreconfiguredDAs() {
        String string = System.getProperty("net.slp.DAAddresses", "");
        Vector vector = new Vector();
        string.trim();
        if (string.length() <= 0) {
            return vector;
        }
        try {
            vector = SrvLocHeader.parseCommaSeparatedListIn(string, true);
        }
        catch (ServiceLocationException serviceLocationException) {
            this.writeLog("syntax_error_prop", new Object[]{"net.slp.DAAddress", string});
            return vector;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = "";
            try {
                string2 = ((String)vector.elementAt(i)).trim();
                InetAddress inetAddress = InetAddress.getByName(string2);
                vector.setElementAt(inetAddress, i);
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                this.writeLog("resolve_failed", new Object[]{string2});
                vector.removeElementAt(i);
                --i;
            }
        }
        return vector;
    }

    boolean getSLPv1NotSupported() {
        return Boolean.getBoolean("sun.net.slp.SLPv1NotSupported");
    }

    boolean getAcceptSLPv1UnscopedRegs() {
        if (!this.getSLPv1NotSupported()) {
            return Boolean.getBoolean("sun.net.slp.acceptSLPv1UnscopedRegs");
        }
        return false;
    }

    static SLPConfig getSLPConfig() {
        if (theSLPConfig == null) {
            theSLPConfig = new SLPConfig();
        }
        return theSLPConfig;
    }

    int getMaximumResults() {
        int n = Integer.getInteger("net.slp.maxResults", Integer.MAX_VALUE);
        if (n == -1) {
            n = Integer.MAX_VALUE;
        }
        if (this.OKBound(n, 1, Integer.MAX_VALUE)) {
            return n;
        }
        this.writeLog("bad_prop_tag", new Object[]{"net.slp.maxResults"});
        return Integer.MAX_VALUE;
    }

    static Locale langTagToLocale(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken("");
            }
        }
        return new Locale(string2, string3);
    }

    static String localeToLangTag(Locale locale) {
        String string = locale.getCountry();
        string = locale.getLanguage() + (string.length() <= 0 ? "" : "-" + string);
        return string;
    }

    static Locale getLocale() {
        String string = System.getProperty("net.slp.locale");
        if (string != null && string.length() > 0) {
            return SLPConfig.langTagToLocale(string);
        }
        return Locale.getDefault();
    }

    static InetAddress getBroadcastAddress() {
        if (broadcastAddress == null) {
            try {
                broadcastAddress = InetAddress.getByName("255.255.255.255");
            }
            catch (UnknownHostException unknownHostException) {
                Assert.slpassert(false, "cast_address_failure", new Object[]{"255.255.255.255"});
            }
        }
        return broadcastAddress;
    }

    static InetAddress getMulticastAddress() {
        if (multicastAddress == null) {
            try {
                multicastAddress = InetAddress.getByName("239.255.255.253");
            }
            catch (UnknownHostException unknownHostException) {
                Assert.slpassert(false, "cast_address_failure", new Object[]{"239.255.255.253"});
            }
        }
        return multicastAddress;
    }

    Vector getInterfaces() {
        if (interfaces == null) {
            Vector vector;
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                Assert.slpassert(false, "resolve_failed", new Object[]{"localhost"});
            }
            String string = System.getProperty("net.slp.interfaces");
            interfaces = new Vector();
            if (string == null || string.length() <= 0) {
                interfaces.addElement(inetAddress);
                return interfaces;
            }
            try {
                vector = SrvLocHeader.parseCommaSeparatedListIn(string, true);
            }
            catch (ServiceLocationException serviceLocationException) {
                this.writeLog("syntax_error_prop", new Object[]{"net.slp.multicastInterfaces", string});
                interfaces.addElement(inetAddress);
                return interfaces;
            }
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                InetAddress inetAddress2;
                String string2 = (String)vector.elementAt(i);
                try {
                    inetAddress2 = InetAddress.getByName(string2);
                }
                catch (UnknownHostException unknownHostException) {
                    this.writeLog("unknown_interface", new Object[]{string2, "net.slp.multicastInterfaces"});
                    continue;
                }
                if (interfaces.contains(inetAddress2)) continue;
                if (inetAddress2.equals(inetAddress)) {
                    interfaces.insertElementAt(inetAddress2, 0);
                    continue;
                }
                interfaces.addElement(inetAddress2);
            }
        }
        return interfaces;
    }

    InetAddress getLoopback() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            Assert.slpassert(false, "resolve_failed", new Object[]{"localhost loopback"});
        }
        return inetAddress;
    }

    InetAddress getLocalHost() {
        Vector vector = this.getInterfaces();
        return (InetAddress)vector.elementAt(0);
    }

    boolean isLocalHostSource(InetAddress inetAddress) {
        if (inetAddress.equals(this.getLoopback())) {
            return true;
        }
        return interfaces.contains(inetAddress);
    }

    int getMulticastMaximumWait() {
        return this.getIntProperty("net.slp.multicastMaximumWait", 15000, 1000, 60000);
    }

    int[] getMulticastTimeouts() {
        int[] nArray = this.parseTimeouts("net.slp.multicastTimeouts", Defaults.a_iConvergeTimeout);
        nArray = this.capTimeouts("net.slp.multicastTimeouts", nArray, false, 0, 0);
        return nArray;
    }

    int[] getDatagramTimeouts() {
        int[] nArray = this.parseTimeouts("net.slp.datagramTimeouts", Defaults.a_iDatagramTimeout);
        nArray = this.capTimeouts("net.slp.datagramTimeouts", nArray, true, 1000, 60000);
        return nArray;
    }

    int[] getDADiscoveryTimeouts() {
        int[] nArray = this.parseTimeouts("net.slp.DADiscoveryTimeouts", Defaults.a_iDADiscoveryTimeout);
        nArray = this.capTimeouts("net.slp.DADiscoveryTimeouts", nArray, false, 0, 0);
        return nArray;
    }

    private int[] capTimeouts(String string, int[] nArray, boolean bl, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            n5 += nArray[n4];
        }
        if (bl) {
            if (n5 >= n && n5 <= n2) {
                return nArray;
            }
            n3 = n5 < n ? n / nArray.length : n2 / nArray.length;
            this.writeLog("capped_range_timeout_prop", new Object[]{string, String.valueOf(n5), String.valueOf(n), String.valueOf(n2), String.valueOf(nArray.length), String.valueOf(n3)});
        } else {
            n4 = this.getMulticastMaximumWait();
            if (n5 <= n4) {
                return nArray;
            }
            n3 = n4 / nArray.length;
            this.writeLog("capped_timeout_prop", new Object[]{string, String.valueOf(n5), String.valueOf(n4), String.valueOf(nArray.length), String.valueOf(n3)});
        }
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = n3;
        }
        return nArray;
    }

    private int[] parseTimeouts(String string, int[] nArray) {
        String string2 = System.getProperty(string);
        if (string2 == null || string2.length() <= 0) {
            return nArray;
        }
        Vector vector = null;
        try {
            vector = SrvLocHeader.parseCommaSeparatedListIn(string2, true);
        }
        catch (ServiceLocationException serviceLocationException) {
            this.writeLog("syntax_error_prop", new Object[]{string, string2});
            return nArray;
        }
        int n = 0;
        int[] nArray2 = new int[vector.size()];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            try {
                nArray2[n] = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                this.writeLog("syntax_error_prop", new Object[]{string, string2});
                return nArray;
            }
            if (nArray2[n] < 0) {
                this.writeLog("invalid_timeout_prop", new Object[]{string, String.valueOf(nArray2[n])});
                return nArray;
            }
            ++n;
        }
        return nArray2;
    }

    static long currentSLPTime() {
        return System.currentTimeMillis() / 1000L;
    }

    boolean getSecurityEnabled() {
        return securityEnabled;
    }

    boolean getHasSecurity() {
        return securityEnabled && new Boolean(System.getProperty("net.slp.securityEnabled", "false")) != false;
    }

    ResourceBundle getMessageBundle(Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            URL[] uRLArray = new URL[]{new URL("file:/usr/share/lib/locale/")};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            resourceBundle = ResourceBundle.getBundle(BASE_BUNDLE_NAME, locale, uRLClassLoader);
            return resourceBundle;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Missing resource bundle ``/usr/share/lib/locale/com/sun/slp/ClientLib'' for locale ``" + locale + "''; trying default...");
        }
        try {
            resourceBundle = ResourceBundle.getBundle(BASE_BUNDLE_NAME, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Missing resource bundle ``com/sun/slp/ClientLib'' for locale ``" + locale + "''");
            if (locale.equals(Defaults.locale)) {
                System.err.println("Exiting...");
                System.exit(1);
            }
            System.err.println("Using SLP default locale ``" + Defaults.locale + "''");
            resourceBundle = this.getMessageBundle(Defaults.locale);
        }
        return resourceBundle;
    }

    String formatMessage(String string, Object[] objectArray) {
        ResourceBundle resourceBundle = this.getMessageBundle(SLPConfig.getLocale());
        return SLPConfig.formatMessageInternal(string, objectArray, resourceBundle);
    }

    static void convertToString(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = objectArray[i] != null ? objectArray[i].toString() : "<null>";
        }
    }

    static String formatMessageInternal(String string, Object[] objectArray, ResourceBundle resourceBundle) {
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String string3 = "Can''t find message ``{0}''''.";
            try {
                string2 = resourceBundle.getString("cant_find_resource");
                string3 = MessageFormat.format(string2, string);
            }
            catch (MissingResourceException missingResourceException2) {
                // empty catch block
            }
            System.err.println(string3);
            System.exit(-1);
        }
        SLPConfig.convertToString(objectArray);
        return MessageFormat.format(string2, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeLog(String string, Object[] objectArray) {
        SLPConfig.convertToString(objectArray);
        try {
            Writer writer = this.log;
            synchronized (writer) {
                this.log.write(this.formatMessage(string, objectArray));
                this.log.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeLogLine(String string, Object[] objectArray) {
        try {
            String string2 = this.getMessageBundle(SLPConfig.getLocale()).getString(string);
            Writer writer = this.log;
            synchronized (writer) {
                this.log.write(this.formatMessage(string, objectArray));
                this.log.write("\n");
                this.log.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String getDateString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, SLPConfig.getLocale());
        Calendar calendar = Calendar.getInstance(SLPConfig.getLocale());
        return dateFormat.format(calendar.getTime());
    }

    static {
        interfaces = null;
        securityEnabled = true;
        try {
            Class<?> clazz = Class.forName("com.sun.slp.AuthBlock");
        }
        catch (ClassNotFoundException classNotFoundException) {
            securityEnabled = false;
        }
    }

    public static class SLPProperties
    extends Properties {
        SLPProperties(Properties properties) {
            super(properties);
        }

        @Override
        public synchronized void load(InputStream inputStream) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (bufferedReader.ready()) {
                String string;
                SLPTokenizer sLPTokenizer;
                String string2 = bufferedReader.readLine();
                if (string2.startsWith("#") || string2.startsWith(";") || string2.length() <= 0 || !(sLPTokenizer = new SLPTokenizer(string2, "=")).hasMoreTokens() || (string = sLPTokenizer.nextToken().trim()).trim().length() <= 0 || !sLPTokenizer.hasMoreTokens()) continue;
                String string3 = sLPTokenizer.nextToken().trim();
                this.setProperty(string, string3);
            }
        }
    }
}

