/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.CSrvReg;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocMsg;
import com.sun.slp.Transact;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;

class PermSARegTable
extends Thread {
    private Hashtable htRegs = new Hashtable();
    private SLPConfig config;
    private static final long INCREMENT = 32400000L;
    private static final long SLEEPY_TIME = 16200000L;
    private static final int TIME = 0;
    private static final int REG = 1;

    PermSARegTable(SLPConfig sLPConfig) {
        this.config = sLPConfig;
        this.start();
    }

    void reg(ServiceURL serviceURL, CSrvReg cSrvReg) {
        Object[] objectArray = new Object[]{new Long(System.currentTimeMillis() + 32400000L), cSrvReg};
        this.htRegs.put(serviceURL, objectArray);
    }

    void dereg(ServiceURL serviceURL) {
        this.htRegs.remove(serviceURL);
    }

    private void send(SrvLocMsg srvLocMsg) {
        InetAddress inetAddress = this.config.getLoopback();
        try {
            Transact.transactTCPMsg(inetAddress, srvLocMsg, true);
        }
        catch (ServiceLocationException serviceLocationException) {
            this.config.writeLog("periodic_exception", new Object[]{new Short(serviceLocationException.getErrorCode()), serviceLocationException.getMessage()});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.slpassert(false, "reregister_bug", new Object[0]);
        }
    }

    private synchronized void walk() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.htRegs.keys();
        while (enumeration.hasMoreElements()) {
            ServiceURL serviceURL = (ServiceURL)enumeration.nextElement();
            Object[] objectArray = (Object[])this.htRegs.get(serviceURL);
            long l2 = (Long)objectArray[0];
            if (l2 > l) continue;
            this.send((SrvLocMsg)objectArray[1]);
            objectArray[0] = new Long(l + 32400000L);
        }
    }

    @Override
    public void run() {
        this.setName("SLP PermSARegTable");
        while (true) {
            try {
                PermSARegTable.sleep(16200000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.walk();
        }
    }
}

