/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.Assert;
import com.sun.slp.SLPConfig;
import com.sun.slp.ServiceLocationException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

abstract class DATable {
    protected static DATable daTable;
    protected static SLPConfig conf;
    static final String DA_TABLE_CLASS_PROP = "sun.net.slp.DATableClass";
    static final String SA_ONLY_SCOPES_PROP = "sun.net.slp.SAOnlyScopes";
    static final String MULTICAST_KEY = "&&**^^MULTICASTxxxKEY^^**&&";
    static final String UNICAST_KEY = "&&**^^UNICASTxxxKEY^^**&&";

    DATable() {
    }

    abstract Hashtable findDAScopes(Vector var1) throws ServiceLocationException;

    abstract boolean removeDA(InetAddress var1, Vector var2);

    synchronized Vector findScopes() throws ServiceLocationException {
        Vector vector = new Vector();
        Hashtable hashtable = daTable.findDAScopes(vector);
        Vector vector2 = (Vector)hashtable.get(UNICAST_KEY);
        if (vector2 != null) {
            int n = vector2.size();
            for (int i = 0; i < n; ++i) {
                DARecord dARecord = (DARecord)vector2.elementAt(i);
                Vector vector3 = dARecord.scopes;
                int n2 = vector3.size();
                for (int j = 0; j < n2; ++j) {
                    Object e = vector3.elementAt(j);
                    if (vector.contains(e)) continue;
                    vector.addElement(e);
                }
            }
        }
        return vector;
    }

    static DATable getDATable() {
        if (daTable != null) {
            return daTable;
        }
        conf = SLPConfig.getSLPConfig();
        daTable = DATable.linkAndInstantiateFromProp();
        return daTable;
    }

    protected static DATable linkAndInstantiateFromProp() {
        String string = System.getProperty(DA_TABLE_CLASS_PROP);
        if (string == null) {
            Assert.slpassert(false, "no_da_table", new Object[]{DA_TABLE_CLASS_PROP});
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            daTable = (DATable)clazz.newInstance();
            return daTable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.slpassert(false, "no_da_table_class", new Object[]{string});
        }
        catch (InstantiationException instantiationException) {
            Assert.slpassert(false, "instantiation_exception", new Object[]{string});
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.slpassert(false, "access_exception", new Object[]{string});
        }
        return null;
    }

    public static void filterScopes(Vector vector, Vector vector2, boolean bl) {
        int n = 0;
        if (vector2 != null && vector2.size() > 0) {
            while (n < vector.size()) {
                String string = (String)vector.elementAt(n);
                if (!bl && !vector2.contains(string) || bl && vector2.contains(string)) {
                    vector.removeElementAt(n);
                    continue;
                }
                ++n;
            }
        }
    }

    static boolean addToEquivClass(String string, Vector vector, Vector vector2) {
        Vector vector3;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            if (conf.traceAll()) {
                conf.writeLog("unknown_da_address", new Object[]{string});
            }
            return false;
        }
        int n = vector2.size();
        boolean bl = false;
        DARecord dARecord = null;
        block2: for (int i = 0; i < n && !bl; ++i) {
            dARecord = (DARecord)vector2.elementAt(i);
            vector3 = dARecord.scopes;
            int n2 = vector3.size();
            for (int j = 0; j < n2; ++j) {
                String string2 = (String)vector3.elementAt(j);
                if (!vector.contains(string2)) continue block2;
            }
            bl = true;
        }
        if (!bl) {
            dARecord = new DARecord();
            dARecord.scopes = (Vector)vector.clone();
            vector2.addElement(dARecord);
        }
        if ((vector3 = conf.getInterfaces()).contains(inetAddress)) {
            dARecord.daAddresses.insertElementAt(inetAddress, 0);
        } else {
            dARecord.daAddresses.addElement(inetAddress);
        }
        return true;
    }

    static void validateScopes(Vector vector, Locale locale) throws ServiceLocationException {
        if (vector == null || vector.size() <= 0) {
            throw new ServiceLocationException(2, "no_scope_vector", new Object[0]);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (!(e instanceof String)) {
                throw new ServiceLocationException(2, "non_string_element", new Object[]{vector});
            }
            String string = (String)e;
            if (string.length() <= 0) {
                throw new ServiceLocationException(2, "null_element", new Object[]{vector});
            }
            string = string.toLowerCase(locale).trim();
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\t\r");
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                if (string2 != null) {
                    stringBuffer.append(" ");
                }
                string2 = stringTokenizer.nextToken();
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
            if (hashtable.get(string) == null) {
                hashtable.put(string, string);
                vector.setElementAt(string, i);
                continue;
            }
            vector.removeElementAt(i);
            --i;
        }
    }

    public static class DARecord {
        Vector scopes = null;
        Vector daAddresses = new Vector();
    }
}

