/*
 * Decompiled with CFR 0.152.
 */
package com.sun.slp;

import com.sun.slp.AuthBlock;
import com.sun.slp.DATable;
import com.sun.slp.Defaults;
import com.sun.slp.SLPConfig;
import com.sun.slp.SLPHeaderV2;
import com.sun.slp.ServiceLocationException;
import com.sun.slp.ServiceType;
import com.sun.slp.ServiceURL;
import com.sun.slp.SrvLocHeader;
import com.sun.slp.SrvLocMsgImpl;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

class CDAAdvert
extends SrvLocMsgImpl {
    ServiceURL URL = null;
    long timestamp = 0L;
    Vector attrs = new Vector();
    Hashtable authBlock = null;
    String spis = null;

    CDAAdvert(SrvLocHeader srvLocHeader, DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        super(srvLocHeader, 8);
        this.initialize(dataInputStream);
    }

    protected void initialize(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        SLPHeaderV2 sLPHeaderV2 = (SLPHeaderV2)this.getHeader();
        byte[] byArray = new byte[4];
        this.timestamp = CDAAdvert.getInt32(sLPHeaderV2, dataInputStream, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = sLPHeaderV2.getString(stringBuffer, dataInputStream);
        int n = this.getDAURLLifetime();
        String string = stringBuffer.toString();
        byte[] byArray3 = sLPHeaderV2.getString(stringBuffer, dataInputStream);
        sLPHeaderV2.scopes = SLPHeaderV2.parseCommaSeparatedListIn(stringBuffer.toString(), true);
        SLPHeaderV2.unescapeScopeStrings(sLPHeaderV2.scopes);
        DATable.validateScopes(sLPHeaderV2.scopes, sLPHeaderV2.locale);
        byte[] byArray4 = sLPHeaderV2.parseAttributeVectorIn(this.attrs, dataInputStream, false);
        byte[] byArray5 = sLPHeaderV2.getString(stringBuffer, dataInputStream);
        this.spis = stringBuffer.toString();
        Object[] objectArray = new Object[9];
        objectArray[0] = byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SLPHeaderV2.putInteger(byArray2.length, byteArrayOutputStream);
        objectArray[1] = byteArrayOutputStream.toByteArray();
        objectArray[2] = byArray2;
        byteArrayOutputStream = new ByteArrayOutputStream();
        SLPHeaderV2.putInteger(byArray4.length, byteArrayOutputStream);
        objectArray[3] = byteArrayOutputStream.toByteArray();
        objectArray[4] = byArray4;
        byteArrayOutputStream = new ByteArrayOutputStream();
        SLPHeaderV2.putInteger(byArray3.length, byteArrayOutputStream);
        objectArray[5] = byteArrayOutputStream.toByteArray();
        objectArray[6] = byArray3;
        byteArrayOutputStream = new ByteArrayOutputStream();
        SLPHeaderV2.putInteger(byArray5.length, byteArrayOutputStream);
        objectArray[7] = byteArrayOutputStream.toByteArray();
        objectArray[8] = byArray5;
        this.authBlock = sLPHeaderV2.parseSignatureIn(objectArray, dataInputStream);
        if (this.authBlock != null) {
            n = AuthBlock.getShortestLifetime(this.authBlock);
        }
        try {
            this.URL = new ServiceURL(string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServiceLocationException(2, "malformed_url", new Object[]{illegalArgumentException.getMessage()});
        }
        ServiceType serviceType = this.URL.getServiceType();
        if (!serviceType.equals(Defaults.DA_SERVICE_TYPE)) {
            throw new ServiceLocationException(2, "not_right_url", new Object[]{this.URL, "DA"});
        }
        sLPHeaderV2.iNumReplies = 1;
    }

    private static long getInt32(SrvLocHeader srvLocHeader, DataInputStream dataInputStream, byte[] byArray) throws ServiceLocationException, IOException {
        byArray[0] = (byte)dataInputStream.read();
        byArray[1] = (byte)dataInputStream.read();
        byArray[2] = (byte)dataInputStream.read();
        byArray[3] = (byte)dataInputStream.read();
        long l = (char)byArray[0] & 0xFF;
        long l2 = (char)byArray[1] & 0xFF;
        long l3 = (char)byArray[2] & 0xFF;
        long l4 = (char)byArray[3] & 0xFF;
        long l5 = l << 24;
        l5 += l2 << 16;
        l5 += l3 << 8;
        srvLocHeader.nbytes += 4;
        return l5 += l4;
    }

    boolean isGoingDown() {
        return this.timestamp == 0L;
    }

    boolean isUnsolicited() {
        return this.hdr.xid == 0;
    }

    void setIsUnsolicited(boolean bl) {
    }

    private int getDAURLLifetime() {
        SLPConfig sLPConfig = SLPConfig.getSLPConfig();
        int n = sLPConfig.getActiveDiscoveryInterval();
        int n2 = sLPConfig.getActiveDiscoveryGranularity();
        if (n <= 0) {
            return 65535;
        }
        int n3 = n + n2;
        return n3 > 65535 ? 65535 : n3;
    }
}

