/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.File;

class Utility {
    Utility() {
    }

    private static void loadLibrary(String[] paths, String name, boolean debug) {
        for (String p : paths) {
            File file = new File(p);
            p = file.getAbsolutePath();
            try {
                System.load(p + "/" + name);
                if (debug) {
                    System.out.println("loaded " + name + " from " + p);
                }
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
        }
        throw new UnsatisfiedLinkError("Unable to find " + name);
    }

    public static void loadLibrary(String name, boolean debug) {
        String root;
        String path = System.getProperty("java.library.path");
        path = path + ":/usr/lib/64";
        String[] paths = path.split(":");
        if (debug && (root = System.getenv("ROOT")) != null && root.length() > 0) {
            System.out.println("Prepending $ROOT to library path.");
            String[] npaths = new String[paths.length * 2];
            for (int i = 0; i < paths.length; ++i) {
                npaths[i] = root + "/" + paths[i];
                npaths[i + paths.length] = paths[i];
            }
            paths = npaths;
        }
        Utility.loadLibrary(paths, name, debug);
    }
}

