/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.opensolaris.os.dtrace.KernelStackRecord;
import org.opensolaris.os.dtrace.StackFrame;
import org.opensolaris.os.dtrace.StackValueRecord;

public final class UserStackRecord
implements StackValueRecord,
Serializable,
Comparable<UserStackRecord> {
    static final long serialVersionUID = -4195269026915862308L;
    private transient KernelStackRecord stackRecord;
    private final int processID;

    private UserStackRecord(int pid, byte[] rawBytes) {
        this.stackRecord = new KernelStackRecord(rawBytes);
        this.processID = pid;
        this.validate();
    }

    public UserStackRecord(int pid, StackFrame[] frames, byte[] rawBytes) {
        this.stackRecord = new KernelStackRecord(frames, rawBytes);
        this.processID = pid;
        this.validate();
    }

    private final void validate() {
        if (this.processID < 0) {
            throw new IllegalArgumentException("process ID is negative");
        }
    }

    @Override
    public StackFrame[] getStackFrames() {
        return this.stackRecord.getStackFrames();
    }

    void setStackFrames(StackFrame[] frames) {
        this.stackRecord.setStackFrames(frames);
    }

    @Override
    public byte[] getRawStackData() {
        return this.stackRecord.getRawStackData();
    }

    @Override
    public Object getValue() {
        return this.stackRecord.getValue();
    }

    public int getProcessID() {
        return this.processID;
    }

    @Override
    public List<StackFrame> asList() {
        return this.stackRecord.asList();
    }

    public KernelStackRecord asKernelStackRecord() {
        return this.stackRecord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UserStackRecord) {
            UserStackRecord r = (UserStackRecord)o;
            return this.stackRecord.equals(r.stackRecord);
        }
        return false;
    }

    public int hashCode() {
        return this.stackRecord.hashCode();
    }

    @Override
    public int compareTo(UserStackRecord r) {
        if (r == this) {
            return 0;
        }
        return this.stackRecord.compareTo(r.stackRecord);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.stackRecord.getStackFrames());
        s.writeObject(this.stackRecord.getRawStackData());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            StackFrame[] frames = (StackFrame[])s.readObject();
            byte[] rawBytes = (byte[])s.readObject();
            this.stackRecord = new KernelStackRecord(frames, rawBytes);
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int stackindent = 14;
        buf.append('\n');
        for (int i = 0; i < 14; ++i) {
            buf.append(' ');
        }
        buf.append("process ID: ");
        buf.append(this.processID);
        buf.append(this.stackRecord.toString());
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(UserStackRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"processID", "stackFrames", "rawStackData"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

