/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class StackFrame
implements Serializable {
    static final long serialVersionUID = 8617210929132692711L;
    private final String frame;

    public StackFrame(String f) {
        this.frame = f;
        this.validate();
    }

    private final void validate() {
        if (this.frame == null) {
            throw new NullPointerException("frame is null");
        }
    }

    public String getFrame() {
        return this.frame;
    }

    public boolean equals(Object o) {
        if (o instanceof StackFrame) {
            StackFrame s = (StackFrame)o;
            return this.frame.equals(s.frame);
        }
        return false;
    }

    public int hashCode() {
        return this.frame.hashCode();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        return this.frame;
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(StackFrame.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"frame"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

