/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class ProcessState
implements Serializable {
    static final long serialVersionUID = -3395911213431317292L;
    private int processID;
    private State state;
    private int terminationSignal;
    private String terminationSignalName;
    private Integer exitStatus;
    private String message;

    public ProcessState(int pid, State processState, int processTerminationSignal, String processTerminationSignalName, Integer processExitStatus, String msg) {
        this.processID = pid;
        this.state = processState;
        this.terminationSignal = processTerminationSignal;
        this.terminationSignalName = processTerminationSignalName;
        this.exitStatus = processExitStatus;
        this.message = msg;
        this.validate();
    }

    public ProcessState(int pid, String processStateName, int processTerminationSignal, String processTerminationSignalName, Integer processExitStatus, String msg) {
        this.processID = pid;
        this.state = Enum.valueOf(State.class, processStateName);
        this.terminationSignal = processTerminationSignal;
        this.terminationSignalName = processTerminationSignalName;
        this.exitStatus = processExitStatus;
        this.message = msg;
        this.validate();
    }

    private final void validate() {
        if (this.processID < 0) {
            throw new IllegalArgumentException("pid is negative");
        }
        if (this.state == null) {
            throw new NullPointerException("process state is null");
        }
    }

    public int getProcessID() {
        return this.processID;
    }

    public State getState() {
        return this.state;
    }

    public int getTerminationSignal() {
        return this.terminationSignal;
    }

    public String getTerminationSignalName() {
        return this.terminationSignalName;
    }

    public Integer getExitStatus() {
        return this.exitStatus;
    }

    private void setExitStatus(int status) {
        this.exitStatus = new Integer(status);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o instanceof ProcessState) {
            ProcessState s = (ProcessState)o;
            return this.processID == s.processID && this.state == s.state && this.terminationSignal == s.terminationSignal && (this.terminationSignalName == null ? s.terminationSignalName == null : this.terminationSignalName.equals(s.terminationSignalName)) && (this.exitStatus == null ? s.exitStatus == null : this.exitStatus.equals(s.exitStatus)) && (this.message == null ? s.message == null : this.message.equals(s.message));
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.processID;
        hash = 37 * hash + this.state.hashCode();
        hash = 37 * hash + this.terminationSignal;
        hash = 37 * hash + (this.exitStatus == null ? 0 : this.exitStatus.hashCode());
        hash = 37 * hash + (this.message == null ? 0 : this.message.hashCode());
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ProcessState.class.getName());
        buf.append("[pid = ");
        buf.append(this.processID);
        buf.append(", state = ");
        buf.append((Object)this.state);
        buf.append(", terminationSignal = ");
        buf.append(this.terminationSignal);
        buf.append(", terminationSignalName = ");
        buf.append(this.terminationSignalName);
        buf.append(", exitStatus = ");
        buf.append(this.exitStatus);
        buf.append(", message = ");
        buf.append(this.message);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(ProcessState.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"processID", "state", "terminationSignal", "terminationSignalName", "exitStatus", "message"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }

                @Override
                protected Expression instantiate(Object oldInstance, Encoder out) {
                    ProcessState pstate = (ProcessState)oldInstance;
                    return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{pstate.getProcessID(), pstate.getState().name(), pstate.getTerminationSignal(), pstate.getTerminationSignalName(), pstate.getExitStatus(), pstate.getMessage()});
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }

    public static enum State {
        RUN,
        STOP,
        LOST,
        UNDEAD,
        DEAD;

    }
}

