/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.InterfaceAttributes;

public final class ProbeInfo
implements Serializable {
    static final long serialVersionUID = 1057402669978245904L;
    private final InterfaceAttributes probeAttributes;
    private final InterfaceAttributes argumentAttributes;

    public ProbeInfo(InterfaceAttributes singleProbeAttributes, InterfaceAttributes argAttributes) {
        this.probeAttributes = singleProbeAttributes;
        this.argumentAttributes = argAttributes;
        this.validate();
    }

    private final void validate() {
        if (this.probeAttributes == null) {
            throw new NullPointerException("probeAttributes is null");
        }
        if (this.argumentAttributes == null) {
            throw new NullPointerException("argumentAttributes is null");
        }
    }

    public InterfaceAttributes getProbeAttributes() {
        return this.probeAttributes;
    }

    public InterfaceAttributes getArgumentAttributes() {
        return this.argumentAttributes;
    }

    public boolean equals(Object o) {
        if (o instanceof ProbeInfo) {
            ProbeInfo i = (ProbeInfo)o;
            return this.probeAttributes.equals(i.probeAttributes) && this.argumentAttributes.equals(i.argumentAttributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.probeAttributes.hashCode();
        hash = 37 * hash + this.argumentAttributes.hashCode();
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ProbeInfo.class.getName());
        buf.append("[probeAttributes = ");
        buf.append(this.probeAttributes);
        buf.append(", argumentAttributes = ");
        buf.append(this.argumentAttributes);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(ProbeInfo.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"probeAttributes", "argumentAttributes"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

