/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;

public final class ProbeDescription
implements Serializable,
Comparable<ProbeDescription> {
    static final long serialVersionUID = 5978023304364513667L;
    public static final ProbeDescription EMPTY = new ProbeDescription(null, null, null, null);
    private static final int ID_NONE = -1;
    private int id = -1;
    private final String provider;
    private final String module;
    private final String function;
    private final String name;

    public ProbeDescription(String probeName) {
        if (probeName != null && probeName.indexOf(58) >= 0) {
            ProbeDescription p;
            try {
                p = ProbeDescription.parse(probeName);
            }
            catch (ParseException e) {
                p = null;
            }
            if (p == null) {
                this.provider = "";
                this.module = "";
                this.function = "";
                this.name = probeName == null ? "" : probeName;
            } else {
                this.provider = p.provider;
                this.module = p.module;
                this.function = p.function;
                this.name = p.name;
            }
        } else {
            this.provider = "";
            this.module = "";
            this.function = "";
            this.name = probeName == null ? "" : probeName;
        }
    }

    public ProbeDescription(String probeFunction, String probeName) {
        this(null, null, probeFunction, probeName);
    }

    public ProbeDescription(String probeModule, String probeFunction, String probeName) {
        this(null, probeModule, probeFunction, probeName);
    }

    public ProbeDescription(String probeProvider, String probeModule, String probeFunction, String probeName) {
        this.provider = probeProvider == null ? "" : probeProvider;
        this.module = probeModule == null ? "" : probeModule;
        this.function = probeFunction == null ? "" : probeFunction;
        this.name = probeName == null ? "" : probeName;
    }

    public ProbeDescription(int probeID, String probeProvider, String probeModule, String probeFunction, String probeName) {
        this(probeProvider, probeModule, probeFunction, probeName);
        this.id = probeID;
    }

    public static ProbeDescription parse(String s) throws ParseException {
        ProbeDescription p;
        int len;
        ArrayList<String> list = new ArrayList<String>();
        int npos = len = s.length();
        for (int i = len - 1; i >= 0; --i) {
            char ch = s.charAt(i);
            if (ch != ':') continue;
            list.add(0, s.substring(i + 1, npos));
            npos = i;
        }
        list.add(0, s.substring(0, npos));
        switch (list.size()) {
            case 0: {
                p = EMPTY;
                break;
            }
            case 1: {
                p = new ProbeDescription((String)list.get(0));
                break;
            }
            case 2: {
                p = new ProbeDescription((String)list.get(0), (String)list.get(1));
                break;
            }
            case 3: {
                p = new ProbeDescription((String)list.get(0), (String)list.get(1), (String)list.get(2));
                break;
            }
            case 4: {
                p = new ProbeDescription((String)list.get(0), (String)list.get(1), (String)list.get(2), (String)list.get(3));
                break;
            }
            default: {
                int offset = s.length() - 4;
                len = list.size();
                for (int i = len - 1; i >= len - 4; --i) {
                    offset -= ((String)list.get(i)).length();
                }
                throw new ParseException("Overspecified probe description: \"" + s + "\"", offset);
            }
        }
        return p;
    }

    public int getID() {
        return this.id;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getModule() {
        return this.module;
    }

    public String getFunction() {
        return this.function;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        if (this.provider.length() > 0) {
            return false;
        }
        if (this.module.length() > 0) {
            return false;
        }
        if (this.function.length() > 0) {
            return false;
        }
        return this.name.length() <= 0;
    }

    public boolean equals(Object o) {
        if (o instanceof ProbeDescription) {
            ProbeDescription p = (ProbeDescription)o;
            if (this.id == -1 || p.id == -1) {
                return this.compareTo(p) == 0;
            }
            return this.id == p.id;
        }
        return false;
    }

    @Override
    public int compareTo(ProbeDescription p) {
        int cmp = 0;
        cmp = this.provider.compareTo(p.provider);
        if (cmp == 0 && (cmp = this.module.compareTo(p.module)) == 0 && (cmp = this.function.compareTo(p.function)) == 0) {
            cmp = this.name.compareTo(p.name);
        }
        return cmp;
    }

    public int hashCode() {
        int hash = this.id;
        if (hash != -1) {
            return hash;
        }
        hash = 17;
        hash = 37 * hash + this.provider.hashCode();
        hash = 37 * hash + this.module.hashCode();
        hash = 37 * hash + this.function.hashCode();
        hash = 37 * hash + this.name.hashCode();
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.provider == null) {
            throw new InvalidObjectException("provider is null");
        }
        if (this.module == null) {
            throw new InvalidObjectException("module is null");
        }
        if (this.function == null) {
            throw new InvalidObjectException("function is null");
        }
        if (this.name == null) {
            throw new InvalidObjectException("name is null");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.provider);
        buf.append(':');
        buf.append(this.module);
        buf.append(':');
        buf.append(this.function);
        buf.append(':');
        buf.append(this.name);
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(ProbeDescription.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"ID", "provider", "module", "function", "name"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }

    public static enum Spec {
        PROVIDER,
        MODULE,
        FUNCTION,
        NAME;

    }
}

