/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.opensolaris.os.dtrace.AggregationRecord;
import org.opensolaris.os.dtrace.ExitRecord;
import org.opensolaris.os.dtrace.Flow;
import org.opensolaris.os.dtrace.KernelStackRecord;
import org.opensolaris.os.dtrace.KernelSymbolRecord;
import org.opensolaris.os.dtrace.PrintaRecord;
import org.opensolaris.os.dtrace.PrintfRecord;
import org.opensolaris.os.dtrace.ProbeDescription;
import org.opensolaris.os.dtrace.Record;
import org.opensolaris.os.dtrace.ScalarRecord;
import org.opensolaris.os.dtrace.StackFrame;
import org.opensolaris.os.dtrace.StackValueRecord;
import org.opensolaris.os.dtrace.SymbolValueRecord;
import org.opensolaris.os.dtrace.Tuple;
import org.opensolaris.os.dtrace.UserStackRecord;
import org.opensolaris.os.dtrace.UserSymbolRecord;
import org.opensolaris.os.dtrace.ValueRecord;

public final class ProbeData
implements Serializable,
Comparable<ProbeData> {
    static final long serialVersionUID = -7021504416192099215L;
    private static Comparator<ProbeData> DEFAULT_CMP;
    private int epid;
    private int cpu;
    private ProbeDescription enabledProbeDescription;
    private Flow flow;
    private transient List<Record> nativeElements;
    private List<Record> records;

    private ProbeData(int enabledProbeID, int cpuID, ProbeDescription p, Flow f, int nativeElementCount) {
        this.epid = enabledProbeID;
        this.cpu = cpuID;
        this.enabledProbeDescription = p;
        this.flow = f;
        this.nativeElements = new ArrayList<Record>(nativeElementCount);
        this.records = new ArrayList<Record>();
        this.validate();
    }

    public ProbeData(int enabledProbeID, int cpuID, ProbeDescription p, Flow f, List<Record> recordList) {
        this.epid = enabledProbeID;
        this.cpu = cpuID;
        this.enabledProbeDescription = p;
        this.flow = f;
        this.records = new ArrayList<Record>(recordList.size());
        this.records.addAll(recordList);
        this.validate();
    }

    private final void validate() {
        if (this.enabledProbeDescription == null) {
            throw new NullPointerException("enabled probe description is null");
        }
        if (this.records == null) {
            throw new NullPointerException("record list is null");
        }
    }

    private void addDataElement(Record o) {
        Record r = (Record)Record.class.cast(o);
        this.nativeElements.add(o);
    }

    private void addRecord(Record record) {
        this.records.add(record);
    }

    private void addTraceRecord(int i) {
        int len = this.nativeElements.size();
        Record rec = null;
        while ((rec = this.nativeElements.get(i)) == null && i < len) {
            ++i;
        }
        this.records.add(rec);
    }

    private void addSymbolRecord(int i, String lookupString) {
        int len = this.nativeElements.size();
        Record rec = null;
        while ((rec = this.nativeElements.get(i)) == null && i < len) {
            ++i;
        }
        SymbolValueRecord symbol = (SymbolValueRecord)SymbolValueRecord.class.cast(rec);
        if (symbol instanceof KernelSymbolRecord) {
            ((KernelSymbolRecord)KernelSymbolRecord.class.cast(symbol)).setSymbol(lookupString);
        } else if (symbol instanceof UserSymbolRecord) {
            ((UserSymbolRecord)UserSymbolRecord.class.cast(symbol)).setSymbol(lookupString);
        } else {
            throw new IllegalStateException("no symbol record at index " + i);
        }
        this.records.add(symbol);
    }

    private void addStackRecord(int i, String framesString) {
        int len = this.nativeElements.size();
        Record rec = null;
        while ((rec = this.nativeElements.get(i)) == null && i < len) {
            ++i;
        }
        StackValueRecord stack = (StackValueRecord)StackValueRecord.class.cast(rec);
        StackFrame[] frames = KernelStackRecord.parse(framesString);
        if (stack instanceof KernelStackRecord) {
            ((KernelStackRecord)KernelStackRecord.class.cast(stack)).setStackFrames(frames);
        } else if (stack instanceof UserStackRecord) {
            ((UserStackRecord)UserStackRecord.class.cast(stack)).setStackFrames(frames);
        } else {
            throw new IllegalStateException("no stack record at index " + i);
        }
        this.records.add(stack);
    }

    private void addPrintfRecord() {
        this.records.add(new PrintfRecord());
    }

    private void addPrintaRecord(long snaptimeNanos, boolean isFormatString) {
        this.records.add(new PrintaRecord(snaptimeNanos, isFormatString));
    }

    private PrintaRecord getLastPrinta() {
        ListIterator<Record> itr = this.records.listIterator(this.records.size());
        PrintaRecord printa = null;
        while (itr.hasPrevious() && printa == null) {
            Record record = itr.previous();
            if (!(record instanceof PrintaRecord)) continue;
            printa = (PrintaRecord)PrintaRecord.class.cast(record);
        }
        return printa;
    }

    private void addAggregationRecord(String aggregationName, long aggid, AggregationRecord rec) {
        PrintaRecord printa = this.getLastPrinta();
        if (printa == null) {
            throw new IllegalStateException("No PrintaRecord in this ProbeData");
        }
        printa.addRecord(aggregationName, aggid, rec);
    }

    private void invalidatePrintaRecord() {
        PrintaRecord printa = this.getLastPrinta();
        if (printa == null) {
            throw new IllegalStateException("No PrintaRecord in this ProbeData");
        }
        printa.invalidate();
    }

    private void addPrintaFormattedString(Tuple tuple, String s) {
        PrintaRecord printa = this.getLastPrinta();
        if (printa == null) {
            throw new IllegalStateException("No PrintaRecord in this ProbeData");
        }
        printa.addFormattedString(tuple, s);
    }

    private void addExitRecord(int i) {
        int len = this.nativeElements.size();
        Record rec = null;
        while ((rec = this.nativeElements.get(i)) == null && i < len) {
            ++i;
        }
        ScalarRecord scalar = (ScalarRecord)ScalarRecord.class.cast(rec);
        Integer exitStatus = (Integer)Integer.class.cast(scalar.getValue());
        this.records.add(new ExitRecord(exitStatus));
    }

    private void attachRecordElements(int first, int last) {
        Record record = this.records.get(this.records.size() - 1);
        if (record instanceof PrintfRecord) {
            PrintfRecord printf = (PrintfRecord)PrintfRecord.class.cast(record);
            for (int i = first; i <= last; ++i) {
                Record e = this.nativeElements.get(i);
                if (e == null) continue;
                printf.addUnformattedElement((ScalarRecord)ScalarRecord.class.cast(e));
            }
        }
    }

    void clearNativeElements() {
        this.nativeElements = null;
    }

    private void setFormattedString(String s) {
        Record record = this.records.get(this.records.size() - 1);
        if (record instanceof PrintfRecord) {
            PrintfRecord printf = (PrintfRecord)PrintfRecord.class.cast(record);
            printf.setFormattedString(s);
        }
    }

    public static Comparator<ProbeData> getComparator(KeyField ... f) {
        return new Cmp(f);
    }

    static int compareUnsigned(int i1, int i2) {
        int cmp = i1 < 0 ? (i2 < 0 ? (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)) : 1) : (i2 < 0 ? -1 : (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)));
        return cmp;
    }

    static int compareUnsigned(long i1, long i2) {
        int cmp = i1 < 0L ? (i2 < 0L ? (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)) : 1) : (i2 < 0L ? -1 : (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)));
        return cmp;
    }

    static int compareUnsigned(byte i1, byte i2) {
        int cmp = i1 < 0 ? (i2 < 0 ? (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)) : 1) : (i2 < 0 ? -1 : (i1 < i2 ? -1 : (i1 > i2 ? 1 : 0)));
        return cmp;
    }

    static int compareByteArrays(byte[] a1, byte[] a2) {
        int cmp = 0;
        int len1 = a1.length;
        int len2 = a2.length;
        for (int i = 0; cmp == 0 && i < len1 && i < len2; ++i) {
            cmp = ProbeData.compareUnsigned(a1[i], a2[i]);
        }
        if (cmp == 0) {
            cmp = len1 < len2 ? -1 : (len1 > len2 ? 1 : 0);
        }
        return cmp;
    }

    static int compareUnsigned(Comparable<?> v1, Comparable<?> v2) {
        int cmp;
        if (v1 instanceof Integer) {
            int i1 = (Integer)Integer.class.cast(v1);
            int i2 = (Integer)Integer.class.cast(v2);
            cmp = ProbeData.compareUnsigned(i1, i2);
        } else if (v1 instanceof Long) {
            long i1 = (Long)Long.class.cast(v1);
            long i2 = (Long)Long.class.cast(v2);
            cmp = ProbeData.compareUnsigned(i1, i2);
        } else {
            cmp = v1.compareTo(v2);
        }
        return cmp;
    }

    private static int compareRecords(Record r1, Record r2) {
        int cmp;
        if (r1 instanceof ScalarRecord) {
            ScalarRecord t1 = (ScalarRecord)ScalarRecord.class.cast(r1);
            ScalarRecord t2 = (ScalarRecord)ScalarRecord.class.cast(r2);
            Object o1 = t1.getValue();
            Object o2 = t2.getValue();
            if (o1 instanceof byte[]) {
                byte[] a1 = (byte[])byte[].class.cast(o1);
                byte[] a2 = (byte[])byte[].class.cast(o2);
                cmp = ProbeData.compareByteArrays(a1, a2);
            } else {
                Comparable v1 = (Comparable)Comparable.class.cast(o1);
                Comparable v2 = (Comparable)Comparable.class.cast(o2);
                cmp = v1.compareTo(v2);
            }
        } else if (r1 instanceof Comparable) {
            Comparable v1 = (Comparable)Comparable.class.cast(r1);
            Comparable v2 = (Comparable)Comparable.class.cast(r2);
            cmp = v1.compareTo(v2);
        } else if (r1 instanceof ExitRecord) {
            int status2;
            ExitRecord e1 = (ExitRecord)ExitRecord.class.cast(r1);
            ExitRecord e2 = (ExitRecord)ExitRecord.class.cast(r2);
            int status1 = e1.getStatus();
            cmp = status1 < (status2 = e2.getStatus()) ? -1 : (status1 > status2 ? 1 : 0);
        } else {
            r1.getClass().cast(r2);
            String s1 = r1.toString();
            String s2 = r2.toString();
            cmp = s1.compareTo(s2);
        }
        return cmp;
    }

    private static int compareRecordLists(ProbeData d1, ProbeData d2) {
        int len2;
        List<Record> list1 = d1.getRecords();
        List<Record> list2 = d2.getRecords();
        int len1 = list1.size();
        if (len1 != (len2 = list2.size())) {
            throw new ClassCastException("Record lists of different length are not comparable (lengths are " + len1 + " and " + len2 + ").");
        }
        for (int i = 0; i < len1 && i < len2; ++i) {
            Record r2;
            Record r1 = list1.get(i);
            int cmp = ProbeData.compareRecords(r1, r2 = list2.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static int compare(ProbeData d1, ProbeData d2, KeyField[] comparedFields) {
        for (KeyField f : comparedFields) {
            int cmp;
            switch (f) {
                case CPU: {
                    int cpu1 = d1.getCPU();
                    int cpu2 = d2.getCPU();
                    cmp = cpu1 < cpu2 ? -1 : (cpu1 > cpu2 ? 1 : 0);
                    break;
                }
                case PROBE: {
                    ProbeDescription p1 = d1.getEnabledProbeDescription();
                    ProbeDescription p2 = d2.getEnabledProbeDescription();
                    cmp = p1.compareTo(p2);
                    break;
                }
                case EPID: {
                    int epid1 = d1.getEnabledProbeID();
                    int epid2 = d2.getEnabledProbeID();
                    cmp = epid1 < epid2 ? -1 : (epid1 > epid2 ? 1 : 0);
                    break;
                }
                case RECORDS: {
                    cmp = ProbeData.compareRecordLists(d1, d2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected sort field " + (Object)((Object)f));
                }
            }
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public int getEnabledProbeID() {
        return this.epid;
    }

    public int getCPU() {
        return this.cpu;
    }

    public ProbeDescription getEnabledProbeDescription() {
        return this.enabledProbeDescription;
    }

    public Flow getFlow() {
        return this.flow;
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    @Override
    public int compareTo(ProbeData d) {
        return DEFAULT_CMP.compare(this, d);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = this.records.size();
        ArrayList<Record> copy = new ArrayList<Record>(len);
        copy.addAll(this.records);
        this.records = copy;
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ProbeData.class.getName());
        buf.append("[epid = ");
        buf.append(this.epid);
        buf.append(", cpu = ");
        buf.append(this.cpu);
        buf.append(", enabledProbeDescription = ");
        buf.append(this.enabledProbeDescription);
        buf.append(", flow = ");
        buf.append(this.flow);
        buf.append(", records = ");
        buf.append('[');
        for (int i = 0; i < this.records.size(); ++i) {
            Record record;
            if (i > 0) {
                buf.append(", ");
            }
            if ((record = this.records.get(i)) instanceof ValueRecord) {
                Object value = ((ValueRecord)ValueRecord.class.cast(record)).getValue();
                if (value instanceof String) {
                    buf.append("\"");
                    buf.append((String)String.class.cast(value));
                    buf.append("\"");
                    continue;
                }
                buf.append(record);
                continue;
            }
            buf.append(record);
        }
        buf.append(']');
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(ProbeData.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"enabledProbeID", "CPU", "enabledProbeDescription", "flow", "records"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
        try {
            DEFAULT_CMP = ProbeData.getComparator(KeyField.RECORDS, KeyField.EPID);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class Cmp
    implements Comparator<ProbeData> {
        private KeyField[] sortFields;

        private Cmp(KeyField ... f) {
            this.sortFields = f;
        }

        @Override
        public int compare(ProbeData d1, ProbeData d2) {
            return ProbeData.compare(d1, d2, this.sortFields);
        }
    }

    public static enum KeyField {
        CPU,
        PROBE,
        EPID,
        RECORDS;

    }
}

