/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.opensolaris.os.dtrace.ProbeData;
import org.opensolaris.os.dtrace.SymbolValueRecord;

public final class KernelSymbolRecord
implements SymbolValueRecord,
Serializable,
Comparable<KernelSymbolRecord> {
    static final long serialVersionUID = -7156627773519296848L;
    private String symbol;
    private final long address;

    private KernelSymbolRecord(long addressValue) {
        this.address = addressValue;
    }

    public KernelSymbolRecord(String lookupValue, long addressValue) {
        this.symbol = lookupValue;
        this.address = addressValue;
        this.validate();
    }

    private final void validate() {
        if (this.symbol == null) {
            throw new NullPointerException("symbol is null");
        }
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    void setSymbol(String lookupValue) {
        this.symbol = lookupValue;
        this.validate();
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public Long getValue() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (o instanceof KernelSymbolRecord) {
            KernelSymbolRecord r = (KernelSymbolRecord)o;
            return this.address == r.address;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    @Override
    public int compareTo(KernelSymbolRecord r) {
        return ProbeData.compareUnsigned(this.address, r.address);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        return this.symbol;
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(KernelSymbolRecord.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"symbol", "address"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }
}

