/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class InterfaceAttributes
implements Serializable {
    static final long serialVersionUID = -2814012588381562694L;
    private Stability nameStability;
    private Stability dataStability;
    private DependencyClass dependencyClass;

    private InterfaceAttributes() {
    }

    public InterfaceAttributes(Stability nameStabilityAttribute, Stability dataStabilityAttribute, DependencyClass dependencyClassAttribute) {
        this.nameStability = nameStabilityAttribute;
        this.dataStability = dataStabilityAttribute;
        this.dependencyClass = dependencyClassAttribute;
        this.validate();
    }

    public InterfaceAttributes(String nameStabilityAttributeName, String dataStabilityAttributeName, String dependencyClassAttributeName) {
        this(Enum.valueOf(Stability.class, nameStabilityAttributeName), Enum.valueOf(Stability.class, dataStabilityAttributeName), Enum.valueOf(DependencyClass.class, dependencyClassAttributeName));
    }

    private final void validate() {
        if (this.nameStability == null) {
            throw new NullPointerException("nameStability is null");
        }
        if (this.dataStability == null) {
            throw new NullPointerException("dataStability is null");
        }
        if (this.dependencyClass == null) {
            throw new NullPointerException("dependencyClass is null");
        }
    }

    public Stability getNameStability() {
        return this.nameStability;
    }

    private void setNameStability(String s) {
        this.nameStability = Enum.valueOf(Stability.class, s);
    }

    public Stability getDataStability() {
        return this.dataStability;
    }

    private void setDataStability(String s) {
        this.dataStability = Enum.valueOf(Stability.class, s);
    }

    public DependencyClass getDependencyClass() {
        return this.dependencyClass;
    }

    private void setDependencyClass(String s) {
        this.dependencyClass = Enum.valueOf(DependencyClass.class, s);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InterfaceAttributes) {
            InterfaceAttributes a = (InterfaceAttributes)o;
            return this.nameStability == a.nameStability && this.dataStability == a.dataStability && this.dependencyClass == a.dependencyClass;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.nameStability.hashCode();
        hash = 37 * hash + this.dataStability.hashCode();
        hash = 37 * hash + this.dependencyClass.hashCode();
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.nameStability);
        buf.append(" / ");
        buf.append((Object)this.dataStability);
        buf.append(" / ");
        buf.append((Object)this.dependencyClass);
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(InterfaceAttributes.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"nameStability", "dataStability", "dependencyClass"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }

                @Override
                protected Expression instantiate(Object oldInstance, Encoder out) {
                    InterfaceAttributes attr = (InterfaceAttributes)oldInstance;
                    return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{attr.getNameStability().name(), attr.getDataStability().name(), attr.getDependencyClass().name()});
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static enum DependencyClass {
        UNKNOWN("Unknown"),
        CPU("CPU"),
        PLATFORM("Platform"),
        GROUP("Group"),
        ISA("ISA"),
        COMMON("Common");

        private String s;

        private DependencyClass(String displayString) {
            this.s = displayString;
        }

        public String toString() {
            return this.s;
        }
    }

    public static enum Stability {
        INTERNAL("Internal"),
        PRIVATE("Private"),
        OBSOLETE("Obsolete"),
        EXTERNAL("External"),
        UNSTABLE("Unstable"),
        EVOLVING("Evolving"),
        STABLE("Stable"),
        STANDARD("Standard");

        private String s;

        private Stability(String displayName) {
            this.s = displayName;
        }

        public String toString() {
            return this.s;
        }
    }
}

