/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class Flow
implements Serializable {
    static final long serialVersionUID = -9178272444872063901L;
    private final Kind kind;
    private final int depth;

    public Flow(String flowKindName, int flowDepth) {
        this.kind = Enum.valueOf(Kind.class, flowKindName);
        this.depth = flowDepth;
        if (this.depth < 0) {
            throw new IllegalArgumentException("depth is negative");
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (o instanceof Flow) {
            Flow f = (Flow)o;
            return this.kind == f.kind && this.depth == f.depth;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.kind.hashCode();
        hash = 37 * hash + this.depth;
        return hash;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.kind == null) {
            throw new InvalidObjectException("kind is null");
        }
        if (this.depth < 0) {
            throw new InvalidObjectException("depth is negative");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Flow.class.getName());
        buf.append("[kind = ");
        buf.append((Object)this.kind);
        buf.append(", depth = ");
        buf.append(this.depth);
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Flow.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"kind", "depth"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }

                @Override
                protected Expression instantiate(Object oldInstance, Encoder out) {
                    Flow flow = (Flow)oldInstance;
                    return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{flow.getKind().name(), flow.getDepth()});
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public static enum Kind {
        ENTRY,
        RETURN,
        NONE;

    }
}

