/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.EventObject;
import org.opensolaris.os.dtrace.Error;

public class ErrorEvent
extends EventObject {
    static final long serialVersionUID = 2236600660422267215L;
    private Error error;

    public ErrorEvent(Object source, Error dtraceError) {
        super(source);
        this.error = dtraceError;
        this.validate();
    }

    private final void validate() {
        if (this.error == null) {
            throw new NullPointerException("error is null");
        }
    }

    public Error getError() {
        return this.error;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(ErrorEvent.class.getName());
        buf.append("[source = ");
        buf.append(this.getSource());
        buf.append(", error = ");
        buf.append(this.error);
        buf.append(']');
        return buf.toString();
    }
}

