/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import org.opensolaris.os.dtrace.AbstractAggregationValue;

public final class AvgValue
extends AbstractAggregationValue {
    static final long serialVersionUID = 1633169020110237906L;
    private final long total;
    private final long count;

    public AvgValue(long v, long averagedTotal, long averagedValueCount) {
        super(v);
        this.total = averagedTotal;
        this.count = averagedValueCount;
        this.validate();
    }

    private final void validate() {
        if (this.count < 0L) {
            throw new IllegalArgumentException("count is negative");
        }
        long average = super.getValue().longValue();
        if (this.count == 0L) {
            if (average != 0L) {
                throw new IllegalArgumentException("count of values is zero, average is non-zero (" + average + ")");
            }
        } else if (average != this.total / this.count) {
            throw new IllegalArgumentException(this.getValue().toString() + " is not the expected " + "average of total " + this.total + " and count " + this.count);
        }
    }

    @Override
    public Long getValue() {
        return (Long)super.getValue();
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(AvgValue.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"value", "total", "count"});
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

