/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensolaris.os.dtrace.Aggregate;
import org.opensolaris.os.dtrace.AggregationRecord;
import org.opensolaris.os.dtrace.Tuple;

public final class Aggregation
implements Serializable {
    static final long serialVersionUID = 2340811719178724026L;
    private String name;
    private final long id;
    private transient Map<Tuple, AggregationRecord> map;

    Aggregation(String aggregationName, long aggregationID) {
        this.name = Aggregate.filterUnnamedAggregationName(aggregationName);
        this.id = aggregationID;
        this.map = new HashMap<Tuple, AggregationRecord>();
    }

    public Aggregation(String aggregationName, long aggregationID, Collection<AggregationRecord> aggregationRecords) {
        this.name = Aggregate.filterUnnamedAggregationName(aggregationName);
        this.id = aggregationID;
        this.mapRecords(aggregationRecords);
        this.validate();
    }

    private void mapRecords(Collection<AggregationRecord> records) {
        int capacity = (int)((float)records.size() * 3.0f / 2.0f);
        this.map = new HashMap<Tuple, AggregationRecord>(capacity, 1.0f);
        for (AggregationRecord record : records) {
            this.map.put(record.getTuple(), record);
        }
    }

    private final void validate() {
        if (this.name == null) {
            throw new NullPointerException("name is null");
        }
        for (AggregationRecord r : this.map.values()) {
            if (r.getTuple().size() != 0 || this.map.size() <= 1) continue;
            throw new IllegalArgumentException("empty tuple allowed only in singleton aggregation");
        }
    }

    public String getName() {
        return this.name;
    }

    public long getID() {
        return this.id;
    }

    public List<AggregationRecord> getRecords() {
        ArrayList<AggregationRecord> list = new ArrayList<AggregationRecord>(this.map.values());
        return list;
    }

    void addRecord(AggregationRecord record) {
        Tuple key = record.getTuple();
        if (this.map.put(key, record) != null) {
            throw new IllegalArgumentException("already contains a record with tuple " + key);
        }
    }

    public Map<Tuple, AggregationRecord> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean equals(Object o) {
        if (o instanceof Aggregation) {
            Aggregation a = (Aggregation)o;
            return this.name.equals(a.name) && this.map.equals(a.map);
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.name.hashCode();
        hash = 37 * hash + this.map.hashCode();
        return hash;
    }

    public AggregationRecord getRecord(Tuple key) {
        if (key == null) {
            key = Tuple.EMPTY;
        }
        return this.map.get(key);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getRecords());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        List records = (List)s.readObject();
        this.mapRecords(records);
        this.name = Aggregate.filterUnnamedAggregationName(this.name);
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(Aggregation.class.getName());
        buf.append("[name = ");
        buf.append(this.name);
        buf.append(", id = ");
        buf.append(this.id);
        buf.append(", records = ");
        List<AggregationRecord> recordList = this.getRecords();
        Collections.sort(recordList, new Comparator<AggregationRecord>(){

            @Override
            public int compare(AggregationRecord r1, AggregationRecord r2) {
                Tuple t1 = r1.getTuple();
                Tuple t2 = r2.getTuple();
                return t1.compareTo(t2);
            }
        });
        buf.append('[');
        boolean first = true;
        for (AggregationRecord record : recordList) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(record);
        }
        buf.append(']');
        return buf.toString();
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(Aggregation.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"name", "ID", "records"}){

                @Override
                protected boolean mutatesTo(Object oldInstance, Object newInstance) {
                    return newInstance != null && oldInstance != null && oldInstance.getClass() == newInstance.getClass();
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }
}

