/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.usermgr;

import com.oracle.solaris.rad.client.ADRName;
import com.oracle.solaris.rad.client.AttributeError;
import com.oracle.solaris.rad.client.FeatureStability;
import com.oracle.solaris.rad.client.Interface;
import com.oracle.solaris.rad.client.IsNullable;
import com.oracle.solaris.rad.client.RadException;
import com.oracle.solaris.rad.client.Stability;
import com.oracle.solaris.rad.client.Version;
import com.oracle.solaris.rad.connect.Connection;
import com.oracle.solaris.rad.usermgr.Group;
import com.oracle.solaris.rad.usermgr.ScopeType;
import com.oracle.solaris.rad.usermgr.User;
import com.oracle.solaris.rad.usermgr.UserChangeFields;
import com.oracle.solaris.rad.usermgr.UserMgrError;
import com.oracle.solaris.rad.usermgr.UserType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FeatureStability(value=Stability.PRIVATE)
public class UserMgr
extends Interface {
    public static final String TYPE = "UserMgr";
    public static final String DOMAIN = "com.oracle.solaris.rad.usermgr";
    public static final int MAJOR = 1;
    public static final int MINOR = 0;
    public static final Version VERSION = new Version(1, 0);
    public static final Map<String, String> KVS = new HashMap<String, String>();

    public UserMgr() {
        super(null, -1L, new ADRName(DOMAIN, KVS), VERSION);
    }

    public UserMgr(Connection connection, long l, ADRName aDRName, Version version) {
        super(connection, l, aDRName, version);
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public User getUser(String string) throws RadException {
        return (User)this.invoke("getUser", new Class[]{String.class}, new Object[]{string});
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public User addUser(User user, String string) throws RadException {
        return (User)this.invoke("addUser", new Class[]{User.class, String.class}, new Object[]{user, string});
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public User modifyUser(User user, UserChangeFields userChangeFields, @IsNullable String string) throws RadException {
        return (User)this.invoke("modifyUser", new Class[]{User.class, UserChangeFields.class, String.class}, new Object[]{user, userChangeFields, string});
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void deleteUser(String string) throws RadException {
        this.invoke("deleteUser", new Class[]{String.class}, new Object[]{string});
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void selectScope(ScopeType scopeType) {
        this.invoke("selectScope", new Class[]{ScopeType.class}, new Object[]{scopeType});
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void setFilter(UserType userType, String string) {
        this.invoke("setFilter", new Class[]{UserType.class, String.class}, new Object[]{userType, string});
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Boolean isSystemLabeled() throws RadException {
        return (Boolean)this.invoke("isSystemLabeled");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public UserType getUserType(String string) throws RadException {
        return (UserType)((Object)this.invoke("getUserType", new Class[]{String.class}, new Object[]{string}));
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<User> getusers() throws RadException {
        return (List)this.getattr("users");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<Group> getgroups() throws RadException {
        return (List)this.getattr("groups");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getshells() throws RadException {
        return (List)this.getattr("shells");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public User getdefaultUser() throws RadException {
        return (User)this.getattr("defaultUser");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getscopes() throws RadException {
        return (List)this.getattr("scopes");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getroles() throws RadException {
        return (List)this.getattr("roles");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getprofiles() throws RadException {
        return (List)this.getattr("profiles");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getauths() throws RadException {
        return (List)this.getattr("auths");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getdefaultPrivs() throws RadException {
        return (List)this.getattr("defaultPrivs");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getlimitPrivs() throws RadException {
        return (List)this.getattr("limitPrivs");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getsupplGroups() throws RadException {
        return (List)this.getattr("supplGroups");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getauditClasses() throws RadException {
        return (List)this.getattr("auditClasses");
    }

    @AttributeError(clazz=UserMgrError.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getpamUserConfFiles() throws RadException {
        return (List)this.getattr("pamUserConfFiles");
    }

    static {
        KVS.put("type", TYPE);
    }
}

