/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.transports;

import com.oracle.solaris.rad.transports.AFUNIXNotSupportedException;
import com.oracle.solaris.rad.transports.UnixSocket;
import com.oracle.solaris.rad.transports.UnixSocketServer;
import java.io.File;
import java.io.IOException;

public class UnixDomainSocket {
    private static boolean supported_ = false;

    private static native int socket_connect(String var0) throws IOException;

    private static native int socket_bind(String var0) throws IOException;

    static native void socket_close(int var0);

    static native void server_close(int var0);

    static native void socket_goose(int var0) throws IOException;

    static void loadAltRootLibrary(String string, String string2, String string3) {
        String string4 = System.getProperty("sun.arch.data.model");
        String string5 = System.mapLibraryName(string3);
        System.load(string + string2 + string4 + "/" + string5);
    }

    public static UnixSocket connect(File file) throws IOException {
        if (!supported_) {
            throw new AFUNIXNotSupportedException("unix domain sockets not supported by platform");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Path to socket must be absolute: " + file);
        }
        int n = UnixDomainSocket.socket_connect(file.getPath());
        UnixSocket unixSocket = null;
        try {
            unixSocket = new UnixSocket(n);
        }
        finally {
            if (unixSocket == null) {
                UnixDomainSocket.socket_close(n);
            }
        }
        return unixSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnixSocketServer bind(File file, int n) throws IOException {
        if (!supported_) {
            throw new AFUNIXNotSupportedException("unix domain sockets not supported by platform");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("Path to socket must be absolute: " + file);
        }
        int n2 = UnixDomainSocket.socket_bind(file.getPath());
        UnixSocketServer unixSocketServer = null;
        try {
            unixSocketServer = new UnixSocketServer(n2);
        }
        finally {
            if (unixSocketServer == null) {
                UnixDomainSocket.server_close(n2);
            }
        }
        return unixSocketServer;
    }

    public static boolean isSupported() {
        return supported_;
    }

    static {
        String string = System.getenv("ROOT");
        String string2 = "/usr/lib/";
        String string3 = "UnixDomainSocket_jni";
        if (string != null) {
            try {
                UnixDomainSocket.loadAltRootLibrary(string, string2, string3);
                supported_ = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (!supported_) {
            try {
                System.loadLibrary(string3);
                supported_ = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }
}

