/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.encodings.xdr;

import com.oracle.solaris.rad.encodings.xdr.RecordMarkingStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class RecordMarkingOutputStream
extends BufferedOutputStream
implements RecordMarkingStream {
    private RecordMarker stream_;

    public RecordMarkingOutputStream(OutputStream outputStream) {
        super(new RecordMarker(outputStream));
        this.stream_ = (RecordMarker)this.out;
    }

    public synchronized void endOfRecord(boolean bl) throws IOException {
        this.stream_.setFinal();
        this.flush();
    }

    private static class RecordMarker
    extends OutputStream {
        private OutputStream stream_;
        private boolean final_;
        private ByteBuffer header_ = ByteBuffer.allocate(4);

        private RecordMarker(OutputStream outputStream) {
            this.stream_ = outputStream;
        }

        private void writeHeader(int n) throws IOException {
            this.header_.rewind();
            this.header_.putInt(n);
            if (this.final_) {
                this.header_.put(0, (byte)(this.header_.get(0) | 0x80));
                this.final_ = false;
            }
            this.stream_.write(this.header_.array(), 0, 4);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.writeHeader(n2);
            this.stream_.write(byArray, n, n2);
        }

        @Override
        public void write(int n) throws IOException {
            this.writeHeader(1);
            this.stream_.write(n);
        }

        @Override
        public void flush() throws IOException {
            if (this.final_) {
                this.writeHeader(0);
            }
            this.stream_.flush();
        }

        void setFinal() {
            this.final_ = true;
        }
    }
}

