/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.connect;

import com.oracle.solaris.rad.connect.Connection;
import com.oracle.solaris.rad.connect.Credentials;
import com.oracle.solaris.rad.connect.PAMCredentials;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class URIConnection {
    public static final String SCHEME_UNIX = "unix";
    public static final String SCHEME_RAD = "rad";
    public static final String SCHEME_RADS = "rads";
    public static final String SCHEME_SSH = "ssh";
    public static final Set<String> DEFAULT_SCHEMES = new HashSet<String>();
    public static final Set<String> CREDENTIAL_CLASSES = new HashSet<String>();
    private String auth_;
    private String class_;
    private String host_;
    private String path_;
    private int port_;
    private String src_;
    private String scheme_;
    private Set<String> schemes_;
    private String user_;
    private Set<String> certfiles_;

    public URIConnection(String string) throws IOException {
        this(string, DEFAULT_SCHEMES);
    }

    public URIConnection(String string, Set<String> set) throws IOException {
        this(string, set, new HashSet<String>());
    }

    public URIConnection(String string, Set<String> set, Set<String> set2) throws IOException {
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException(uRISyntaxException);
        }
        this.auth_ = uRI.getQuery();
        this.class_ = null;
        this.host_ = uRI.getHost();
        this.path_ = uRI.getPath();
        this.port_ = uRI.getPort();
        this.src_ = string;
        this.scheme_ = uRI.getScheme();
        this.schemes_ = set;
        this.user_ = uRI.getUserInfo();
        this.certfiles_ = set2;
        if (this.port_ == -1) {
            this.port_ = 12302;
        }
        if (this.user_ == null) {
            this.user_ = System.getProperty("user.name");
        }
        if (this.scheme_ == null) {
            this.scheme_ = SCHEME_RADS;
        }
        if (!set.contains(this.scheme_)) {
            throw new IOException(String.format("Unrecognised scheme: %s", this.scheme_));
        }
        if (this.auth_ != null) {
            if (this.auth_.startsWith("auth=") || this.auth_.contains(",auth=")) {
                for (String string2 : CREDENTIAL_CLASSES) {
                    String string3 = String.format("auth=%s", string2);
                    if (!this.auth_.equals(string3) && !this.auth_.endsWith(String.format(",%s", string3)) && !this.auth_.startsWith(String.format("%s,", string3)) && !this.auth_.contains(String.format(",%s,", string3))) continue;
                    this.class_ = string2;
                }
                if (this.class_ == null) {
                    throw new IOException(String.format("Unrecognised authentication: %s", this.auth_));
                }
            } else {
                this.class_ = null;
            }
        } else {
            this.class_ = null;
        }
        if (this.host_ != null) {
            if (this.scheme_.equals(SCHEME_UNIX)) {
                throw new IOException(String.format("Unexpected hostname: %s", this.host_));
            }
            if (this.host_.startsWith("[") && this.host_.endsWith("]")) {
                this.host_ = this.host_.substring(1, this.host_.length() - 1);
            }
        }
    }

    public void addCertFile(String string) {
        this.certfiles_.add(string);
    }

    public void rmCertFile(String string) {
        this.certfiles_.remove(string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Connection connect(Credentials credentials) throws IOException {
        Connection connection = null;
        if (this.scheme_.equals(SCHEME_RAD)) {
            connection = Connection.connectTCP(this.host_, this.port_);
        } else if (this.scheme_.equals(SCHEME_RADS)) {
            connection = Connection.connectTLS(this.host_, this.port_, this.certfiles_);
        } else if (this.scheme_.equals(SCHEME_SSH)) {
            connection = Connection.connectSSH(this.host_, this.user_);
        } else if (this.scheme_.equals(SCHEME_UNIX)) {
            connection = this.path_ == null ? Connection.connectUnix() : (this.path_.equals("/") ? Connection.connectUnix() : Connection.connectUnix(new File(this.path_)));
        }
        if (connection == null) {
            throw new IOException(String.format("Could not establish connection for URI : %s", this.src_));
        }
        if (this.class_ == null) return connection;
        if (credentials == null) {
            connection.close();
            throw new IOException(String.format("Credentials required for authentication: %s", this.src_));
        }
        if (this.class_.equals("pam")) {
            PAMCredentials pAMCredentials = (PAMCredentials)credentials;
            this.processPAMAuth(pAMCredentials, connection);
            return connection;
        }
        connection.close();
        throw new IOException(String.format("Unrecognised authentication: %s", this.class_));
    }

    public void processPAMAuth(PAMCredentials pAMCredentials, Connection connection) throws IOException {
        try {
            Class<?> clazz = Class.forName("com.oracle.solaris.rad.client.RadPamHandler");
            Constructor<?> constructor = clazz.getDeclaredConstructor(Connection.class);
            Object obj = constructor.newInstance(connection);
            Method method = obj.getClass().getMethod("login", String.class, String.class, String.class);
            method.invoke(obj, Locale.getDefault().toString(), this.user_, pAMCredentials.getPass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            System.out.println(invocationTargetException.getCause());
            throw new IOException(invocationTargetException);
        }
    }

    public String getAuth() {
        return this.auth_;
    }

    public String getCredClass() {
        return this.class_;
    }

    public void setCredClass(String string) throws IOException {
        if (!CREDENTIAL_CLASSES.contains(string)) {
            throw new IOException(String.format("Unrecognised authentication: %s", string));
        }
        this.class_ = string;
    }

    public String getHost() {
        return this.host_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getPort() {
        return this.port_;
    }

    public String getSrc() {
        return this.src_;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public Set<String> getSchemes() {
        return this.schemes_;
    }

    public String getUser() {
        return this.user_;
    }

    public String toString() {
        return String.format("<URIConnection %s>", this.src_);
    }

    static {
        DEFAULT_SCHEMES.add(SCHEME_UNIX);
        DEFAULT_SCHEMES.add(SCHEME_RAD);
        DEFAULT_SCHEMES.add(SCHEME_RADS);
        DEFAULT_SCHEMES.add(SCHEME_SSH);
        CREDENTIAL_CLASSES.add("pam");
    }
}

