/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.connect;

import com.oracle.solaris.rad.client.RadError;
import com.oracle.solaris.rad.client.RadException;
import com.oracle.solaris.rad.client.RadExistsException;
import com.oracle.solaris.rad.client.RadIllegalException;
import com.oracle.solaris.rad.client.RadMismatchException;
import com.oracle.solaris.rad.client.RadNoMemoryException;
import com.oracle.solaris.rad.client.RadNotFoundException;
import com.oracle.solaris.rad.client.RadObjectException;
import com.oracle.solaris.rad.client.RadPrivilegeException;
import com.oracle.solaris.rad.client.RadSystemException;
import com.oracle.solaris.rad.connect.Connection;
import com.oracle.solaris.rad.encodings.xdr.XDRInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Response {
    private long serial_;
    private boolean success_;
    private XDRInputStream payload_;
    private RadError error_;

    Response(long l, XDRInputStream xDRInputStream) throws IOException {
        this.serial_ = l;
        this.error_ = RadError.fromCode(xDRInputStream.getInteger());
        this.payload_ = new XDRInputStream(new ByteArrayInputStream(xDRInputStream.getOpaque()));
        this.success_ = this.error_ == RadError.OK;
    }

    public long getSerial() {
        return this.serial_;
    }

    public boolean isSuccess() {
        assert (this.serial_ != 0L);
        return this.success_;
    }

    public RadError getError() {
        assert (this.serial_ != 0L && !this.success_);
        return this.error_;
    }

    public XDRInputStream getPayload() {
        return this.payload_;
    }

    void throwException(String string) throws RadException {
        throw new RadException(string, this, this.getError());
    }

    void throwException(Connection connection, String string, Class<?> clazz, Class<?>[] classArray, boolean bl) throws IOException, RadException {
        switch (this.getError()) {
            case OBJECT: {
                throw new RadObjectException(connection, string, this, clazz, classArray, bl);
            }
            case NOMEM: {
                throw new RadNoMemoryException(string, this, this.getError());
            }
            case NOTFOUND: {
                throw new RadNotFoundException(string, this, this.getError());
            }
            case PRIV: {
                throw new RadPrivilegeException(string, this, this.getError());
            }
            case SYSTEM: {
                throw new RadSystemException(string, this, this.getError());
            }
            case EXISTS: {
                throw new RadExistsException(string, this, this.getError());
            }
            case MISMATCH: {
                throw new RadMismatchException(string, this, this.getError());
            }
            case ILLEGAL: {
                throw new RadIllegalException(string, this, this.getError());
            }
        }
        throw new RadException(string, this, this.getError());
    }

    public String toString() {
        if (this.serial_ == 0L) {
            return "Msg " + this.serial_ + ": event";
        }
        if (this.success_) {
            return "Msg " + this.serial_ + ": reply success";
        }
        return "Msg " + this.serial_ + ": reply failure (" + (Object)((Object)this.error_) + ")";
    }
}

