/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.connect;

import com.oracle.solaris.rad.client.ADRName;
import com.oracle.solaris.rad.client.ADRPattern;
import com.oracle.solaris.rad.client.ADRPatternScheme;
import com.oracle.solaris.rad.client.AttributeError;
import com.oracle.solaris.rad.client.Interface;
import com.oracle.solaris.rad.client.IsNullable;
import com.oracle.solaris.rad.client.ProxyInterface;
import com.oracle.solaris.rad.client.RadEvent;
import com.oracle.solaris.rad.client.RadEventInterface;
import com.oracle.solaris.rad.client.RadException;
import com.oracle.solaris.rad.client.Runtime;
import com.oracle.solaris.rad.client.Version;
import com.oracle.solaris.rad.connect.EventReader;
import com.oracle.solaris.rad.connect.Response;
import com.oracle.solaris.rad.connect.ZoneSocket;
import com.oracle.solaris.rad.encodings.xdr.RecordMarkingInputStream;
import com.oracle.solaris.rad.encodings.xdr.RecordMarkingOutputStream;
import com.oracle.solaris.rad.encodings.xdr.XDRInputStream;
import com.oracle.solaris.rad.encodings.xdr.XDROutputStream;
import com.oracle.solaris.rad.transports.PrivateTransport;
import com.oracle.solaris.rad.transports.RadTrustManager;
import com.oracle.solaris.rad.transports.SSHTransport;
import com.oracle.solaris.rad.transports.SocketTransport;
import com.oracle.solaris.rad.transports.Transport;
import com.oracle.solaris.rad.transports.UnixTransport;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class Connection
implements Closeable,
Runnable {
    private static final Logger log = Logger.getLogger(Connection.class.getName());
    private static final int PROTO_VERSION = 3;
    private static final int INVOKE = 0;
    private static final int GETATTR = 1;
    private static final int SETATTR = 2;
    private static final int LOOKUP = 3;
    private static final int LIST = 4;
    private static final int SUB = 5;
    private static final int UNSUB = 6;
    public static final int PORT_TLS = 12302;
    public static final String PATH_AFUNIX_AUTH = "/system/volatile/rad/radsocket";
    public static final String PATH_AFUNIX_UNAUTH = "/system/volatile/rad/radsocket-unauth";
    public static final int PROTO_ENCODE_XDR = 0;
    public static final String[] PROTO_ENCODE_STRS = new String[]{"XDR"};
    private boolean open_ = false;
    private Transport xport_ = null;
    private String locale_ = null;
    private RecordMarkingInputStream rmistream_ = null;
    private RecordMarkingOutputStream rmostream_ = null;
    private XDRInputStream xdristream_ = null;
    private XDROutputStream xdrostream_ = null;
    private Thread reader_ = null;
    private EventReader evreader_ = null;
    private long serial_ = 0L;
    private final Map<Long, Response> replies_ = new HashMap<Long, Response>();
    private final List<RadEvent> events_ = new LinkedList<RadEvent>();
    private boolean clean_ = false;
    private Map<Interface, List<RadEventInterface>> subscribers_ = new HashMap<Interface, List<RadEventInterface>>();
    private Map<Long, Interface> instances_ = new HashMap<Long, Interface>();

    public Connection(Transport transport) throws IOException {
        this(transport, null);
    }

    public Connection(Transport transport, String string) throws IOException {
        this.xport_ = transport;
        this.locale_ = string;
        if (this.locale_ == null) {
            this.locale_ = Locale.getDefault().getLanguage();
            if (this.locale_.equals("")) {
                this.locale_ = "C";
            }
        }
        this.connect();
    }

    public static Connection connectUnix() throws IOException {
        return Connection.connectUnix(new File(PATH_AFUNIX_AUTH), null);
    }

    public static Connection connectUnix(File file) throws IOException {
        return Connection.connectUnix(file, null);
    }

    public static Connection connectUnix(File file, String string) throws IOException {
        UnixTransport unixTransport = new UnixTransport(file);
        return new Connection(unixTransport, string);
    }

    public static Connection connectTCP(String string, int n) throws IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        return Connection.connectTCP(inetAddress, n);
    }

    public static Connection connectTCP(InetAddress inetAddress, int n) throws IOException {
        SocketTransport socketTransport = SocketTransport.newSocketTransport(inetAddress, n);
        return new Connection(socketTransport, null);
    }

    public static Connection connectTCP(Socket socket) throws IOException {
        SocketTransport socketTransport = new SocketTransport(socket);
        return new Connection(socketTransport, null);
    }

    public static Connection connectTLS(InetAddress inetAddress, String string, KeyStore keyStore, RadTrustManager radTrustManager) throws IOException {
        return Connection.connectTLS(inetAddress, string, 12302, keyStore, radTrustManager);
    }

    public static Connection connectTLS(InetAddress inetAddress, String string, int n, KeyStore keyStore, RadTrustManager radTrustManager) throws IOException {
        SocketTransport socketTransport = SocketTransport.newSSLSocketTransport(inetAddress, n, string, keyStore, radTrustManager);
        return new Connection(socketTransport, null);
    }

    public static Connection connectTLS(String string, Set<String> set) throws IOException {
        return Connection.connectTLS(string, 12302, set, null);
    }

    public static Connection connectTLS(String string, int n, Set<String> set) throws IOException {
        return Connection.connectTLS(string, n, set, null);
    }

    public static Connection connectTLS(String string, int n, Set<String> set, String string2) throws IOException {
        SocketTransport socketTransport = SocketTransport.newSSLSocketTransport(string, n, set);
        return new Connection(socketTransport, string2);
    }

    public static Connection connectSSH(String string, String string2, String string3) throws IOException {
        SSHTransport sSHTransport = new SSHTransport(string, string2);
        return new Connection(sSHTransport, string3);
    }

    public static Connection connectSSH(String string, String string2) throws IOException {
        return Connection.connectSSH(string, string2, null);
    }

    public static Connection connectPrivate() throws IOException {
        return Connection.connectPrivate("/", new LinkedList<String>(), new LinkedList<String>());
    }

    public static Connection connectPrivate(String string, List<String> list, List<String> list2) throws IOException {
        PrivateTransport privateTransport = new PrivateTransport(string, list, list2);
        return new Connection(privateTransport, null);
    }

    public static Connection connectZone(Connection connection, String string, String string2, String string3) throws IOException {
        try {
            Class<?> clazz = Class.forName("com.oracle.solaris.rad.zonesbridge.IO");
            ProxyInterface proxyInterface = (ProxyInterface)clazz.newInstance();
            ProxyInterface proxyInterface2 = (ProxyInterface)connection.getObject(proxyInterface);
            ZoneSocket zoneSocket = new ZoneSocket(proxyInterface2, string, string2);
            return new Connection(zoneSocket, string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                Object object;
                Object object2;
                long l;
                if ((l = this.xdristream_.getHyper()) != 0L) {
                    object2 = new Response(l, this.xdristream_);
                    log.finer(String.format("received reply %d; queuing", l));
                    object = this.replies_;
                    synchronized (object) {
                        this.replies_.put(l, (Response)object2);
                        this.replies_.notifyAll();
                    }
                }
                object2 = new RadEvent(this.xdristream_);
                log.finer("received event; queuing");
                object = this.events_;
                synchronized (object) {
                    this.events_.add((RadEvent)object2);
                    this.events_.notifyAll();
                }
                this.rmistream_.skipRecord();
            }
        }
        catch (IOException iOException) {
            Map<Long, Response> map = this.replies_;
            synchronized (map) {
                if (!this.clean_) {
                    log.warning("error reading message; exiting read loop");
                    try {
                        this.shutdown(false);
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    }

    public synchronized Interface getCachedInstance(Class<?> clazz, Long l) throws Exception {
        Interface interface_ = null;
        interface_ = this.instances_.get(l);
        if (interface_ == null) {
            Interface interface_2 = (Interface)clazz.newInstance();
            Interface interface_3 = (Interface)interface_2.instanceOf(this, l, interface_2.getName(), interface_2.getVersion());
            this.instances_.put(l, interface_3);
            return interface_3;
        }
        return interface_;
    }

    public synchronized Interface getCachedInstance(ProxyInterface proxyInterface, long l) {
        Interface interface_ = null;
        interface_ = this.instances_.get(new Long(l));
        if (interface_ == null) {
            Interface interface_2 = (Interface)proxyInterface.getInterface().instanceOf(this, l, proxyInterface.getName(), proxyInterface.getVersion());
            this.instances_.put(l, interface_2);
            return interface_2;
        }
        return interface_;
    }

    public List<ADRName> listObjects(ProxyInterface proxyInterface) throws IOException, RadException {
        return this.listObjects(proxyInterface, null, null);
    }

    public List<ADRName> listObjects(ProxyInterface proxyInterface, ADRPattern aDRPattern) throws IOException, RadException {
        return this.listObjects(proxyInterface, aDRPattern, null);
    }

    public List<ADRName> listObjects(ProxyInterface proxyInterface, ADRPattern aDRPattern, Version version) throws IOException, RadException {
        ADRPatternScheme aDRPatternScheme = aDRPattern != null ? aDRPattern.getScheme() : ADRPatternScheme.SC_GLOB;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
        ADRName aDRName = proxyInterface.getName();
        int n = aDRName.getKVPairs().size() + (aDRPattern != null ? aDRPattern.getKVPairs().size() : 0);
        xDROutputStream.putString(aDRName.getDomain());
        xDROutputStream.putInteger(n);
        Map<String, String> map = aDRName.getKVPairs();
        for (Map.Entry<String, String> object : map.entrySet()) {
            xDROutputStream.putString(object.getKey());
            xDROutputStream.putString(object.getValue());
        }
        if (aDRPattern != null) {
            map = aDRPattern.getKVPairs();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                xDROutputStream.putString(entry.getKey());
                xDROutputStream.putString(entry.getValue());
            }
        }
        if (version == null) {
            version = new Version(proxyInterface.getVersion().major_, -1);
        }
        xDROutputStream.putInteger(version.major_);
        xDROutputStream.putInteger(version.minor_);
        xDROutputStream.putInteger(aDRPatternScheme.ordinal());
        Response response = this.syncRequest(4, byteArrayOutputStream);
        if (response.isSuccess()) {
            XDRInputStream xDRInputStream = response.getPayload();
            n = xDRInputStream.getInteger();
            LinkedList<ADRName> linkedList = new LinkedList<ADRName>();
            for (int i = 0; i < n; ++i) {
                String string = xDRInputStream.getString();
                int n2 = xDRInputStream.getInteger();
                map = new HashMap<String, String>();
                for (int j = 0; j < n2; ++j) {
                    map.put(xDRInputStream.getString(), xDRInputStream.getString());
                }
                linkedList.add(new ADRName(string, map, proxyInterface, version));
            }
            return linkedList;
        }
        response.throwException(String.format("Error listing %s: %s", proxyInterface.toString(), response.toString()));
        return null;
    }

    public <T> T getObject(ProxyInterface proxyInterface) throws IOException, RadException {
        int n = 1;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
        ADRName aDRName = proxyInterface.getName();
        Map<String, String> map = aDRName.getKVPairs();
        xDROutputStream.putString(aDRName.getDomain());
        xDROutputStream.putInteger(map.size());
        for (Map.Entry<String, String> object : map.entrySet()) {
            xDROutputStream.putString(object.getKey());
            xDROutputStream.putString(object.getValue());
        }
        if (proxyInterface.getVersion() != null) {
            n = proxyInterface.getVersion().major_;
            n2 = proxyInterface.getVersion().minor_;
        }
        xDROutputStream.putInteger(n);
        xDROutputStream.putInteger(n2);
        Response response = this.syncRequest(3, byteArrayOutputStream);
        if (response.isSuccess()) {
            XDRInputStream xDRInputStream = response.getPayload();
            long l = xDRInputStream.getHyper();
            return (T)this.getCachedInstance(proxyInterface, l);
        }
        response.throwException(String.format("Error getting %s: %s", proxyInterface.toString(), response.toString()));
        return null;
    }

    private static Class<?>[] getErrorSubTypes(AttributeError attributeError) {
        if (attributeError == null) {
            return null;
        }
        Class[] classArray = new Class[]{attributeError.cclazz()[0] == Void.class ? null : attributeError.cclazz()[0], attributeError.cclazz()[1] == Void.class ? null : attributeError.cclazz()[1]};
        return classArray;
    }

    public Object getter(Interface interface_, String string) throws IOException, RadException {
        Object object;
        Class<?>[] classArray;
        Class<?> clazz;
        Object object2;
        Class<?> clazz2 = null;
        Class<?>[] classArray2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            object2 = Runtime.findAccessor(interface_, string);
            clazz = ((Method)object2).getReturnType();
            classArray = Runtime.findComponentType(((Method)object2).getGenericReturnType());
            bl = ((Method)object2).getAnnotation(IsNullable.class) != null;
            object = ((Method)object2).getAnnotation(AttributeError.class);
            if (object != null) {
                classArray2 = Connection.getErrorSubTypes((AttributeError)object);
                clazz2 = object.clazz();
                bl2 = object.is_nullable();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object2 = new ByteArrayOutputStream();
        object = new XDROutputStream((OutputStream)object2);
        ((XDROutputStream)object).putHyper(interface_.getID());
        ((XDROutputStream)object).putString(string);
        Response response = this.syncRequest(1, (ByteArrayOutputStream)object2);
        if (response.isSuccess()) {
            XDRInputStream xDRInputStream = response.getPayload();
            try {
                Object object3 = Runtime.readData(this, xDRInputStream, clazz, classArray, bl);
                return object3;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        response.throwException(this, String.format("Error getting %s on %s", string, interface_.toString()), clazz2, classArray2, bl2);
        return null;
    }

    public void setter(Interface interface_, String string, Class<?> clazz, Object object) throws IOException, RadException {
        Object object2;
        Class<?>[] classArray;
        Object object3;
        Class<?> clazz2;
        Object object4;
        Object object5;
        Class<?> clazz3 = null;
        Class<?>[] classArray2 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "set" + string;
        try {
            object5 = Runtime.findMutator(interface_, string2, clazz);
            object4 = ((Method)object5).getParameterTypes();
            clazz2 = object4[0];
            object3 = ((Method)object5).getGenericParameterTypes();
            classArray = Runtime.findComponentType(object3[0]);
            bl = ((Method)object5).getAnnotation(IsNullable.class) != null;
            object2 = ((Method)object5).getAnnotation(AttributeError.class);
            if (object2 != null) {
                classArray2 = Connection.getErrorSubTypes((AttributeError)object2);
                clazz3 = object2.clazz();
                bl2 = object2.is_nullable();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object5 = new ByteArrayOutputStream();
        object4 = new XDROutputStream((OutputStream)object5);
        try {
            Runtime.writeData(object4, clazz2, classArray, object, bl);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object3 = new ByteArrayOutputStream();
        object2 = new XDROutputStream((OutputStream)object3);
        ((XDROutputStream)object2).putHyper(interface_.getID());
        ((XDROutputStream)object2).putString(string);
        ((XDROutputStream)object2).putOpaque((ByteArrayOutputStream)object5);
        Response response = this.syncRequest(2, (ByteArrayOutputStream)object3);
        if (!response.isSuccess()) {
            log.finer("Error setting attr: " + string);
            response.throwException(this, String.format("Error setting %s on %s", string, interface_.toString()), clazz3, classArray2, bl2);
        }
    }

    public Object invoke(Interface interface_, String string, Class<?>[] classArray, Object[] objectArray) throws IOException, RadException {
        Class<?>[] classArray2;
        Object object;
        Object object2;
        Class<?>[] classArray3 = null;
        Type[] typeArray = null;
        Class clazz = Void.class;
        Class<?> clazz2 = null;
        Class<?>[] classArray4 = null;
        Class<?>[] classArray5 = null;
        boolean bl = false;
        boolean bl2 = false;
        Annotation[][] annotationArray = null;
        try {
            Method method = Runtime.findInvoker(interface_, string, classArray);
            classArray3 = method.getParameterTypes();
            typeArray = method.getGenericParameterTypes();
            clazz = method.getReturnType();
            annotationArray = method.getParameterAnnotations();
            classArray4 = Runtime.findComponentType(method.getGenericReturnType());
            bl = method.getAnnotation(IsNullable.class) != null;
            object2 = method.getAnnotation(AttributeError.class);
            if (object2 != null) {
                classArray5 = Connection.getErrorSubTypes((AttributeError)object2);
                clazz2 = object2.clazz();
                bl2 = object2.is_nullable();
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        int n = objectArray == null ? 0 : objectArray.length;
        object2 = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream((OutputStream)object2);
        xDROutputStream.putHyper(interface_.getID());
        xDROutputStream.putString(string);
        xDROutputStream.putInteger(n);
        for (int i = 0; i < n; ++i) {
            object = new ByteArrayOutputStream();
            XDROutputStream xDROutputStream2 = new XDROutputStream((OutputStream)object);
            boolean bl3 = false;
            for (Annotation annotation : annotationArray[i]) {
                if (annotation.annotationType() != IsNullable.class) continue;
                bl3 = true;
            }
            Class<?> clazz3 = classArray3[i];
            classArray2 = Runtime.findComponentType(typeArray[i]);
            try {
                Runtime.writeData(xDROutputStream2, clazz3, classArray2, objectArray[i], bl3);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            xDROutputStream.putOpaque((ByteArrayOutputStream)object);
        }
        Response response = this.syncRequest(0, (ByteArrayOutputStream)object2);
        if (response.isSuccess()) {
            classArray2 = response.getPayload();
            try {
                object = Runtime.readData(this, (XDRInputStream)classArray2, clazz, classArray4, bl);
                return object;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        log.finer("Error invoking method: " + string);
        response.throwException(this, String.format("Error invoking %s on %s", string, interface_.toString()), clazz2, classArray5, bl2);
        return null;
    }

    @Override
    public void close() throws IOException {
        this.shutdown(true);
    }

    public boolean isOpen() {
        return this.open_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RadEvent readEvent() throws IOException {
        try {
            List<RadEvent> list = this.events_;
            synchronized (list) {
                while (this.events_.size() == 0) {
                    if (!this.open_) {
                        throw new IOException("Connection closed");
                    }
                    this.events_.wait();
                }
                log.finer("dequeuing event");
                return this.events_.remove(0);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Event wait interrupted");
        }
    }

    public void subscribe(Interface interface_, String string, RadEventInterface radEventInterface) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
        xDROutputStream.putHyper(interface_.getID());
        xDROutputStream.putString(string);
        Response response = this.syncRequest(5, byteArrayOutputStream);
        if (!response.isSuccess()) {
            log.finer("Error subscribing to: " + string);
            response.throwException(String.format("Error subscribing to %s on %s", string, interface_.toString()));
        }
        this.putSubscriber(interface_, radEventInterface);
    }

    public void unsubscribe(Interface interface_, String string, RadEventInterface radEventInterface) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
        xDROutputStream.putHyper(interface_.getID());
        xDROutputStream.putString(string);
        Response response = this.syncRequest(6, byteArrayOutputStream);
        if (!response.isSuccess()) {
            log.finer("Error unsubscribing from: " + string);
            response.throwException(String.format("Error unsubscribing from %s on %s", string, interface_.toString()));
        }
        this.rmSubscriber(interface_, radEventInterface);
    }

    synchronized List<RadEventInterface> getSubscribers(long l) {
        Interface interface_ = this.getSubscriberInterface(l);
        if (interface_ != null) {
            return this.subscribers_.get(interface_);
        }
        return null;
    }

    synchronized Interface getSubscriberInterface(long l) {
        for (Interface interface_ : this.subscribers_.keySet()) {
            if (interface_.getID() != l) continue;
            return interface_;
        }
        return null;
    }

    synchronized void putSubscriber(Interface interface_, RadEventInterface radEventInterface) {
        List<RadEventInterface> list = this.subscribers_.get(interface_);
        if (list == null) {
            list = new LinkedList<RadEventInterface>();
            this.subscribers_.put(interface_, list);
        }
        list.add(radEventInterface);
    }

    synchronized void rmSubscriber(Interface interface_, RadEventInterface radEventInterface) {
        List<RadEventInterface> list = this.subscribers_.get(new Long(interface_.getID()));
        if (list == null) {
            return;
        }
        list.remove(radEventInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long sendRequest(int n, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        long l = ++this.serial_;
        try {
            this.xdrostream_.putHyper(l).putInteger(n);
            this.xdrostream_.putOpaque(byteArrayOutputStream);
            this.rmostream_.endOfRecord(true);
        }
        catch (IOException iOException) {
            Map<Long, Response> map = this.replies_;
            synchronized (map) {
                try {
                    this.shutdown(false);
                }
                catch (IOException iOException2) {
                    log.finer("Shutdown IO Exception: " + iOException2.toString());
                }
            }
            throw iOException;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response readResponse(long l) throws IOException {
        try {
            Map<Long, Response> map = this.replies_;
            synchronized (map) {
                Response response;
                while ((response = this.replies_.get(l)) == null) {
                    if (!this.open_) {
                        throw new IOException("Connection closed");
                    }
                    this.replies_.wait();
                }
                log.finer(String.format("dequeuing reply %d\n", response.getSerial()));
                return response;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Reply wait interrupted");
        }
    }

    private Response syncRequest(int n, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        return this.readResponse(this.sendRequest(n, byteArrayOutputStream));
    }

    private void connect() throws IOException {
        ReadableByteChannel readableByteChannel = Channels.newChannel(this.xport_.getInputStream());
        WritableByteChannel writableByteChannel = Channels.newChannel(this.xport_.getOutputStream());
        ByteBuffer byteBuffer = ByteBuffer.allocate(24);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        log.finer("reading supported versions");
        int n = readableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        byte[] byArray = new byte[16];
        byteBuffer.get(byArray);
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        if (n2 > 3 || 3 < n3) {
            throw new IOException(String.format("No common version available (client = %d,  server = [%d, %d])", 3, n2, n3));
        }
        log.finer("replying with selected version");
        byteBuffer = ByteBuffer.allocate(152);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(byArray);
        byteBuffer.putInt(3);
        byteBuffer.putInt(0);
        byteBuffer.put(Arrays.copyOf(this.locale_.getBytes(), 128));
        byteBuffer.flip();
        writableByteChannel.write(byteBuffer);
        this.xport_.getOutputStream().flush();
        byteBuffer.flip();
        byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        n = readableByteChannel.read(byteBuffer);
        byteBuffer.flip();
        int n4 = byteBuffer.getInt();
        if (n4 != Errors.PROTO_HANDSHAKE_SUCCESS.ordinal()) {
            throw new IOException(String.format("Protocol handshake error (client = %d, server = [%d, %d])", 3, n2, n3));
        }
        log.finer("protocol handshake complete");
        this.rmistream_ = new RecordMarkingInputStream(this.xport_.getInputStream());
        this.rmostream_ = new RecordMarkingOutputStream(this.xport_.getOutputStream());
        this.xdristream_ = new XDRInputStream(this.rmistream_);
        this.xdrostream_ = new XDROutputStream(this.rmostream_);
        log.finer("starting async reader thread");
        this.reader_ = new Thread((Runnable)this, "RAD asynchronous response reader");
        this.reader_.setDaemon(true);
        this.reader_.start();
        this.evreader_ = new EventReader(this, "RAD asynchronous event reader");
        this.evreader_.setDaemon(true);
        this.evreader_.start();
        this.open_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean bl) throws IOException {
        Map<Long, Response> map = this.replies_;
        synchronized (map) {
            if (this.open_) {
                List<RadEvent> list = this.events_;
                synchronized (list) {
                    this.open_ = false;
                    this.clean_ = bl;
                    this.replies_.notifyAll();
                    this.events_.notifyAll();
                }
                this.xport_.close();
                this.open_ = false;
            }
        }
    }

    public String toString() {
        String string = this.isOpen() ? "open" : "closed";
        return String.format("<%s Connection >", string);
    }

    public static enum Errors {
        PROTO_HANDSHAKE_SUCCESS,
        PROTO_HANDSHAKE_ERR_OLDPROTO,
        PROTO_HANDSHAKE_ERR_NEWPROTO,
        PROTO_HANDSHAKE_ERR_ENCODE;

    }
}

