/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.client;

import com.oracle.solaris.rad.encodings.xdr.XDRInputStream;
import com.oracle.solaris.rad.encodings.xdr.XDROutputStream;
import java.io.IOException;
import java.util.Date;

public class Utils {
    private static final int NSPERS = 1000000000;
    private static final int NSPERMS = 1000000;
    private static final int MSPERS = 1000;
    private static final int HALFMS = 500000;
    private static final long MAXSEC = 9223372036854775L;

    public static Date readTimeData(XDRInputStream xDRInputStream) throws IOException {
        long l = xDRInputStream.getHyper();
        int n = xDRInputStream.getInteger();
        if (l < 0L || l > 9223372036854775L || n < 0 || n >= 1000000000) {
            throw new IOException(String.format("Out of range time from server: %d.%d", l, n));
        }
        int n2 = n / 1000000;
        if (n - n2 * 1000000 >= 500000) {
            ++n2;
        }
        return new Date(l * 1000L + (long)n2);
    }

    public static void writeTimeData(XDROutputStream xDROutputStream, Date date) throws IOException {
        long l = date.getTime();
        long l2 = l / 1000L;
        long l3 = (l - l2 * 1000L) * 1000000L;
        assert (l3 < 1000000000L);
        xDROutputStream.putHyper(l2);
        xDROutputStream.putInteger((int)l3);
    }
}

