/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.client;

import com.oracle.solaris.rad.client.ADRName;
import com.oracle.solaris.rad.client.ADRUinteger;
import com.oracle.solaris.rad.client.Interface;
import com.oracle.solaris.rad.client.IsNullable;
import com.oracle.solaris.rad.client.Utils;
import com.oracle.solaris.rad.connect.Connection;
import com.oracle.solaris.rad.encodings.xdr.XDRInputStream;
import com.oracle.solaris.rad.encodings.xdr.XDROutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Runtime {
    private static final Map<Class<?>, Class<?>> PRIMITIVETOBOX;
    private static final String CHARSET = "ISO-8859-1";
    private static Charset _charset;

    public static Method findAccessor(Interface interface_, String string) throws IOException {
        String[] stringArray = new String[]{"get" + string, "is" + string};
        Class<?> clazz = interface_.getClass();
        NoSuchMethodException noSuchMethodException = null;
        for (String string2 : stringArray) {
            try {
                return clazz.getMethod(string2, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
            }
        }
        throw new IOException(noSuchMethodException);
    }

    public static Method findInvoker(Interface interface_, String string, Class<?>[] classArray) throws IOException {
        Class<?> clazz = interface_.getClass();
        Method method = null;
        try {
            method = classArray == null ? clazz.getMethod(string, new Class[0]) : clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException);
        }
        return method;
    }

    public static Method findMutator(Interface interface_, String string, Class<?> clazz) throws IOException {
        Class<?> clazz2 = interface_.getClass();
        Method method = null;
        try {
            method = clazz2.getMethod(string, clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException(noSuchMethodException);
        }
        return method;
    }

    public static Class<?>[] findComponentType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            return (Class[])Arrays.copyOf(typeArray, typeArray.length, Class[].class);
        }
        return null;
    }

    private static boolean isBasicType(Class<?> clazz) {
        return clazz != null && PRIMITIVETOBOX.containsValue(clazz);
    }

    private static Object readBasicType(XDRInputStream xDRInputStream, Class<?> clazz) throws IOException {
        if (clazz == Boolean.class) {
            return xDRInputStream.getBoolean();
        }
        if (clazz == Integer.class) {
            return xDRInputStream.getInteger();
        }
        if (clazz == Long.class) {
            return xDRInputStream.getHyper();
        }
        if (clazz == Float.class) {
            return Float.valueOf(xDRInputStream.getFloat());
        }
        if (clazz == Double.class) {
            return xDRInputStream.getDouble();
        }
        if (clazz == Void.class || clazz == Void.TYPE) {
            return null;
        }
        throw new IOException("Invalid data type: " + clazz);
    }

    private static Object readListData(Connection connection, XDRInputStream xDRInputStream, Class<?>[] classArray) throws IOException {
        Class<?> clazz = classArray[0];
        int n = (int)xDRInputStream.getUInteger();
        List list = Collections.emptyList();
        if (n > 0) {
            list = new ArrayList();
        }
        for (int i = 0; i < n; ++i) {
            list.add(Runtime.readData(connection, xDRInputStream, clazz, null, false));
        }
        return list;
    }

    private static Object readMapData(Connection connection, XDRInputStream xDRInputStream, Class<?>[] classArray) throws IOException {
        Class<?> clazz = classArray[0];
        Class<?> clazz2 = classArray[1];
        int n = (int)xDRInputStream.getUInteger();
        Map<Object, Object> map = n > 0 ? new HashMap() : Collections.emptyMap();
        for (int i = 0; i < n; ++i) {
            map.put(Runtime.readData(connection, xDRInputStream, clazz, null, false), Runtime.readData(connection, xDRInputStream, clazz2, null, false));
        }
        return map;
    }

    private static char[] byteToChar(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = _charset.decode(byteBuffer);
        Arrays.fill(byArray, (byte)0);
        return charBuffer.array();
    }

    private static Object readArrayData(XDRInputStream xDRInputStream, Class<?> clazz) throws IOException {
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == Byte.TYPE) {
            return xDRInputStream.getOpaque();
        }
        if (clazz2 == Character.TYPE) {
            return Runtime.byteToChar(xDRInputStream.getOpaque());
        }
        throw new IOException("Invalid array type: " + clazz2);
    }

    private static Object readEnumData(XDRInputStream xDRInputStream, Class<?> clazz) throws IOException {
        int n = xDRInputStream.getInteger();
        ?[] objArray = clazz.getEnumConstants();
        if (n >= 0 && n < objArray.length) {
            return objArray[n];
        }
        return null;
    }

    private static Object readStructData(Connection connection, XDRInputStream xDRInputStream, Class<?> clazz) throws IOException {
        Field[] fieldArray = clazz.getDeclaredFields();
        Object[] objectArray = new Object[fieldArray.length];
        Class[] classArray = new Class[fieldArray.length];
        int n = 0;
        for (Field field : fieldArray) {
            Class<?> clazz2;
            classArray[n] = clazz2 = field.getType();
            boolean bl = field.getAnnotation(IsNullable.class) != null;
            Class<?>[] classArray2 = Runtime.findComponentType(field.getGenericType());
            objectArray[n] = Runtime.readData(connection, xDRInputStream, clazz2, classArray2, bl);
            ++n;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new IOException(String.format("Unable to instantiate: %s", clazz));
        }
    }

    public static Object readData(Connection connection, XDRInputStream xDRInputStream, Class<?> clazz, Class<?>[] classArray, boolean bl) throws IOException {
        if (bl && !xDRInputStream.getBoolean()) {
            return null;
        }
        if (clazz.isPrimitive() || Runtime.isBasicType(clazz)) {
            return Runtime.readBasicType(xDRInputStream, clazz);
        }
        if (clazz.isArray()) {
            return Runtime.readArrayData(xDRInputStream, clazz);
        }
        if (clazz.isEnum()) {
            return Runtime.readEnumData(xDRInputStream, clazz);
        }
        if (clazz == String.class) {
            return xDRInputStream.getString();
        }
        if (clazz == List.class) {
            return Runtime.readListData(connection, xDRInputStream, classArray);
        }
        if (clazz == Map.class) {
            return Runtime.readMapData(connection, xDRInputStream, classArray);
        }
        if (clazz == BigInteger.class) {
            return xDRInputStream.getUHyper();
        }
        if (clazz == ADRUinteger.class) {
            return new ADRUinteger(xDRInputStream.getUInteger());
        }
        if (clazz == Date.class) {
            return Utils.readTimeData(xDRInputStream);
        }
        if (clazz == ADRName.class) {
            String string = xDRInputStream.getString();
            int n = xDRInputStream.getInteger();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < n; ++i) {
                hashMap.put(xDRInputStream.getString(), xDRInputStream.getString());
            }
            return new ADRName(string, hashMap);
        }
        if (Interface.class.isAssignableFrom(clazz)) {
            try {
                return connection.getCachedInstance(clazz, (Long)xDRInputStream.getHyper());
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
        return Runtime.readStructData(connection, xDRInputStream, clazz);
    }

    private static void writeBasicType(XDROutputStream xDROutputStream, Class<?> clazz, Object object) throws IOException {
        if (clazz == Boolean.class) {
            xDROutputStream.putBoolean((Boolean)object);
        } else if (clazz == Integer.class) {
            xDROutputStream.putInteger((Integer)object);
        } else if (clazz == Long.class) {
            xDROutputStream.putHyper((Long)object);
        } else if (clazz == Float.class) {
            xDROutputStream.putFloat(((Float)object).floatValue());
        } else if (clazz == Double.class) {
            xDROutputStream.putDouble((Double)object);
        } else if (clazz != Void.class && clazz != Void.TYPE) {
            throw new IOException("Invalid data type: " + clazz);
        }
    }

    private static void writeListData(XDROutputStream xDROutputStream, Class<?>[] classArray, Object object) throws IOException {
        Class<?> clazz = classArray[0];
        List list = (List)object;
        int n = list.size();
        xDROutputStream.putUInteger(n);
        for (Object e : list) {
            Runtime.writeData(xDROutputStream, clazz, null, e, false);
        }
    }

    private static void writeMapData(XDROutputStream xDROutputStream, Class<?>[] classArray, Object object, boolean bl) throws IOException {
        Class<?> clazz = classArray[0];
        Class<?> clazz2 = classArray[1];
        Map map = (Map)object;
        int n = map.size();
        xDROutputStream.putUInteger(n);
        for (Map.Entry entry : map.entrySet()) {
            Runtime.writeData(xDROutputStream, clazz, null, entry.getKey(), false);
            Runtime.writeData(xDROutputStream, clazz2, null, entry.getValue(), false);
        }
    }

    private static byte[] charToByte(char[] cArray) throws IOException {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        CharsetEncoder charsetEncoder = _charset.newEncoder();
        if (!charsetEncoder.canEncode((CharSequence)charBuffer)) {
            throw new IOException("Unable to encode opaque data");
        }
        ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
        return byteBuffer.array();
    }

    private static void writeArrayData(XDROutputStream xDROutputStream, Class<?> clazz, Object object) throws IOException {
        int n = Array.getLength(object);
        xDROutputStream.putUInteger(n);
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2 == Character.TYPE) {
            char[] cArray = (char[])object;
            byte[] byArray = Runtime.charToByte(cArray);
            xDROutputStream.putFixedOpaque(byArray, 0, byArray.length);
            Arrays.fill(byArray, (byte)0);
        } else if (clazz2 == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            xDROutputStream.putFixedOpaque(byArray, 0, byArray.length);
        } else {
            throw new IOException("Invalid array type: " + clazz2);
        }
    }

    private static void writeEnumData(XDROutputStream xDROutputStream, Class<?> clazz, Object object) throws IOException {
        int n;
        ?[] objArray = clazz.getEnumConstants();
        for (n = 0; n < objArray.length && !objArray[n].equals(object); ++n) {
        }
        xDROutputStream.putInteger(n);
    }

    private static void writeStructData(XDROutputStream xDROutputStream, Class<?> clazz, Object object) throws IOException {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            Class<?> clazz2 = field.getType();
            Class<?>[] classArray = Runtime.findComponentType(field.getGenericType());
            boolean bl = field.getAnnotation(IsNullable.class) != null;
            field.setAccessible(true);
            Object object2 = null;
            try {
                object2 = field.get(object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(String.format("Unable to access: %s", clazz));
            }
            Runtime.writeData(xDROutputStream, clazz2, classArray, object2, bl);
        }
    }

    public static void writeData(XDROutputStream xDROutputStream, Class<?> clazz, Class<?>[] classArray, Object object, boolean bl) throws IOException {
        if (bl) {
            if (object == null) {
                xDROutputStream.putBoolean(false);
                return;
            }
            xDROutputStream.putBoolean(true);
        }
        if (clazz.isPrimitive() || Runtime.isBasicType(clazz)) {
            Runtime.writeBasicType(xDROutputStream, clazz, object);
        } else if (clazz.isArray()) {
            Runtime.writeArrayData(xDROutputStream, clazz, object);
        } else if (clazz.isEnum()) {
            Runtime.writeEnumData(xDROutputStream, clazz, object);
        } else if (clazz == String.class) {
            xDROutputStream.putString((String)object);
        } else if (clazz == List.class) {
            Runtime.writeListData(xDROutputStream, classArray, object);
        } else if (clazz == Map.class) {
            Runtime.writeMapData(xDROutputStream, classArray, object, bl);
        } else if (clazz == BigInteger.class) {
            xDROutputStream.putUHyper((BigInteger)object);
        } else if (clazz == ADRUinteger.class) {
            xDROutputStream.putUInteger(((ADRUinteger)object).getValue());
        } else if (clazz == Date.class) {
            Utils.writeTimeData(xDROutputStream, (Date)object);
        } else if (clazz == ADRName.class) {
            ADRName aDRName = (ADRName)object;
            xDROutputStream.putString(aDRName.getDomain());
            Map<String, String> map = aDRName.getKVPairs();
            xDROutputStream.putInteger(map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                xDROutputStream.putString(entry.getKey());
                xDROutputStream.putString(entry.getValue());
            }
        } else if (Interface.class.isAssignableFrom(clazz)) {
            xDROutputStream.putHyper(((Interface)object).getID());
        } else {
            Runtime.writeStructData(xDROutputStream, clazz, object);
        }
    }

    static {
        HashMap<Class<Object>, Class<Void>> hashMap = new HashMap<Class<Object>, Class<Void>>();
        hashMap.put(Boolean.TYPE, Boolean.class);
        hashMap.put(Byte.TYPE, Byte.class);
        hashMap.put(Character.TYPE, Character.class);
        hashMap.put(Double.TYPE, Double.class);
        hashMap.put(Float.TYPE, Float.class);
        hashMap.put(Integer.TYPE, Integer.class);
        hashMap.put(Long.TYPE, Long.class);
        hashMap.put(Short.TYPE, Short.class);
        hashMap.put(Void.TYPE, Void.class);
        PRIMITIVETOBOX = Collections.unmodifiableMap(hashMap);
        _charset = Charset.forName(CHARSET);
    }
}

