/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.client;

import com.oracle.solaris.rad.client.Utils;
import com.oracle.solaris.rad.encodings.xdr.XDRInputStream;
import java.io.IOException;
import java.util.Date;

public class RadEvent {
    private long source_;
    private String event_;
    private Date tstamp_;
    private long seq_;
    private byte[] payload_;

    public RadEvent(XDRInputStream xDRInputStream) throws IOException {
        this.source_ = xDRInputStream.getHyper();
        this.seq_ = xDRInputStream.getHyper();
        this.tstamp_ = Utils.readTimeData(xDRInputStream);
        this.event_ = xDRInputStream.getString();
        this.payload_ = xDRInputStream.getOpaque();
    }

    public long getSource() {
        return this.source_;
    }

    public String getEvent() {
        return this.event_;
    }

    public byte[] getPayload() {
        return this.payload_;
    }

    public Date getTimeStamp() {
        return this.tstamp_;
    }

    public long getSequence() {
        return this.seq_;
    }

    public String toString() {
        return "RadEvent: " + this.source_ + "/" + this.event_;
    }
}

