/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.client;

import com.oracle.solaris.rad.client.ADRName;
import com.oracle.solaris.rad.client.EventMapping;
import com.oracle.solaris.rad.client.FeatureStability;
import com.oracle.solaris.rad.client.ProxyInterface;
import com.oracle.solaris.rad.client.RadObjectException;
import com.oracle.solaris.rad.client.Stability;
import com.oracle.solaris.rad.client.Version;
import com.oracle.solaris.rad.connect.Connection;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class Interface
implements ProxyInterface {
    private final Connection client_;
    private final long id_;
    private final ADRName name_;
    private final Version vers_;

    public Interface(Connection connection, ADRName aDRName, Version version) {
        this(connection, -1L, aDRName, version);
    }

    public Interface(Connection connection, long l, String string, Version version) {
        this(connection, l, new ADRName(string), version);
    }

    public Interface(Connection connection, String string, Version version) {
        this(connection, -1L, new ADRName(string), version);
    }

    public Interface(Connection connection, long l, ADRName aDRName, Version version) {
        this.client_ = connection;
        this.id_ = l;
        this.name_ = aDRName;
        this.vers_ = version;
    }

    @Override
    public String toString() {
        return this.name_.toString();
    }

    public Stability getStability() {
        FeatureStability featureStability = this.getClass().getAnnotation(FeatureStability.class);
        return featureStability.value();
    }

    public int getMajor() {
        return this.vers_.major_;
    }

    public int getMinor() {
        return this.vers_.minor_;
    }

    @Override
    public ADRName getName() {
        return this.name_;
    }

    @Override
    public Interface getInterface() {
        return this;
    }

    @Override
    public Version getVersion() {
        return this.vers_;
    }

    public long getID() {
        return this.id_;
    }

    public Class<?>[] getEventPayloadClass(String string) {
        Class<?> clazz = this.getClass();
        EventMapping eventMapping = null;
        eventMapping = clazz.getAnnotation(EventMapping.class);
        if (eventMapping != null) {
            String[] stringArray = eventMapping.names();
            Class<?>[] classArray = eventMapping.clazzes();
            Class<?>[] classArray2 = eventMapping.sclazzes();
            Class<?>[] classArray3 = eventMapping.vclazzes();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                Class[] classArray4 = new Class[]{classArray[i], classArray2[i], classArray3[i]};
                return classArray4;
            }
        }
        return null;
    }

    public <T> T instanceOf(Connection connection, long l, ADRName aDRName, Version version) {
        Class[] classArray = new Class[]{Connection.class, Long.TYPE, ADRName.class, Version.class};
        try {
            Constructor<?> constructor = this.getClass().getConstructor(classArray);
            return (T)constructor.newInstance(connection, l, aDRName, version);
        }
        catch (Exception exception) {
            System.err.println("Error: exception " + exception.toString());
            return null;
        }
    }

    protected Object invoke(String string) {
        return this.invoke(string, null, new Object[0]);
    }

    protected Object invoke(String string, Class<?>[] classArray, Object ... objectArray) {
        try {
            return this.client_.invoke(this, string, classArray, objectArray);
        }
        catch (IOException iOException) {
            throw new RadObjectException(iOException);
        }
    }

    protected void setattr(String string, Class<?> clazz, Object object) {
        try {
            this.client_.setter(this, string, clazz, object);
        }
        catch (IOException iOException) {
            throw new RadObjectException(iOException);
        }
    }

    protected Object getattr(String string) {
        try {
            return this.client_.getter(this, string);
        }
        catch (IOException iOException) {
            throw new RadObjectException(iOException);
        }
    }
}

