/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.client;

import com.oracle.solaris.rad.client.ADRPatternScheme;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ADRPattern {
    private String pattern_;
    private Map<String, String> kvpairs_;
    private ADRPatternScheme scheme_;

    ADRPattern(String string, ADRPatternScheme aDRPatternScheme) {
        String[] stringArray = string.split(",");
        int n = stringArray.length;
        this.kvpairs_ = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            this.kvpairs_.put(stringArray2[0], stringArray2[1]);
        }
        this.pattern_ = string;
        this.scheme_ = aDRPatternScheme;
    }

    ADRPattern(String[] stringArray, String[] stringArray2, ADRPatternScheme aDRPatternScheme) {
        if (stringArray != null && stringArray2 != null) {
            if (stringArray.length != stringArray2.length) {
                throw new IllegalArgumentException("Unequal number of keys and values");
            }
        } else if (stringArray != null || stringArray2 != null) {
            throw new IllegalArgumentException("Only one of keys and values specified");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.kvpairs_ = new HashMap<String, String>();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            this.kvpairs_.put(stringArray[i], stringArray2[i]);
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]);
            stringBuilder.append('=');
            stringBuilder.append(stringArray2[i]);
            string = ",";
        }
        this.pattern_ = stringBuilder.toString();
        this.scheme_ = aDRPatternScheme;
    }

    ADRPattern(Map<String, String> map, ADRPatternScheme aDRPatternScheme) {
        this.kvpairs_ = map;
        Set<Map.Entry<String, String>> set = map.entrySet();
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (Map.Entry<String, String> entry : set) {
            stringBuilder.append(string);
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue());
            string = ",";
        }
        this.pattern_ = stringBuilder.toString();
        this.scheme_ = aDRPatternScheme;
    }

    public String getPattern() {
        return this.pattern_;
    }

    public Map<String, String> getKVPairs() {
        return this.kvpairs_;
    }

    public ADRPatternScheme getScheme() {
        return this.scheme_;
    }

    public String toString() {
        return String.format("%s Pattern: %s", this.scheme_ == ADRPatternScheme.SC_GLOB ? "Glob" : "Regex", this.pattern_);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ADRPattern)) {
            return false;
        }
        ADRPattern aDRPattern = (ADRPattern)object;
        return this.kvpairs_.equals(aDRPattern.getKVPairs()) && this.scheme_ == aDRPattern.getScheme();
    }

    public int hashCode() {
        int n = 17 + this.scheme_.hashCode();
        n = n * 37 + this.pattern_.hashCode();
        return n;
    }
}

