/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.client;

import com.oracle.solaris.rad.client.Interface;
import com.oracle.solaris.rad.client.ProxyInterface;
import com.oracle.solaris.rad.client.Version;
import com.oracle.solaris.rad.connect.Connection;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ADRName
implements ProxyInterface {
    private String domain_;
    private Map<String, String> kvpairs_;
    private Version version_;
    private ProxyInterface proxy_;

    public ADRName(String string) {
        this(string, null, null);
    }

    public ADRName(String string, ProxyInterface proxyInterface, Version version) {
        String[] stringArray = string.split(":", 2);
        this.domain_ = stringArray[0];
        String[] stringArray2 = stringArray[1].split(",");
        int n = stringArray2.length;
        this.kvpairs_ = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray2[i].split("=", 2);
            this.kvpairs_.put(stringArray3[0], stringArray3[1]);
        }
        if (version == null) {
            version = new Version(1, 0);
        }
        this.version_ = version;
        if (proxyInterface == null) {
            proxyInterface = this.toProxy();
        }
        this.proxy_ = proxyInterface;
    }

    public ADRName(String string, Map<String, String> map) {
        this(string, map, null, null);
    }

    public ADRName(String string, Map<String, String> map, ProxyInterface proxyInterface, Version version) {
        this.domain_ = string;
        this.kvpairs_ = map;
        if (version == null) {
            version = new Version(1, 0);
        }
        this.version_ = version;
        if (proxyInterface == null) {
            proxyInterface = this.toProxy();
        }
        this.proxy_ = proxyInterface;
    }

    @Override
    public Version getVersion() {
        return this.version_;
    }

    @Override
    public ADRName getName() {
        return this;
    }

    public String getDomain() {
        return this.domain_;
    }

    public Map<String, String> getKVPairs() {
        return this.kvpairs_;
    }

    @Override
    public Interface getInterface() {
        return (Interface)this.proxy_;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.domain_);
        stringBuilder.append(":");
        Iterator<Map.Entry<String, String>> iterator = this.kvpairs_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringBuilder.append((Object)entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append((Object)entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ADRName)) {
            return false;
        }
        ADRName aDRName = (ADRName)object;
        return this.domain_.equals(aDRName.getDomain()) && this.kvpairs_.equals(aDRName.getKVPairs());
    }

    public int hashCode() {
        return this.domain_.hashCode() | this.kvpairs_.hashCode();
    }

    private ProxyInterface toProxy() {
        String string = this.domain_ + ".";
        string = string + this.kvpairs_.get("type");
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Connection.class, Long.TYPE, ADRName.class, Version.class};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return (ProxyInterface)constructor.newInstance(null, -1, this, this.version_);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

