/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.pools;

import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Property;
import com.sun.solaris.service.pools.PropertyWalk;
import com.sun.solaris.service.pools.Value;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class Element
implements Property,
PropertyWalk {
    protected Configuration _conf;
    private static final List cachedProperties = Arrays.asList("cpu.sys_id", "pool.default", "pool.sys_id", "pset.default", "pset.sys_id", "pset.type", "pset.units");
    private HashMap readOnlyValues = new HashMap();

    public String toString() {
        try {
            return this.getInformation(1);
        }
        catch (PoolsException poolsException) {
            return poolsException.toString();
        }
    }

    public abstract String getInformation(int var1) throws PoolsException;

    private Value getProperty(String string) throws PoolsException {
        if (this.readOnlyValues.containsKey(string)) {
            Value value = (Value)this.readOnlyValues.get(string);
            return value;
        }
        Value value = new Value(string);
        if (PoolInternal.pool_get_property(this._conf.getConf(), this.getElem(), string, value.getValue()) == PoolInternal.POC_INVAL) {
            throw new PoolsException();
        }
        if (cachedProperties.contains(string)) {
            value.lock();
            this.readOnlyValues.put(string, value);
        }
        return value;
    }

    protected Value getProperty(String string, long l) throws PoolsException {
        if (this.readOnlyValues.containsKey(string)) {
            Value value = (Value)this.readOnlyValues.get(string);
            return value;
        }
        Value value = new Value(string);
        if (PoolInternal.pool_get_property(this._conf.getConf(), l, string, value.getValue()) == PoolInternal.POC_INVAL) {
            throw new PoolsException();
        }
        if (cachedProperties.contains(string)) {
            value.lock();
            this.readOnlyValues.put(string, value);
        }
        return value;
    }

    @Override
    public void putProperty(String string, Value value) throws PoolsException {
        if (PoolInternal.pool_put_property(this._conf.getConf(), this.getElem(), string, value.getValue()) != 0) {
            throw new PoolsException();
        }
    }

    @Override
    public void rmProperty(String string) throws PoolsException {
        if (PoolInternal.pool_rm_property(this._conf.getConf(), this.getElem(), string) != 0) {
            throw new PoolsException();
        }
    }

    @Override
    public String getStringProperty(String string) throws PoolsException {
        Value value = this.getProperty(string);
        if (value != null) {
            String string2 = value.getString();
            value.close();
            return string2;
        }
        throw new PoolsException();
    }

    @Override
    public long getLongProperty(String string) throws PoolsException {
        Value value = this.getProperty(string);
        if (value != null) {
            long l = value.getLong();
            value.close();
            return l;
        }
        throw new PoolsException();
    }

    @Override
    public double getDoubleProperty(String string) throws PoolsException {
        Value value = this.getProperty(string);
        if (value != null) {
            double d = value.getDouble();
            value.close();
            return d;
        }
        throw new PoolsException();
    }

    @Override
    public boolean getBoolProperty(String string) throws PoolsException {
        Value value = this.getProperty(string);
        if (value != null) {
            boolean bl = value.getBool();
            value.close();
            return bl;
        }
        throw new PoolsException();
    }

    @Override
    public int walk(Element element, Value value, Object object) throws PoolsException {
        System.out.println("Property name: " + value.getName() + ", value: " + value.toString());
        value.close();
        return 0;
    }

    protected abstract long getElem() throws PoolsException;

    public int walkProperties(PropertyWalk propertyWalk, Object object) throws PoolsException {
        return this.walkProps(this._conf.getConf(), this.getElem(), propertyWalk, object);
    }

    private native int walkProps(long var1, long var3, PropertyWalk var5, Object var6) throws PoolsException;

    abstract String getKey();
}

