/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.service.pools;

import com.sun.solaris.service.pools.Configuration;
import com.sun.solaris.service.pools.Element;
import com.sun.solaris.service.pools.PoolInternal;
import com.sun.solaris.service.pools.PoolsException;
import com.sun.solaris.service.pools.Value;

public class Component
extends Element {
    private final String type;
    private final long sys_id;
    private final String key;

    Component(Configuration configuration, long l) throws PoolsException {
        this._conf = configuration;
        Value value = this.getProperty("type", l);
        this.type = value.getString();
        value.close();
        value = this.getProperty(this.type + ".sys_id", l);
        this.sys_id = value.getLong();
        value.close();
        this.key = this.type + "." + this.sys_id;
    }

    long getComponent() throws PoolsException {
        return this._conf.checkComponent(this.type, this.sys_id);
    }

    @Override
    public String getInformation(int n) throws PoolsException {
        return PoolInternal.pool_component_info(this._conf.getConf(), this.getComponent(), n);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append(" ");
        stringBuffer.append(this.sys_id);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Component)) {
            return false;
        }
        Component component = (Component)object;
        return this.type.compareTo(component.getType()) == 0 && this.sys_id == component.getSysId();
    }

    public int hashCode() {
        return this.type.hashCode() + (int)this.sys_id;
    }

    @Override
    protected long getElem() throws PoolsException {
        long l = PoolInternal.pool_component_to_elem(this._conf.getConf(), this.getComponent());
        if (l == 0L) {
            throw new PoolsException();
        }
        return l;
    }

    String getType() {
        return this.type;
    }

    long getSysId() {
        return this.sys_id;
    }

    @Override
    String getKey() {
        return this.key;
    }
}

