/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.Expression;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class KExpression
extends Expression {
    private static final Pattern pattern = Pattern.compile("\\s*((\\d+)\\s*:)?\\s*([\\w-]+)\\s*");
    private static final String[] keys = new String[]{"wt-load"};

    private KExpression(long l, String string) {
        super(l, string);
    }

    static Expression valueOf(String string) throws IllegalArgumentException {
        KExpression kExpression = null;
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            long l = 1L;
            if (matcher.group(2) != null) {
                l = KExpression.validateImportance(matcher.group(2));
            }
            KExpression.validateKeyword(keys, matcher.group(3));
            kExpression = new KExpression(l, matcher.group(3));
        }
        return kExpression;
    }

    public String toString() {
        return "(" + this.getImportance() + ", " + this.getName() + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KExpression)) {
            return false;
        }
        KExpression kExpression = (KExpression)object;
        return this.getName().compareTo(kExpression.getName()) == 0;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean contradicts(Expression expression) {
        if (!(expression instanceof KExpression)) {
            return false;
        }
        KExpression kExpression = (KExpression)expression;
        return this.getName().compareTo(kExpression.getName()) == 0;
    }
}

