/*
 * Decompiled with CFR 0.152.
 */
package com.sun.solaris.domain.pools;

import com.sun.solaris.domain.pools.KExpression;
import com.sun.solaris.domain.pools.KVExpression;
import com.sun.solaris.domain.pools.KVOpExpression;

abstract class Expression {
    private long imp = -1L;
    private String name;

    protected Expression(long l, String string) {
        this.imp = l;
        this.name = string;
    }

    String getName() {
        return this.name;
    }

    long getImportance() {
        return this.imp;
    }

    static Expression valueOf(String string) throws IllegalArgumentException {
        Expression expression = null;
        expression = KVOpExpression.valueOf(string);
        if (expression == null && (expression = KVExpression.valueOf(string)) == null) {
            expression = KExpression.valueOf(string);
        }
        if (expression == null) {
            throw new IllegalArgumentException("unrecognized expression: " + string);
        }
        return expression;
    }

    protected static long validateImportance(String string) throws IllegalArgumentException {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("importance value " + string + " is not legal");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("importance value " + string + " is not legal (must be positive)");
        }
        return l;
    }

    protected static void validateKeyword(String[] stringArray, String string) throws IllegalArgumentException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string) != 0) continue;
            return;
        }
        throw new IllegalArgumentException("keyword " + string + " is not recognized");
    }

    public abstract boolean contradicts(Expression var1);
}

