' $Header: emll/install/cert/uninstall.vbs /main/1 2013/07/26 09:09:00 jsutton Exp $
'
' uninstall.vbs
'
' Copyright (c) 2013, Oracle. All rights reserved.  
'
'    NAME
'      uninstall.vbs - CCR Package deinstall software script
'
'    DESCRIPTION
'      This script is invoked by the Oracle CCR package deployment
'      to deinstall the current version. 
'
'    MODIFIED   (MM/DD/YY)
'    jsutton     05/30/13 - Created
'
Option Explicit

Dim WshShell,WshEnv

Dim ExecCommand
Dim oExec,oStdErr,oStdOut

Dim FSO
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Dim CCRHome

'
' CCR uninstall for the CCR Cert package
'
Set WshShell = WScript.CreateObject("WScript.Shell")
Set WshEnv = WshShell.Environment("PROCESS")
Set FSO = CreateObject("Scripting.FileSystemObject")

CCRHome = WshEnv("CCR_HOME")
If (isUninitialized(CCRHome)) Then
 WScript.Echo "CCR Home is not defined"
 WScript.Quit(1)
End If

Call DelFile(CCRHome & "\admin\security\certca")

Dim dataDir : dataDir = FSO.BuildPath(CCRHome, "admin\security")
If (FSO.FolderExists(dataDir)) Then
    FSO.DeleteFolder(dataDir, True)
End If

WScript.Quit(0)

Private Function DelFile(ByVal filename)
{
    If (FSO.FileExists(filename)) Then
        Call FSO.FileDelete(filename)
    End If
}

'Check whether var is initialized or not
Public Function isUninitialized(ByVal var)
    If (IsEmpty(var) Or IsNull(var) Or Len(var)=0) then
        isUninitialized = True
    Else
        isUninitialized = False
    End If
End Function
