'
' $Header: emll/install/cert/install.vbs /main/1 2013/07/26 09:09:00 jsutton Exp $
'
' install.vbs
'
' Copyright (c) 2013, Oracle. All rights reserved.  
'
'    NAME
'      install.vbs - CCR Package install software script - Win32
'
'    DESCRIPTION
'      This script is invoked by the Oracle CCR package deployment
'      process and is used to install the software package.
'
'    NOTES
'      This script is written with the assumption that the error of
'      any command will terminate unless the error is being explicitly
'      handled.
'
'    MODIFIED   (MM/DD/YY)
'    jsutton     05/30/13 - Created
'

Dim WshShell,WshEnv

Dim ExecCommand
Dim oExec,oStdErr,oStdOut

Dim FSO
Const ForReading = 1
Const ForWriting = 2
Const ForAppending = 8

Dim CCRHome,OracleHome,JavaHome,javaHomeEnv

Set WshShell = WScript.CreateObject("WScript.Shell")
Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshEnv = WshShell.Environment("PROCESS")

' Include core utility
IncludeCoreUtils

CCRHome = WshEnv("CCR_HOME")
If (isUninitialized(CCRHome)) Then
 WScript.Echo "CCR Home is not defined"
 WScript.Quit(1)
End If

OracleHome = LCase(FSO.GetParentFolderName(CCRHome))

' First look for JAVA_HOME_CCR, then for JAVA_HOME
javaHomeEnv = UnquoteString(WshEnv("JAVA_HOME_CCR"))
If (isUninitialized(javaHomeEnv)) Then
    javaHomeEnv = UnquoteString(WshEnv("JAVA_HOME"))
End If

If (isUninitialized(javaHomeEnv)) Then
  javaHomeEnv = OracleHome & "\jdk"
Else
  If (FSO.FolderExists(javaHomeEnv)) Then
    javaHomeEnv = FSO.GetFolder(javaHomeEnv).ShortPath
  End If
End If
JavaHome = javaHomeEnv & "\bin"

Dim KITLOC, currDir
KITLOC = Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName,"\"))
currDir = FSO.GetFolder(".")

'
' Unpack the payload ZIP file directly into the CCR\admin\security home
'
Dim dataDir : dataDir = FSO.BuildPath(CCRHome, "admin\security" )
If (Not FSO.FolderExists(dataDir)) Then
    FSO.CreateFolder(dataDir)
End If

WshShell.CurrentDirectory = CCRHome
'
' If jdk/jar is available then use it, Otherwise use our util.
'
Dim Jar_Exe : Jar_Exe = FSO.BuildPath(JavaHome, "jar.exe")
Dim CCRHomeBin : CCRHomeBin = FSO.BuildPath(CCRHome, "bin")
If (Not FSO.FileExists(Jar_Exe)) Then
   Jar_Exe = FSO.BuildPath(CCRHomeBin, "ocmJarUtil.bat")
   If (Not FSO.FileExists(Jar_Exe)) Then
      WScript.Echo "OCM JAR Util is not found."
      WScript.Quit(1)
   End If
End If

Call runProc(Jar_Exe," xf " & KITLOC & "\payload.zip")

' Change the hardcoded password of the keystore we ship to a random one
ChangeKeystorePasswd

WshShell.CurrentDirectory = currDir
WScript.Quit(0)

' Subroutine - ChangeKeystorePasswd
' Changes the password of the keystore to a random one
' (The passwd of the keystore we ship is hardcoded currently)
' Ignores all errors, just reports them as warnings
Private Sub ChangeKeystorePasswd
  printDebug "* install ChangeKeystorePasswd "
  Dim keyTool_Exe : keyTool_Exe = FSO.BuildPath(JavaHome, "keytool.exe")
  If (Not FSO.FileExists(keyTool_Exe)) Then
    WScript.Echo "Keytool is not found"
    Exit Sub
  End If

  Dim keyStore : keyStore = FSO.BuildPath(CCRHome, "admin\security\certca")
  If (Not FSO.FileExists(keyStore)) Then
    WScript.Echo "Keystore is not found"
    Exit Sub
  End If

  ' Get the CCR Temporary directory (its set by deployPackages.vbs)
  Dim CcrTemp
  CcrTemp = GetEnvironmentalValue("CCR_TEMP")

  Dim tmpKeyTool, tmpObj
  tmpKeyTool = CcrTemp & "\keytool." & Int(1000 * Rnd)
  ' First remove the temp file if it already existed
  If (FSO.FileExists(tmpKeyTool)) Then
    Call FSO.DeleteFile(tmpKeyTool)
  End If
  Set tmpObj = FSO.CreateTextFile(tmpKeyTool, True)
  tmpObj.Close

  If (Not FSO.FileExists(tmpKeyTool)) Then
    WScript.Echo "Unable to create temp file in " & CcrTemp
    Exit Sub
  End If

  ' Generate random password for keystore
  Dim nowTime, oldPasswd, newPasswd, outStream
  nowTime = Now
  oldPasswd = "LiveLinkRootCA"
  newPasswd = "OCMRootCA" & Month(nowTime) & Day(nowTime) & Year(nowTime) _
              & Hour(nowTime) & Minute(nowTime) & Second(nowTime)
  printDebug "New Passwd: " & newPasswd
  set outStream = FSO.OpenTextFile(tmpKeyTool, ForAppending, True)
  outStream.WriteLine(newPasswd)
  outStream.WriteLine(newPasswd)
  outStream.Close

  ' Do not set passwd through command line option, read it thro a file
  ' Execute this inline because we are redirecting stdin
  Dim execCmd
  execCmd = "%comspec% /C " & keyTool_Exe & " -storepass " & oldPasswd _
             & " -storepasswd -keystore " & keyStore & " < " & tmpKeyTool _
             & " > NUL 2>&1"
  printDebug "Exec: " & execCmd
  Set oExec = WshShell.Exec(ExecCmd)
  Do While oExec.Status = 0
    WScript.Sleep(25)
  Loop

  If (oExec.ExitCode = 0) Then
    WScript.Echo "Keystore password updated successfully"
  Else
    WScript.Echo "Unable to update keystore password"
  End If

  ' Cleanup
  Call FSO.DeleteFile(tmpKeyTool)
End Sub

' Includes the core utility file.
Private Sub IncludeCoreUtils
  Dim CoreUtils
  ' get directory context of this script, coreutils must be in the same directory
  CoreUtils = LCase(Left(WScript.ScriptFullName, InStrRev(WScript.ScriptFullName,"\")))
  CoreUtils = CoreUtils & "coreutil.vbs"
  IncludeFileAbs CoreUtils
End Sub

' Includes a file in the global namespace of the current script.
' The file can contain any VBScript source code.
' The path of the file name must be specified absolute (or
' relative to the current directory).
Private Sub IncludeFileAbs (ByVal FileName)
   Dim f: set f = FSO.OpenTextFile(FileName,ForReading)
   Dim s: s = f.ReadAll()
   ExecuteGlobal s
End Sub

