#!/bin/sh
#
# $Header: emll/install/cert/install.sh /main/2 2013/10/24 09:55:03 jsutton Exp $
#
# install.sh
#
# Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
#
#    NAME
#      install.sh - CCR Package install software script
#
#    DESCRIPTION
#      This script is invoked by the Oracle CCR package deployment
#      process and is used to unpack the distribution in the target
#      directory. 
#
#    MODIFIED   (MM/DD/YY)
#    jsutton     10/22/13 - add definitions
#    jsutton     05/30/13 - creation
#

_usrBinDir=/usr/bin
_binDir=/bin
_usrLocalBinDir=/usr/local/bin

CHMOD=${_binDir}/chmod
DATE=${_binDir}/date
DIRNAME=${_usrBinDir}/dirname
ECHO=${_binDir}/echo
MKDIR=${_binDir}/mkdir
MKTEMP=${_binDir}/mktemp
RM=${_binDir}/rm
RMF="$RM -f"
TOUCH=${_binDir}/touch

if [ -f ${_binDir}/uname ]
then
     UNAME=${_binDir}/uname
elif [ -f ${_usrBinDir}/uname ]
then
     UNAME=${_usrBinDir}/uname
fi

if [ ! -z "${JAVA_HOME_CCR}" ]
then
    _JAVA_HOME=${JAVA_HOME_CCR}
elif [ ! -z "${JAVA_HOME}" ]
    then
        _JAVA_HOME=${JAVA_HOME}
    else
        _JAVA_HOME=${ORACLE_HOME}/jdk
fi

# find jre home, if jdk home is not found
if [ ! -f ${_JAVA_HOME}/bin/java ]
then
  _JAVA_HOME=${ORACLE_HOME}/jre
fi

#
#Use jdk/jar if available, Otherwise use our util.
#
if [ -f ${_JAVA_HOME}/bin/jar ] 
then
  JAR=${_JAVA_HOME}/bin/jar
else
  if [ -f ${CCR_HOME}/bin/ocmJarUtil ]
  then
     JAR=${CCR_HOME}/bin/ocmJarUtil
  else
     echo "OCM JAR Util is not found"
     exit 3 
  fi
fi

if [ -f ${_binDir}/cut ]
then
    CUT=${_binDir}/cut
elif [ -f ${_usrBinDir}/cut ]
then
    CUT=${_usrBinDir}/cut
fi

PLATFORM=`$UNAME | $CUT -f1 -d' '`

if [ -z "${CCR_HOME}" ]; then
   echo "CCR_HOME is not defined";
   exit 1;
fi

#
# function - changeKeystorePasswd
# Changes the password of the keystore to a random one
# (The passwd of the keystore we ship is hardcoded currently)
# Ignores all errors, just reports them as warnings
#
changeKeystorePasswd()
{
  if [ -f ${_JAVA_HOME}/bin/keytool ]
  then
    KEYTOOL=${_JAVA_HOME}/bin/keytool
  else
    $ECHO 'Keytool is not found'
    return
  fi

  _keyStore=${CCR_HOME}/admin/security/certca
  if [ ! -f "${_keyStore}" ]
  then
    $ECHO 'Keystore is not found'
    return
  fi

  # Save the original shell flags
  _originalShellFlags=$-
  # Disable shell exit on error
  set +e

  # CCR_TEMP is set by deployPackages
  if [ "${PLATFORM}" = "Linux" ]; then
    _tmpKeytool=`$MKTEMP ${CCR_TEMP}/keytool.XXXXXX`
  else
    _tmpKeytool=${CCR_TEMP}/keytool.$$
    # First remove the temp file if it already existed
    if [ -f "${_tmpKeytool}" ]
    then
      $RMF ${_tmpKeytool}
    fi
    $TOUCH ${_tmpKeytool}
  fi
  if [ ! -f ${_tmpKeytool} ]
  then
    $ECHO 'Unable to create temp file in ${CCR_TEMP}'
    # Reset original shell flags only if there were any
    if [ ! -z "${_originalShellFlags}" ]
    then
      set ${_originalShellFlags}
    fi
    return
  fi

  # Generate random password for keystore
  _curDate=`$DATE +%m%d%Y%H%M%S`
  $ECHO "OCMRootCA${_curDate}" > ${_tmpKeytool}
  $ECHO "OCMRootCA${_curDate}" >> ${_tmpKeytool}

  # Do not set passwd through command line option, read it thro redirection
  $KEYTOOL -storepass "LiveLinkRootCA" -storepasswd -keystore ${_keyStore} < ${_tmpKeytool} >/dev/null 2>&1

  if [ $? -eq 0 ]
  then
    $ECHO 'Keystore password updated successfully'
  else
    $ECHO 'Unable to update keystore password'
  fi

  # Cleanup
  $RMF ${_tmpKeytool}
  # Reset original shell flags only if there were any
  if [ ! -z "${_originalShellFlags}" ]
  then
    set ${_originalShellFlags}
  fi
}

returnExitCodeOnExit()
{
    exit $?
}

if [ "${PLATFORM}" = "SunOS" ]
then
    trap "trap returnExitCodeOnExit 0" 0
elif [ "${PLATFORM}" = "Linux" ]
then
    trap returnExitCodeOnExit EXIT
else
    trap returnExitCodeOnExit ERR
fi

CWD=$PWD
KITLOC=`$DIRNAME $0`

if [ -z "$CCR_HOME" ]; then
   echo "CCR Home is not defined";
   exit 1;
fi

$MKDIR -p $CCR_HOME/admin/security
$CHMOD 740 $CCR_HOME/admin/security

cd $CCR_HOME/
$JAR -xvf ${KITLOC}/payload.zip
cd $CWD

# Change the hardcoded password of the keystore we ship to a random one
changeKeystorePasswd

exit 0
