/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class HelpDialog
extends Dialog {
    protected Button b;
    protected TextArea t;
    private Frame parent;
    public static int NUM_ROWS = 10;
    public static int NUM_COLS = 45;
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");

    public HelpDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, NUM_ROWS, NUM_COLS);
    }

    public HelpDialog(Frame frame, String string, boolean bl, int n, int n2) {
        super(frame, string, bl);
        this.parent = frame;
        this.setBackground(frame.getBackground());
        this.setForeground(frame.getForeground());
        this.addButtonAndTextArea(n, n2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HelpDialog.this.quit();
            }
        });
    }

    protected void quit() {
        this.dispose();
    }

    private void addButtonAndTextArea(int n, int n2) {
        this.t = new TextArea(null, n, n2, 1);
        this.t.setEditable(false);
        this.b = new Button(HelpDialog.getString("Dismiss"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.t, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.add((Component)this.b, gridBagConstraints);
        this.pack();
        this.setResizable(false);
        this.setLocationBesideParent(this.parent);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpDialog.this.quit();
            }
        });
    }

    private void setLocationBesideParent(Frame frame) {
        Point point = frame.getLocationOnScreen();
        Dimension dimension = frame.getSize();
        Dimension dimension2 = this.getSize();
        point.x += dimension.width;
        point.y += dimension.height / 2 - dimension2.height / 2;
        this.setLocation(point.x, point.y);
    }

    public void setText(String string) {
        this.t.setText(string);
    }

    private static final String getString(String string) {
        try {
            String string2 = rb.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }
}

