/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DateTimeDialog
extends Dialog {
    private boolean save;
    private Frame parent;
    private DCPanel dateDCPanel;
    private DCPanel yearDCPanel;
    private DCPanel hourDCPanel;
    private DCPanel minuteDCPanel;
    private DCPanel secondDCPanel;
    private Choice month;
    private DCCircularTextField date;
    private DCCircularTextField hour;
    private DCCircularTextField second;
    private DCCircularTextField minute;
    private DCTextField year;
    private Button ok;
    private Button cancel;
    private Button help;
    private Button now;
    private Button midnight;
    private HelpDialog hd = null;
    private Panel topPanel;
    private Panel middlePanel;
    private Panel bottomPanel;
    private GregorianCalendar calendar = null;
    private static int[] MONTH_LEN = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static DateFormat df = DateFormat.getDateTimeInstance(2, 2);
    private static Toolkit toolkit = Toolkit.getDefaultToolkit();
    private static ResourceBundle rb = ResourceBundle.getBundle("GuiResource");
    private static ResourceBundle hrb = ResourceBundle.getBundle("HelpData");

    public DateTimeDialog(Frame frame, Color color, Color color2) {
        super(frame, DateTimeDialog.getString("SEAM Date/Time Helper"), true);
        this.parent = frame;
        this.setLayout(new GridBagLayout());
        this.addLabels();
        this.addFields(color, color2);
        this.addDCPanels();
        this.addButtons();
        this.addFocusListeners();
        this.setCurrentTime();
        this.setSize(250, 300);
        this.setResizable(false);
        this.addWindowListener(new DCWindowListener());
    }

    private void addLabels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        this.topPanel = new Panel();
        this.topPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.topPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        this.topPanel.add((Component)new Label(DateTimeDialog.getString("Month")), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.topPanel.add((Component)new Label(DateTimeDialog.getString("Date")), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.topPanel.add((Component)new Label(DateTimeDialog.getString("Year")), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.topPanel.add((Component)new Label(DateTimeDialog.getString("Hour")), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.topPanel.add((Component)new Label(DateTimeDialog.getString("Minute")), gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.topPanel.add((Component)new Label(DateTimeDialog.getString("Second")), gridBagConstraints);
    }

    private void addFields(Color color, Color color2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        this.month = new Choice();
        this.initializeMonth();
        this.date = new DCCircularTextField("1", 2);
        this.date.setMinimum(1);
        this.date.setBackground(color);
        this.date.setForeground(color2);
        this.hour = new DCCircularTextField("00", 2);
        this.hour.setMaximum(23);
        this.hour.setBackground(color);
        this.hour.setForeground(color2);
        this.minute = new DCCircularTextField("00", 2);
        this.minute.setBackground(color);
        this.minute.setForeground(color2);
        this.second = new DCCircularTextField("00", 2);
        this.second.setBackground(color);
        this.second.setForeground(color2);
        this.year = new DCTextField("2000", 4);
        this.year.setBackground(color);
        this.year.setForeground(color2);
        Panel panel = new Panel();
        panel.add(this.month);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.topPanel.add((Component)panel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.topPanel.add((Component)this.date, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.topPanel.add((Component)this.year, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.topPanel.add((Component)this.hour, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.topPanel.add((Component)this.minute, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.topPanel.add((Component)this.second, gridBagConstraints);
    }

    private void addDCPanels() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        this.dateDCPanel = new DCPanel();
        this.yearDCPanel = new DCPanel();
        this.hourDCPanel = new DCPanel();
        this.minuteDCPanel = new DCPanel();
        this.secondDCPanel = new DCPanel();
        gridBagConstraints.gridy = 1;
        this.topPanel.add((Component)this.dateDCPanel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        this.topPanel.add((Component)this.yearDCPanel, gridBagConstraints);
        this.topPanel.add((Component)this.hourDCPanel, gridBagConstraints);
        this.topPanel.add((Component)this.minuteDCPanel, gridBagConstraints);
        this.topPanel.add((Component)this.secondDCPanel, gridBagConstraints);
        this.dateDCPanel.setListener(this.date);
        this.yearDCPanel.setListener(this.year);
        this.hourDCPanel.setListener(this.hour);
        this.minuteDCPanel.setListener(this.minute);
        this.secondDCPanel.setListener(this.second);
    }

    private void initializeMonth() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
        String[] stringArray = dateFormatSymbols.getMonths();
        this.month.removeAll();
        for (int i = 0; i < stringArray.length; ++i) {
            this.month.add(stringArray[i]);
        }
        this.month.addItemListener(new DCMonthChangeListener());
    }

    private void addButtons() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        this.middlePanel = new Panel();
        this.now = new Button(DateTimeDialog.getString("Now"));
        this.midnight = new Button(DateTimeDialog.getString("Midnight"));
        this.middlePanel.add(this.midnight);
        this.middlePanel.add(this.now);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.middlePanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)new LineSeparator(), gridBagConstraints);
        this.bottomPanel = new Panel();
        this.ok = new Button(DateTimeDialog.getString("OK"));
        this.cancel = new Button(DateTimeDialog.getString("Cancel"));
        this.help = new Button(DateTimeDialog.getString("Help"));
        this.bottomPanel.add(this.ok);
        this.bottomPanel.add(this.cancel);
        this.bottomPanel.add(this.help);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.bottomPanel, gridBagConstraints);
        DCButtonListener dCButtonListener = new DCButtonListener();
        this.ok.addActionListener(dCButtonListener);
        this.cancel.addActionListener(dCButtonListener);
        this.help.addActionListener(dCButtonListener);
        this.now.addActionListener(dCButtonListener);
        this.midnight.addActionListener(dCButtonListener);
    }

    private void addFocusListeners() {
        DCFocusListener dCFocusListener = new DCFocusListener();
        this.date.addFocusListener(dCFocusListener);
        this.year.addFocusListener(dCFocusListener);
        this.hour.addFocusListener(dCFocusListener);
        this.minute.addFocusListener(dCFocusListener);
        this.second.addFocusListener(dCFocusListener);
    }

    private void dateTimeDialogClose(boolean bl) {
        if (bl && !this.updateFromGui()) {
            return;
        }
        this.save = bl;
        this.setVisible(false);
    }

    private boolean updateFromGui() {
        return this.checkErrorAndSet(this.date) && this.checkErrorAndSet(this.year) && this.checkErrorAndSet(this.hour) && this.checkErrorAndSet(this.minute) && this.checkErrorAndSet(this.second);
    }

    private boolean checkErrorAndSet(DCTextField dCTextField) {
        int n = 0;
        boolean bl = false;
        try {
            n = new Integer(dCTextField.getText().trim());
            bl = !dCTextField.checkValue(n);
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        if (bl) {
            dCTextField.selectAll();
            toolkit.beep();
        } else {
            dCTextField.setValue(n);
        }
        return !bl;
    }

    public boolean isSaved() {
        return this.save;
    }

    public void setCurrentTime() {
        this.setDate(new Date());
    }

    public void setDate(Date date) {
        this.calendar = new GregorianCalendar();
        this.calendar.setTime(date);
        this.year.setValue(this.calendar.get(1));
        this.month.select(this.calendar.get(2));
        this.date.setValue(this.calendar.get(5));
        this.fixDateField();
        this.hour.setValue(this.calendar.get(11));
        this.minute.setValue(this.calendar.get(12));
        this.second.setValue(this.calendar.get(13));
    }

    private void setMidnight() {
        this.hour.setValue(0);
        this.minute.setValue(0);
        this.second.setValue(0);
    }

    private void fixDateField() {
        int n = this.month.getSelectedIndex();
        int n2 = MONTH_LEN[n];
        this.date.setMaximum(this.calendar.isLeapYear(this.year.getValue()) && n == 1 ? n2 + 1 : n2);
    }

    @Override
    public String toString() {
        this.calendar = new GregorianCalendar(this.year.getValue(), this.month.getSelectedIndex(), this.date.getValue(), this.hour.getValue(), this.minute.getValue(), this.second.getValue());
        return df.format(this.calendar.getTime());
    }

    private static final String getString(String string) {
        return DateTimeDialog.getString(rb, string);
    }

    private static final String getString(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource " + string + ", using English.");
            return string;
        }
    }

    private class DCFocusListener
    extends FocusAdapter {
        private DCFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!DateTimeDialog.this.checkErrorAndSet((DCTextField)focusEvent.getSource())) {
                ((DCTextField)focusEvent.getSource()).requestFocus();
            }
        }
    }

    private class DCButtonListener
    implements ActionListener {
        private DCButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == DateTimeDialog.this.ok) {
                DateTimeDialog.this.dateTimeDialogClose(true);
            } else if (actionEvent.getSource() == DateTimeDialog.this.cancel) {
                DateTimeDialog.this.dateTimeDialogClose(false);
            } else if (actionEvent.getSource() == DateTimeDialog.this.now) {
                DateTimeDialog.this.setCurrentTime();
            } else if (actionEvent.getSource() == DateTimeDialog.this.midnight) {
                DateTimeDialog.this.setMidnight();
            } else if (actionEvent.getSource() == DateTimeDialog.this.help) {
                if (DateTimeDialog.this.hd != null) {
                    DateTimeDialog.this.hd.show();
                } else {
                    DateTimeDialog.this.hd = new HelpDialog(DateTimeDialog.this.parent, DateTimeDialog.getString("Help for Date and Time Dialog"), false);
                    DateTimeDialog.this.hd.setVisible(true);
                    DateTimeDialog.this.hd.setText(DateTimeDialog.getString(hrb, "DateTimeDialogHelp"));
                }
            }
        }
    }

    private class DCMonthChangeListener
    implements ItemListener {
        private DCMonthChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            DateTimeDialog.this.fixDateField();
        }
    }

    private class DCWindowListener
    extends WindowAdapter {
        private DCWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            DateTimeDialog.this.dateTimeDialogClose(false);
        }
    }
}

