/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ChoiceDialog
extends Dialog {
    private String result = null;

    public ChoiceDialog(Frame frame, String string, String[] stringArray, String[] stringArray2, int n, int n2) {
        super(frame, string, true);
        this.addLinesAndButtons(stringArray, stringArray2);
        this.positionDialog(n, n2);
        this.finishDialog();
    }

    public ChoiceDialog(Frame frame, String string, String[] stringArray, String[] stringArray2) {
        super(frame, string, true);
        this.addLinesAndButtons(stringArray, stringArray2);
        this.positionDialog(frame);
        this.finishDialog();
    }

    public void addLinesAndButtons(String[] stringArray, String[] stringArray2) {
        Component component;
        int n;
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        for (n = 0; n < stringArray.length; ++n) {
            component = new Label(" " + stringArray[n]);
            panel.add(component, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.add((Component)panel, "Center");
        panel = new Panel();
        panel.setLayout(new FlowLayout(1, 20, 5));
        for (n = 0; n < stringArray2.length; ++n) {
            component = new Button(stringArray2[n]);
            ((Button)component).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChoiceDialog.this.result = actionEvent.getActionCommand();
                    ChoiceDialog.this.dispose();
                }
            });
            panel.add(component);
        }
        this.add((Component)panel, "South");
    }

    public void finishDialog() {
        Frame frame = (Frame)this.getParent();
        this.setResizable(false);
        this.setBackground(frame.getBackground());
        this.setForeground(frame.getForeground());
        this.addWindowListener(new WindowCloseListener());
        this.setVisible(true);
    }

    public void positionDialog(Frame frame) {
        Point point = frame.getLocationOnScreen();
        Dimension dimension = frame.getSize();
        this.pack();
        Dimension dimension2 = this.getSize();
        point.x += dimension.width / 2 - dimension2.width / 2;
        point.y += dimension.height / 2 - dimension2.height / 2;
        this.setLocation(point.x, point.y);
    }

    public void positionDialog(int n, int n2) {
        Point point = new Point(n, n2);
        this.pack();
        Dimension dimension = this.getSize();
        point.y -= dimension.height;
        this.setLocation(point.x, point.y);
    }

    public String getSelection() {
        return this.result;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        frame.setVisible(true);
        String[] stringArray2 = new String[]{"line one", "line two"};
        String[] stringArray3 = new String[]{"button one", "button two"};
        ChoiceDialog choiceDialog = new ChoiceDialog(frame, "Hi", stringArray2, stringArray3, 100, 100);
        String string = choiceDialog.getSelection();
        System.out.println("Returned " + string);
        String[] stringArray4 = new String[]{"You are about to lose changes", "Press OK to discard changes or Cancel to continue editing."};
        String[] stringArray5 = new String[]{"OK", "Cancel"};
        choiceDialog = new ChoiceDialog(frame, "Confirm Action", stringArray4, stringArray5);
        string = choiceDialog.getSelection();
        System.out.println("Returned " + string);
        System.exit(0);
    }

    private class WindowCloseListener
    extends WindowAdapter {
        private WindowCloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ChoiceDialog.this.dispose();
        }
    }
}

