/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataView;
import com.sleepycat.collections.MyRangeCursor;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.JoinConfig;
import com.sleepycat.db.JoinCursor;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;

final class DataCursor
implements Cloneable {
    static final int REPOS_EXACT = 0;
    static final int REPOS_NEXT = 1;
    static final int REPOS_EOF = 2;
    private RangeCursor cursor;
    private JoinCursor joinCursor;
    private DataView view;
    private KeyRange range;
    private boolean writeAllowed;
    private boolean readUncommitted;
    private DatabaseEntry keyThang;
    private DatabaseEntry valueThang;
    private DatabaseEntry primaryKeyThang;
    private DatabaseEntry otherThang;
    private DataCursor[] indexCursorsToClose;

    DataCursor(DataView dataView, boolean bl) throws DatabaseException {
        this.init(dataView, bl, null, null);
    }

    DataCursor(DataView dataView, boolean bl, CursorConfig cursorConfig) throws DatabaseException {
        this.init(dataView, bl, cursorConfig, null);
    }

    DataCursor(DataView dataView, boolean bl, Object object) throws DatabaseException {
        this.init(dataView, bl, null, dataView.subRange(dataView.range, object));
    }

    DataCursor(DataView dataView, boolean bl, Object object, boolean bl2, Object object2, boolean bl3) throws DatabaseException {
        this.init(dataView, bl, null, dataView.subRange(dataView.range, object, bl2, object2, bl3));
    }

    DataCursor(DataView dataView, DataCursor[] dataCursorArray, JoinConfig joinConfig, boolean bl) throws DatabaseException {
        if (dataView.isSecondary()) {
            throw new IllegalArgumentException("The primary collection in a join must not be a secondary database");
        }
        Cursor[] cursorArray = new Cursor[dataCursorArray.length];
        for (int i = 0; i < cursorArray.length; ++i) {
            cursorArray[i] = dataCursorArray[i].cursor.getCursor();
        }
        this.joinCursor = dataView.db.join(cursorArray, joinConfig);
        this.init(dataView, false, null, null);
        if (bl) {
            this.indexCursorsToClose = dataCursorArray;
        }
    }

    DataCursor cloneCursor() throws DatabaseException {
        DataCursor dataCursor;
        this.checkNoJoinCursor();
        try {
            dataCursor = (DataCursor)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        dataCursor.initThangs();
        KeyRange.copy(this.keyThang, dataCursor.keyThang);
        KeyRange.copy(this.valueThang, dataCursor.valueThang);
        if (this.primaryKeyThang != this.keyThang) {
            KeyRange.copy(this.primaryKeyThang, dataCursor.primaryKeyThang);
        }
        dataCursor.cursor = this.cursor.dup(true);
        return dataCursor;
    }

    RangeCursor getCursor() {
        return this.cursor;
    }

    private void init(DataView dataView, boolean bl, CursorConfig cursorConfig, KeyRange keyRange) throws DatabaseException {
        if (cursorConfig == null) {
            cursorConfig = dataView.cursorConfig;
        }
        this.view = dataView;
        this.writeAllowed = bl && dataView.writeAllowed;
        this.range = keyRange != null ? keyRange : dataView.range;
        this.readUncommitted = cursorConfig.getReadUncommitted() || dataView.currentTxn.isReadUncommitted();
        this.initThangs();
        if (this.joinCursor == null) {
            this.cursor = new MyRangeCursor(this.range, cursorConfig, dataView, this.writeAllowed);
        }
    }

    private void initThangs() {
        this.keyThang = new DatabaseEntry();
        this.primaryKeyThang = this.view.isSecondary() ? new DatabaseEntry() : this.keyThang;
        this.valueThang = new DatabaseEntry();
    }

    private void setThangs(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.keyThang.setData(KeyRange.copyBytes(byArray));
        if (this.keyThang != this.primaryKeyThang) {
            this.primaryKeyThang.setData(KeyRange.copyBytes(byArray2));
        }
        this.valueThang.setData(KeyRange.copyBytes(byArray3));
    }

    void close() throws DatabaseException {
        DataCursor[] dataCursorArray;
        if (this.joinCursor != null) {
            dataCursorArray = this.joinCursor;
            this.joinCursor = null;
            dataCursorArray.close();
        }
        if (this.cursor != null) {
            dataCursorArray = this.cursor.getCursor();
            this.cursor = null;
            this.view.currentTxn.closeCursor((Cursor)dataCursorArray);
        }
        if (this.indexCursorsToClose != null) {
            dataCursorArray = this.indexCursorsToClose;
            this.indexCursorsToClose = null;
            for (int i = 0; i < dataCursorArray.length; ++i) {
                dataCursorArray[i].close();
            }
        }
    }

    int repositionRange(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        OperationStatus operationStatus = null;
        this.setThangs(byArray, byArray2, byArray3);
        if (this.view.dupsAllowed) {
            operationStatus = this.cursor.getSearchBothRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        if (operationStatus != OperationStatus.SUCCESS) {
            operationStatus = this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        if (operationStatus == OperationStatus.SUCCESS) {
            if (!KeyRange.equalBytes(byArray, 0, byArray.length, this.keyThang.getData(), this.keyThang.getOffset(), this.keyThang.getSize())) {
                return 1;
            }
            if (this.view.dupsAllowed) {
                byte[] byArray4;
                DatabaseEntry databaseEntry = this.view.isSecondary() ? this.primaryKeyThang : this.valueThang;
                byte[] byArray5 = byArray4 = this.view.isSecondary() ? byArray2 : byArray3;
                if (!KeyRange.equalBytes(byArray4, 0, byArray4.length, databaseEntry.getData(), databaseEntry.getOffset(), databaseEntry.getSize())) {
                    return 1;
                }
            }
            return 0;
        }
        return 2;
    }

    boolean repositionExact(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        OperationStatus operationStatus = null;
        this.setThangs(byArray, byArray2, byArray3);
        operationStatus = this.view.recNumRenumber ? this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode) : this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        return operationStatus == OperationStatus.SUCCESS;
    }

    DataView getView() {
        return this.view;
    }

    KeyRange getRange() {
        return this.range;
    }

    boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    Object getCurrentKey() {
        return this.view.makeKey(this.keyThang, this.primaryKeyThang);
    }

    Object getCurrentValue() {
        return this.view.makeValue(this.primaryKeyThang, this.valueThang);
    }

    DatabaseEntry getKeyThang() {
        return this.keyThang;
    }

    DatabaseEntry getPrimaryKeyThang() {
        return this.primaryKeyThang;
    }

    DatabaseEntry getValueThang() {
        return this.valueThang;
    }

    boolean hasRecNumAccess() {
        return this.view.recNumAccess;
    }

    int getCurrentRecordNumber() throws DatabaseException {
        if (this.view.btreeRecNumDb) {
            if (this.otherThang == null) {
                this.otherThang = new DatabaseEntry();
            }
            DbCompat.getCurrentRecordNumber(this.cursor.getCursor(), this.otherThang, this.getLockMode(false));
            return DbCompat.getRecordNumber(this.otherThang);
        }
        return DbCompat.getRecordNumber(this.keyThang);
    }

    OperationStatus getCurrent(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getFirst(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getFirst(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNext(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNextNoDup(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.joinCursor != null) {
            return this.joinCursor.getNext(this.keyThang, this.valueThang, lockMode);
        }
        if (this.view.dupsView) {
            return this.cursor.getNext(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getNextNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getNextDup(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getLast(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getLast(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getPrev(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        return this.cursor.getPrev(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getPrevNoDup(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(bl);
        if (this.view.dupsView) {
            return null;
        }
        if (this.view.dupsView) {
            return this.cursor.getPrev(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getPrevNoDup(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getPrevDup(boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return null;
        }
        return this.cursor.getPrevDup(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
    }

    OperationStatus getSearchKey(Object object, Object object2, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            if (this.view.useKey(object, object2, this.primaryKeyThang, this.view.dupsRange)) {
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                return this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(bl));
            }
        } else if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            return this.doGetSearchKey(bl);
        }
        return OperationStatus.NOTFOUND;
    }

    private OperationStatus doGetSearchKey(boolean bl) throws DatabaseException {
        LockMode lockMode = this.getLockMode(bl);
        if (this.view.btreeRecNumAccess) {
            return this.cursor.getSearchRecordNumber(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
    }

    OperationStatus getSearchKeyRange(Object object, Object object2, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(bl);
        if (this.view.dupsView) {
            if (this.view.useKey(object, object2, this.primaryKeyThang, this.view.dupsRange)) {
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                return this.cursor.getSearchBothRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
            }
        } else if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            return this.cursor.getSearchKeyRange(this.keyThang, this.primaryKeyThang, this.valueThang, lockMode);
        }
        return OperationStatus.NOTFOUND;
    }

    OperationStatus findBoth(Object object, Object object2, boolean bl) throws DatabaseException {
        this.checkNoJoinCursor();
        LockMode lockMode = this.getLockMode(bl);
        this.view.useValue(object2, this.valueThang, null);
        if (this.view.dupsView) {
            if (this.view.useKey(object, object2, this.primaryKeyThang, this.view.dupsRange)) {
                OperationStatus operationStatus;
                KeyRange.copy(this.view.dupsKey, this.keyThang);
                if (this.otherThang == null) {
                    this.otherThang = new DatabaseEntry();
                }
                if ((operationStatus = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode)) == OperationStatus.SUCCESS && KeyRange.equalBytes(this.otherThang, this.valueThang)) {
                    return operationStatus;
                }
            }
        } else if (this.view.useKey(object, object2, this.keyThang, this.range)) {
            if (this.view.isSecondary()) {
                if (this.otherThang == null) {
                    this.otherThang = new DatabaseEntry();
                }
                OperationStatus operationStatus = this.cursor.getSearchKey(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode);
                while (operationStatus == OperationStatus.SUCCESS) {
                    if (KeyRange.equalBytes(this.otherThang, this.valueThang)) {
                        return operationStatus;
                    }
                    operationStatus = this.cursor.getNextDup(this.keyThang, this.primaryKeyThang, this.otherThang, lockMode);
                }
            } else {
                return this.cursor.getSearchBoth(this.keyThang, null, this.valueThang, lockMode);
            }
        }
        return OperationStatus.NOTFOUND;
    }

    OperationStatus findValue(Object object, boolean bl) throws DatabaseException {
        OperationStatus operationStatus;
        this.checkNoJoinCursor();
        if (!(this.view.entityBinding == null || this.view.isSecondary() || !bl && this.view.dupsAllowed)) {
            return this.findBoth(null, object, false);
        }
        if (this.otherThang == null) {
            this.otherThang = new DatabaseEntry();
        }
        this.view.useValue(object, this.otherThang, null);
        OperationStatus operationStatus2 = operationStatus = bl ? this.getFirst(false) : this.getLast(false);
        while (operationStatus == OperationStatus.SUCCESS && !KeyRange.equalBytes(this.valueThang, this.otherThang)) {
            operationStatus = bl ? this.getNext(false) : this.getPrev(false);
        }
        return operationStatus;
    }

    int count() throws DatabaseException {
        this.checkNoJoinCursor();
        if (this.view.dupsView) {
            return 1;
        }
        return this.cursor.count();
    }

    OperationStatus putCurrent(Object object) throws DatabaseException {
        boolean bl;
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, this.keyThang);
        boolean bl2 = bl = this.view.dupsOrdered && !this.view.ordered;
        if (bl) {
            if (this.otherThang == null) {
                this.otherThang = new DatabaseEntry();
            }
            this.cursor.getCurrent(this.keyThang, this.primaryKeyThang, this.otherThang, LockMode.DEFAULT);
            if (KeyRange.equalBytes(this.valueThang, this.otherThang)) {
                return OperationStatus.SUCCESS;
            }
            throw new IllegalArgumentException("Current data differs from put data with sorted duplicates");
        }
        return this.cursor.putCurrent(this.valueThang);
    }

    OperationStatus putAfter(Object object) throws DatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, null);
        return this.cursor.putAfter(this.keyThang, this.valueThang);
    }

    OperationStatus putBefore(Object object) throws DatabaseException {
        this.checkWriteAllowed(false);
        this.view.useValue(object, this.valueThang, this.keyThang);
        return this.cursor.putBefore(this.keyThang, this.valueThang);
    }

    OperationStatus put(Object object, Object object2, Object[] objectArray, boolean bl) throws DatabaseException {
        this.initForPut(object, object2, objectArray, bl);
        return this.cursor.put(this.keyThang, this.valueThang);
    }

    OperationStatus putNoOverwrite(Object object, Object object2, boolean bl) throws DatabaseException {
        this.initForPut(object, object2, null, bl);
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    OperationStatus putNoDupData(Object object, Object object2, Object[] objectArray, boolean bl) throws DatabaseException {
        this.initForPut(object, object2, objectArray, bl);
        if (this.view.dupsOrdered) {
            return this.cursor.putNoDupData(this.keyThang, this.valueThang);
        }
        if (this.view.dupsAllowed) {
            OperationStatus operationStatus = this.cursor.getSearchBoth(this.keyThang, this.primaryKeyThang, this.valueThang, this.getLockMode(false));
            if (operationStatus == OperationStatus.SUCCESS) {
                return OperationStatus.KEYEXIST;
            }
            return this.cursor.put(this.keyThang, this.valueThang);
        }
        return this.cursor.putNoOverwrite(this.keyThang, this.valueThang);
    }

    private void initForPut(Object object, Object object2, Object[] objectArray, boolean bl) throws DatabaseException {
        this.checkWriteAllowed(false);
        if (!bl && !this.view.useKey(object, object2, this.keyThang, this.range)) {
            throw new IllegalArgumentException("key out of range");
        }
        if (objectArray != null) {
            OperationStatus operationStatus;
            objectArray[0] = null;
            if (!this.view.dupsAllowed && (operationStatus = this.doGetSearchKey(true)) == OperationStatus.SUCCESS) {
                objectArray[0] = this.getCurrentValue();
            }
        }
        this.view.useValue(object2, this.valueThang, this.keyThang);
    }

    void useRangeKey() {
        if (!this.range.isSingleKey()) {
            throw DbCompat.unexpectedState();
        }
        KeyRange.copy(this.range.getSingleKey(), this.keyThang);
    }

    OperationStatus delete() throws DatabaseException {
        this.checkWriteAllowed(true);
        return this.cursor.delete();
    }

    LockMode getLockMode(boolean bl) {
        if (this.readUncommitted) {
            return LockMode.READ_UNCOMMITTED;
        }
        if (bl) {
            return this.view.currentTxn.getWriteLockMode();
        }
        return LockMode.DEFAULT;
    }

    private void checkNoJoinCursor() {
        if (this.joinCursor != null) {
            throw new UnsupportedOperationException("Not allowed with a join cursor");
        }
    }

    private void checkWriteAllowed(boolean bl) {
        this.checkNoJoinCursor();
        if (!this.writeAllowed || !bl && this.view.isSecondary()) {
            throw new UnsupportedOperationException("Writing is not allowed");
        }
    }
}

