/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.asm;

import com.sleepycat.asm.ByteVector;
import com.sleepycat.asm.Edge;
import com.sleepycat.asm.Frame;
import com.sleepycat.asm.MethodWriter;

public class Label {
    static final int DEBUG = 1;
    static final int RESOLVED = 2;
    static final int RESIZED = 4;
    static final int PUSHED = 8;
    static final int TARGET = 16;
    static final int STORE = 32;
    static final int REACHABLE = 64;
    static final int JSR = 128;
    static final int RET = 256;
    static final int SUBROUTINE = 512;
    static final int VISITED = 1024;
    static final int VISITED2 = 2048;
    public Object info;
    int status;
    int line;
    int position;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int inputStackTop;
    int outputStackMax;
    Frame frame;
    Label successor;
    Edge successors;
    Label next;

    public int getOffset() {
        if ((this.status & 2) == 0) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.position;
    }

    void put(MethodWriter methodWriter, ByteVector byteVector, int n, boolean bl) {
        if ((this.status & 2) == 0) {
            if (bl) {
                this.addReference(-1 - n, byteVector.length);
                byteVector.putInt(-1);
            } else {
                this.addReference(n, byteVector.length);
                byteVector.putShort(-1);
            }
        } else if (bl) {
            byteVector.putInt(this.position - n);
        } else {
            byteVector.putShort(this.position - n);
        }
    }

    private void addReference(int n, int n2) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] nArray = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, nArray, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = nArray;
        }
        this.srcAndRefPositions[this.referenceCount++] = n;
        this.srcAndRefPositions[this.referenceCount++] = n2;
    }

    boolean resolve(MethodWriter methodWriter, int n, byte[] byArray) {
        boolean bl = false;
        this.status |= 2;
        this.position = n;
        int n2 = 0;
        while (n2 < this.referenceCount) {
            int n3;
            int n4 = this.srcAndRefPositions[n2++];
            int n5 = this.srcAndRefPositions[n2++];
            if (n4 >= 0) {
                n3 = n - n4;
                if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                    int n6 = byArray[n5 - 1] & 0xFF;
                    byArray[n5 - 1] = n6 <= 168 ? (byte)(n6 + 49) : (byte)(n6 + 20);
                    bl = true;
                }
                byArray[n5++] = (byte)(n3 >>> 8);
                byArray[n5] = (byte)n3;
                continue;
            }
            n3 = n + n4 + 1;
            byArray[n5++] = (byte)(n3 >>> 24);
            byArray[n5++] = (byte)(n3 >>> 16);
            byArray[n5++] = (byte)(n3 >>> 8);
            byArray[n5] = (byte)n3;
        }
        return bl;
    }

    Label getFirst() {
        return this.frame == null ? this : this.frame.owner;
    }

    boolean inSubroutine(long l) {
        if ((this.status & 0x400) != 0) {
            return (this.srcAndRefPositions[(int)(l >>> 32)] & (int)l) != 0;
        }
        return false;
    }

    boolean inSameSubroutine(Label label) {
        if ((this.status & 0x400) == 0 || (label.status & 0x400) == 0) {
            return false;
        }
        for (int i = 0; i < this.srcAndRefPositions.length; ++i) {
            if ((this.srcAndRefPositions[i] & label.srcAndRefPositions[i]) == 0) continue;
            return true;
        }
        return false;
    }

    void addToSubroutine(long l, int n) {
        if ((this.status & 0x400) == 0) {
            this.status |= 0x400;
            this.srcAndRefPositions = new int[(n - 1) / 32 + 1];
        }
        int n2 = (int)(l >>> 32);
        this.srcAndRefPositions[n2] = this.srcAndRefPositions[n2] | (int)l;
    }

    void visitSubroutine(Label label, long l, int n) {
        Label label2 = this;
        while (label2 != null) {
            Edge edge;
            Label label3 = label2;
            label2 = label3.next;
            label3.next = null;
            if (label != null) {
                if ((label3.status & 0x800) != 0) continue;
                label3.status |= 0x800;
                if ((label3.status & 0x100) != 0 && !label3.inSameSubroutine(label)) {
                    edge = new Edge();
                    edge.info = label3.inputStackTop;
                    edge.successor = label.successors.successor;
                    edge.next = label3.successors;
                    label3.successors = edge;
                }
            } else {
                if (label3.inSubroutine(l)) continue;
                label3.addToSubroutine(l, n);
            }
            edge = label3.successors;
            while (edge != null) {
                if (((label3.status & 0x80) == 0 || edge != label3.successors.next) && edge.successor.next == null) {
                    edge.successor.next = label2;
                    label2 = edge.successor;
                }
                edge = edge.next;
            }
        }
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

