/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.zonemgr;

import com.oracle.solaris.rad.client.ADRName;
import com.oracle.solaris.rad.client.AttributeError;
import com.oracle.solaris.rad.client.EventMapping;
import com.oracle.solaris.rad.client.FeatureStability;
import com.oracle.solaris.rad.client.Interface;
import com.oracle.solaris.rad.client.IsNullable;
import com.oracle.solaris.rad.client.RadException;
import com.oracle.solaris.rad.client.Stability;
import com.oracle.solaris.rad.client.Version;
import com.oracle.solaris.rad.connect.Connection;
import com.oracle.solaris.rad.zonemgr.ConfigChange;
import com.oracle.solaris.rad.zonemgr.Property;
import com.oracle.solaris.rad.zonemgr.Resource;
import com.oracle.solaris.rad.zonemgr.Result;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@EventMapping(names={"configChange"}, clazzes={ConfigChange.class}, sclazzes={Void.class}, vclazzes={Void.class})
@FeatureStability(value=Stability.PRIVATE)
public class Zone
extends Interface {
    public static final String TYPE = "Zone";
    public static final String DOMAIN = "com.oracle.solaris.rad.zonemgr";
    public static final int MAJOR = 1;
    public static final int MINOR = 2;
    public static final Version VERSION = new Version(1, 2);
    public static final Map<String, String> KVS = new HashMap<String, String>();

    public Zone() {
        super(null, -1L, new ADRName(DOMAIN, KVS), VERSION);
    }

    public Zone(Connection connection, long l, ADRName aDRName, Version version) {
        super(connection, l, aDRName, version);
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void cancelConfig() throws RadException {
        this.invoke("cancelConfig");
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public String exportConfig(@IsNullable Boolean bl, @IsNullable Boolean bl2) throws RadException {
        return (String)this.invoke("exportConfig", new Class[]{Boolean.class, Boolean.class}, new Object[]{bl, bl2});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void update(Boolean bl, List<String> list) throws RadException {
        this.invoke("update", new Class[]{Boolean.class, List.class}, new Object[]{bl, list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void editConfig(@IsNullable Boolean bl) throws RadException {
        this.invoke("editConfig", new Class[]{Boolean.class}, new Object[]{bl});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void commitConfig() throws RadException {
        this.invoke("commitConfig");
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Boolean configIsLive() {
        return (Boolean)this.invoke("configIsLive");
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Boolean configIsStale() throws RadException {
        return (Boolean)this.invoke("configIsStale");
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void addResource(Resource resource, @IsNullable Resource resource2) throws RadException {
        this.invoke("addResource", new Class[]{Resource.class, Resource.class}, new Object[]{resource, resource2});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void reloadConfig(@IsNullable Boolean bl) throws RadException {
        this.invoke("reloadConfig", new Class[]{Boolean.class}, new Object[]{bl});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void removeResources(Resource resource, @IsNullable Resource resource2) throws RadException {
        this.invoke("removeResources", new Class[]{Resource.class, Resource.class}, new Object[]{resource, resource2});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<Resource> getResources(@IsNullable Resource resource, @IsNullable Resource resource2) throws RadException {
        return (List)this.invoke("getResources", new Class[]{Resource.class, Resource.class}, new Object[]{resource, resource2});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<Property> getResourceProperties(Resource resource, @IsNullable List<String> list) throws RadException {
        return (List)this.invoke("getResourceProperties", new Class[]{Resource.class, List.class}, new Object[]{resource, list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void setResourceProperties(Resource resource, List<Property> list) throws RadException {
        this.invoke("setResourceProperties", new Class[]{Resource.class, List.class}, new Object[]{resource, list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public void clearResourceProperties(Resource resource, List<String> list) throws RadException {
        this.invoke("clearResourceProperties", new Class[]{Resource.class, List.class}, new Object[]{resource, list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result apply(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("apply", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result attach(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("attach", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result boot(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("boot", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result clone(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("clone", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result detach(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("detach", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result halt(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("halt", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result install(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("install", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result mark(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("mark", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result migrate(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("migrate", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result move(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("move", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result rename(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("rename", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result ready(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("ready", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result reboot(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("reboot", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result savecore(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("savecore", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result shutdown(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("shutdown", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result suspend(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("suspend", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result uninstall(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("uninstall", new Class[]{List.class}, new Object[]{list});
    }

    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Result verify(@IsNullable List<String> list) throws RadException {
        return (Result)this.invoke("verify", new Class[]{List.class}, new Object[]{list});
    }

    @IsNullable
    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public List<String> getauxstate() throws RadException {
        return (List)this.getattr("auxstate");
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public String getbrand() {
        return (String)this.getattr("brand");
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public Integer getid() {
        return (Integer)this.getattr("id");
    }

    @IsNullable
    @AttributeError(clazz=Result.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public String getuuid() throws RadException {
        return (String)this.getattr("uuid");
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public String getname() {
        return (String)this.getattr("name");
    }

    @AttributeError(clazz=Void.class, cclazz={Void.class, Void.class}, is_nullable=false)
    @FeatureStability(value=Stability.PRIVATE)
    public String getstate() {
        return (String)this.getattr("state");
    }

    static {
        KVS.put("type", TYPE);
    }
}

