/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.solaris.rad.transports;

import com.oracle.solaris.rad.transports.UnixDomainSocket;
import com.oracle.solaris.rad.transports.UnixSocket;
import com.oracle.solaris.rad.transports.UnixSocketClosedException;
import java.io.IOException;
import java.io.InterruptedIOException;

public class UnixSocketServer {
    private boolean closed_ = false;
    private boolean accepting_ = false;
    private boolean closeme_ = false;
    private int fd_;

    private native int socket_accept(int var1) throws IOException;

    UnixSocketServer(int n) {
        this.fd_ = n;
    }

    protected void finalize() throws Throwable {
        if (!this.closed_) {
            this.closed_ = true;
            UnixDomainSocket.server_close(this.fd_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnixSocket accept() throws IOException {
        int n;
        Object object = this;
        synchronized (object) {
            try {
                while (this.accepting_) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            if (this.closed_) {
                throw new UnixSocketClosedException("accept on");
            }
            this.accepting_ = true;
        }
        try {
            n = this.socket_accept(this.fd_);
        }
        finally {
            object = this;
            synchronized (object) {
                this.accepting_ = false;
                this.notifyAll();
                if (this.closeme_) {
                    UnixDomainSocket.server_close(this.fd_);
                    this.closeme_ = false;
                    this.closed_ = true;
                }
            }
        }
        object = null;
        try {
            object = new UnixSocket(n);
        }
        finally {
            if (object == null) {
                UnixDomainSocket.socket_close(n);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        UnixSocketServer unixSocketServer = this;
        synchronized (unixSocketServer) {
            if (this.closed_) {
                return;
            }
            if (this.accepting_) {
                this.closeme_ = true;
                UnixDomainSocket.socket_goose(this.fd_);
                return;
            }
            this.closed_ = true;
            UnixDomainSocket.server_close(this.fd_);
        }
    }
}

